/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.functionApproximation.bestFitting;

import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.LinearFunctionSpace;
import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.LinearFunctionSpaceFactory;
import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.Sample;

public class LinearFunctionSpaceElement {
    final LinearFunctionSpace space;
    final double[] coefficient;

    public LinearFunctionSpaceElement(LinearFunctionSpace linearFunctionSpace) {
        this.space = linearFunctionSpace;
        this.coefficient = new double[linearFunctionSpace.getDimension()];
    }

    public LinearFunctionSpaceElement(LinearFunctionSpace linearFunctionSpace, double[] dArray) {
        this.space = linearFunctionSpace;
        this.coefficient = (double[])dArray.clone();
    }

    public void eval(double[] dArray, double[] dArray2) {
        this.space.eval(dArray, this.coefficient, dArray2);
    }

    public double[] getCoefficients() {
        return (double[])this.coefficient.clone();
    }

    public LinearFunctionSpace getApproximationFunctionSpace() {
        return this.space;
    }

    static final void minus(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] - dArray2[i];
        }
    }

    static final double absSqr(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray[i];
        }
        return d;
    }

    public Sample[] getDeviationSamples(Sample[] sampleArray) {
        int n = sampleArray.length;
        Sample[] sampleArray2 = new Sample[n];
        double[] dArray = new double[this.space.m];
        for (int i = 0; i < n; ++i) {
            this.eval(sampleArray[i].x, dArray);
            LinearFunctionSpaceElement.minus(sampleArray[i].y, dArray, dArray);
            sampleArray2[i] = new Sample(sampleArray[i].x, dArray, sampleArray[i].weight);
        }
        return sampleArray2;
    }

    public double getAverageDeviation(Sample[] sampleArray) {
        int n = sampleArray.length;
        if (n == 0) {
            return 0.0;
        }
        double[] dArray = new double[this.space.m];
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            this.eval(sampleArray[i].x, dArray);
            LinearFunctionSpaceElement.minus(dArray, sampleArray[i].y, dArray);
            d += Math.sqrt(LinearFunctionSpaceElement.absSqr(dArray));
        }
        return d / (double)n;
    }

    public double getMaximalDeviation(Sample[] sampleArray) {
        int n = sampleArray.length;
        if (n == 0) {
            return 0.0;
        }
        double[] dArray = new double[this.space.m];
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            this.eval(sampleArray[i].x, dArray);
            LinearFunctionSpaceElement.minus(dArray, sampleArray[i].y, dArray);
            double d2 = Math.sqrt(LinearFunctionSpaceElement.absSqr(dArray));
            if (!(d < d2)) continue;
            d = d2;
        }
        return d;
    }

    public StringBuffer componentString(int n) {
        StringBuffer stringBuffer = new StringBuffer(300);
        boolean bl = true;
        for (int i = 0; i < this.space.dim; ++i) {
            double d = this.coefficient[i * this.space.m + n];
            if (d == 0.0 || this.space.f[i][n].isZero()) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" +");
            }
            stringBuffer.append(" ( " + this.coefficient[i * this.space.m + n] + ") * ( " + this.space.f[i][n].toString() + " )");
        }
        if (bl) {
            stringBuffer.append(" 0 ");
        }
        return stringBuffer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("{\n");
        for (int i = 0; i < this.space.m; ++i) {
            stringBuffer.append("\t y[" + i + "] = " + this.componentString(i));
            stringBuffer.append(";\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public LinearFunctionSpaceElement getPartialDerivative(int n) {
        return new LinearFunctionSpaceElement(LinearFunctionSpaceFactory.createPartialDerivative(this.space, n), this.coefficient);
    }
}

