/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.functionApproximation;

import de.jtem.numericalMethods.calculus.functionApproximation.RealFunction;

public class ChebyshevApproximation {
    private ChebyshevApproximation() {
    }

    public static void fit(double[] dArray, RealFunction realFunction) {
        int n;
        int n2 = dArray.length;
        double d = 2.0 / (double)n2;
        double d2 = Math.PI / (double)n2;
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray2[n] = realFunction.valueAt(Math.cos(d2 * ((double)n + 0.5)));
        }
        for (n = 0; n < n2; ++n) {
            double d3 = 0.0;
            for (int i = 0; i < n2; ++i) {
                d3 += dArray2[i] * Math.cos(d2 * (double)n * ((double)i + 0.5));
            }
            dArray[n] = d * d3;
        }
    }

    public static double evaluate(double[] dArray, double d) throws IllegalArgumentException {
        if (d < -1.0 || d > 1.0) {
            throw new IllegalArgumentException("Argument x = " + d + " not in range: " + "-1.0 <= x <= 1.0 expected.");
        }
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = dArray.length - 1; i >= 0; --i) {
            double d4 = dArray[i] - d2;
            d2 = 2.0 * d * d2 + d3;
            d3 = d4;
        }
        return d2 * d + d3 - dArray[0] / 2.0;
    }

    public static void integrate(double[] dArray, double[] dArray2) {
        ChebyshevApproximation.integrate(dArray, dArray2, 1.0);
    }

    public static void integrate(double[] dArray, double[] dArray2, double d) throws IllegalArgumentException {
        int n = dArray.length;
        if (dArray2.length != n) {
            throw new IllegalArgumentException("Incompatible Arguments: c.length == cInt.length expected.");
        }
        double d2 = 0.5 * d;
        for (int i = 1; i < n - 1; ++i) {
            dArray2[i] = d2 * (dArray[i - 1] - dArray[i + 1]) / (double)i;
        }
        dArray2[n - 1] = d2 * dArray[n - 2] / (double)(n - 1);
        dArray2[0] = dArray2[0] - 2.0 * ChebyshevApproximation.evaluate(dArray2, 0.0);
    }

    public static void divideByX(double[] dArray) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        for (n = dArray.length - 1; n > 0; --n) {
            dArray[n] = 2.0 * dArray[n] - d;
            d = d2;
            d2 = dArray[n];
        }
        for (n = 0; n < dArray.length - 1; ++n) {
            dArray[n] = dArray[n + 1];
        }
        dArray[dArray.length - 1] = 0.0;
    }
}

