/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

import de.jtem.numericalMethods.algebra.linear.decompose.Unmerge;

public class LR {
    public static double decompose(double[][] dArray) {
        int n = dArray.length;
        double d = 1.0;
        for (int i = 0; i < n; ++i) {
            int n2;
            for (int j = i; j < n; ++j) {
                for (int k = 0; k < i; ++k) {
                    double[] dArray2 = dArray[i];
                    int n3 = j;
                    dArray2[n3] = dArray2[n3] - dArray[i][k] * dArray[k][j];
                }
            }
            double d2 = dArray[i][i];
            d *= d2;
            if (d2 != 0.0) {
                for (n2 = i + 1; n2 < n; ++n2) {
                    double d3 = 0.0;
                    for (int j = 0; j < i; ++j) {
                        d3 += dArray[n2][j] * dArray[j][i];
                    }
                    dArray[n2][i] = (dArray[n2][i] - d3) / d2;
                }
                continue;
            }
            for (n2 = i + 1; n2 < n; ++n2) {
                dArray[n2][i] = 0.0;
            }
        }
        return d;
    }

    public static double decompose(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
        double d = LR.decompose(dArray2);
        Unmerge.triangular(dArray2, dArray3);
        return d;
    }

    public static double[] decompose(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        double[] dArray3 = new double[]{1.0, 0.0};
        for (int i = 0; i < n; ++i) {
            int n2;
            double d;
            int n3 = i;
            while (n3 < n) {
                double d2 = 0.0;
                double d3 = 0.0;
                for (int j = 0; j < i; ++j) {
                    double d4 = dArray[i][j];
                    double d5 = dArray2[i][j];
                    double d6 = dArray[j][n3];
                    d = dArray2[j][n3];
                    d2 += d4 * d6 - d5 * d;
                    d3 += d5 * d6 + d4 * d;
                }
                double[] dArray4 = dArray[i];
                int n4 = n3;
                dArray4[n4] = dArray4[n4] - d2;
                double[] dArray5 = dArray2[i];
                int n5 = n3++;
                dArray5[n5] = dArray5[n5] - d3;
            }
            double d7 = dArray[i][i];
            double d8 = dArray2[i][i];
            double d9 = dArray3[0] * d7 - dArray3[1] * d8;
            dArray3[1] = dArray3[0] * d8 + dArray3[1] * d7;
            dArray3[0] = d9;
            d9 = d7 * d7 + d8 * d8;
            if (d9 != 0.0) {
                for (n2 = i + 1; n2 < n; ++n2) {
                    double d10 = 0.0;
                    double d11 = 0.0;
                    for (int j = 0; j < i; ++j) {
                        d = dArray[n2][j];
                        double d12 = dArray2[n2][j];
                        double d13 = dArray[j][i];
                        double d14 = dArray2[j][i];
                        d10 += d * d13 - d12 * d14;
                        d11 += d12 * d13 + d * d14;
                    }
                    d10 = dArray[n2][i] - d10;
                    d11 = dArray2[n2][i] - d11;
                    dArray[n2][i] = (d10 * d7 + d11 * d8) / d9;
                    dArray2[n2][i] = (d11 * d7 - d10 * d8) / d9;
                }
                continue;
            }
            for (n2 = i + 1; n2 < n; ++n2) {
                dArray[n2][i] = 0.0;
                dArray2[n2][i] = 0.0;
            }
        }
        return dArray3;
    }

    public static double[] decompose(double[][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4, double[][] dArray5, double[][] dArray6) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray3[i][j] = dArray[i][j];
                dArray4[i][j] = dArray2[i][j];
            }
        }
        double[] dArray7 = LR.decompose(dArray3, dArray4);
        Unmerge.triangular(dArray3, dArray4, dArray5, dArray6);
        return dArray7;
    }
}

