/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.program.das.DAS;
import org.biojava.bio.program.das.DASCapabilities;
import org.biojava.bio.program.das.DASSequence;
import org.biojava.bio.program.das.DASSequenceDB;
import org.biojava.bio.program.das.Segment;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Unchangeable;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.SAX2StAXAdaptor;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class DASRawSymbolList
extends Unchangeable
implements SymbolList {
    private DASSequence sequence;
    private Segment segment;
    private SymbolList rawSymbols;

    DASRawSymbolList(DASSequence seq, Segment seg) {
        this.sequence = seq;
        this.segment = seg;
    }

    public Alphabet getAlphabet() {
        return this.getRawSymbols().getAlphabet();
    }

    public int length() {
        if (this.segment.isBounded()) {
            return this.segment.getStop() - this.segment.getStart() + 1;
        }
        return this.getRawSymbols().length();
    }

    public Iterator iterator() {
        return this.getRawSymbols().iterator();
    }

    public Symbol symbolAt(int i) {
        return this.getRawSymbols().symbolAt(i);
    }

    public SymbolList subList(int start, int end) {
        return this.getRawSymbols().subList(start, end);
    }

    public List toList() {
        return this.getRawSymbols().toList();
    }

    public String seqString() {
        return this.getRawSymbols().seqString();
    }

    public String subStr(int start, int end) {
        return this.getRawSymbols().subStr(start, end);
    }

    public void edit(Edit edit) throws ChangeVetoException {
        throw new ChangeVetoException("Can't edit sequence");
    }

    protected SymbolList getRawSymbols() {
        if (this.rawSymbols == null) {
            try {
                DAS.startedActivity(this);
                String seqRequest = "dna";
                if (DASCapabilities.checkCapable(new URL(this.sequence.getDataSourceURL(), ".."), "sequence")) {
                    seqRequest = "sequence";
                }
                StringBuffer qb = new StringBuffer();
                qb.append(seqRequest);
                qb.append("?segment=");
                qb.append(this.segment.getID());
                if (this.segment.isBounded()) {
                    qb.append(':');
                    qb.append(this.segment.getStart());
                    qb.append(',');
                    qb.append(this.segment.getStop());
                }
                URL dnaURL = new URL(this.sequence.getDataSourceURL(), qb.substring(0));
                HttpURLConnection huc = (HttpURLConnection)dnaURL.openConnection();
                huc.setRequestProperty("Accept-Encoding", "gzip");
                huc.connect();
                int status = DASSequenceDB.tolerantIntHeader(huc, "X-DAS-Status");
                if (status == 0) {
                    throw new BioRuntimeException("Not a DAS server");
                }
                if (status != 200) {
                    throw new BioRuntimeException("DAS error (status code = " + status + ")");
                }
                SimpleSequenceBuilder sb = new SimpleSequenceBuilder();
                sb.setURI(dnaURL.toString());
                sb.setName(this.sequence.getName());
                SequenceHandler seqHandler = new SequenceHandler(sb, seqRequest);
                String contentEncoding = huc.getContentEncoding();
                InputStream inStream = huc.getInputStream();
                if (contentEncoding != null && contentEncoding.indexOf("gzip") != -1) {
                    inStream = new GZIPInputStream(inStream);
                }
                InputSource is = new InputSource(inStream);
                is.setSystemId(dnaURL.toString());
                XMLReader parser = DASSequence.nonvalidatingSAXParser();
                parser.setContentHandler(new SAX2StAXAdaptor(seqHandler));
                parser.parse(is);
                this.rawSymbols = sb.makeSequence();
            }
            catch (SAXException ex) {
                throw new BioRuntimeException("Exception parsing DAS XML", ex);
            }
            catch (IOException ex) {
                throw new BioRuntimeException("Error connecting to DAS server", ex);
            }
            catch (BioException ex) {
                throw new BioRuntimeException(ex);
            }
            finally {
                DAS.completedActivity(this);
            }
        }
        return this.rawSymbols;
    }

    private class SymbolsHandler
    extends StAXContentHandlerBase {
        private StreamParser ssparser;

        SymbolsHandler(StreamParser ssparser) {
            this.ssparser = ssparser;
        }

        public void endElement(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
            try {
                this.ssparser.close();
            }
            catch (IllegalSymbolException ex) {
                throw new SAXException(ex);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                int parseStart = start;
                int parseEnd = start;
                int blockEnd = start + length;
                while (parseStart < blockEnd) {
                    while (parseStart < blockEnd && Character.isWhitespace(ch[parseStart])) {
                        ++parseStart;
                    }
                    if (parseStart >= blockEnd) {
                        return;
                    }
                    for (parseEnd = parseStart + 1; parseEnd < blockEnd && !Character.isWhitespace(ch[parseEnd]); ++parseEnd) {
                    }
                    this.ssparser.characters(ch, parseStart, parseEnd - parseStart);
                    parseStart = parseEnd;
                }
            }
            catch (IllegalSymbolException ex) {
                throw new SAXException(ex);
            }
        }
    }

    private class SequenceHandler
    extends StAXContentHandlerBase {
        private SequenceBuilder sbuilder;
        private String requestType;

        SequenceHandler(SequenceBuilder sbuilder, String requestType) {
            this.sbuilder = sbuilder;
            this.requestType = requestType;
        }

        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            if (localName.equals("DNA")) {
                SymbolTokenization toke;
                try {
                    toke = DNATools.getDNA().getTokenization("token");
                }
                catch (Exception ex) {
                    throw new SAXException("Couldn't get DNA tokenization");
                }
                StreamParser sparser = toke.parseStream(this.sbuilder);
                dm.delegate(new SymbolsHandler(sparser));
            } else if ("sequence".equals(this.requestType) && "SEQUENCE".equals(localName)) {
                SymbolTokenization toke;
                String moltype = attrs.getValue("moltype");
                FiniteAlphabet alpha = null;
                if ("DNA".equalsIgnoreCase(moltype)) {
                    alpha = DNATools.getDNA();
                } else if ("ssRNA".equalsIgnoreCase(moltype) || "dsRNA".equalsIgnoreCase(moltype)) {
                    alpha = RNATools.getRNA();
                } else if ("Protein".equalsIgnoreCase(moltype)) {
                    alpha = ProteinTools.getTAlphabet();
                } else {
                    throw new SAXException("Unknown moltype " + moltype);
                }
                try {
                    toke = alpha.getTokenization("token");
                }
                catch (Exception ex) {
                    throw new SAXException("Couldn't get tokenization for " + moltype);
                }
                StreamParser sparser = toke.parseStream(this.sbuilder);
                dm.delegate(new SymbolsHandler(sparser));
            }
        }
    }
}

