/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.solve;

import de.jtem.numericalMethods.algebra.linear.decompose.Householder;
import de.jtem.numericalMethods.algebra.linear.solve.RXB;

public class AXB {
    public static boolean solve(double[][] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = dArray[0].length;
        if (dArray3 == null) {
            dArray3 = new double[n];
        }
        if (Householder.decompose(dArray, dArray3, dArray4) == 0.0) {
            return false;
        }
        Householder.qTimes(dArray, dArray2, true);
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = dArray3[i];
        }
        return RXB.solve(dArray, dArray2);
    }

    public static boolean solve(double[][] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[] dArray4 = new double[n];
        double[][] dArray5 = new double[n][n2];
        System.arraycopy(dArray3, 0, dArray4, 0, n);
        for (int i = 0; i < n; ++i) {
            System.arraycopy(dArray[i], 0, dArray5[i], 0, n2);
        }
        if (!AXB.solve(dArray5, dArray4, new double[n2], new double[n2])) {
            return false;
        }
        System.arraycopy(dArray4, 0, dArray2, 0, n2);
        return true;
    }

    public static boolean solve(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8) {
        double[] dArray9;
        int n = dArray[0].length;
        if (dArray5 == null) {
            dArray5 = new double[n];
        }
        if (dArray6 == null) {
            dArray6 = new double[n];
        }
        if ((dArray9 = Householder.decompose(dArray, dArray2, dArray5, dArray6, dArray7, dArray8))[0] == 0.0 && dArray9[1] == 0.0) {
            return false;
        }
        Householder.qTimes(dArray, dArray2, dArray3, dArray4, true);
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = dArray5[i];
            dArray2[i][i] = dArray6[i];
        }
        return RXB.solve(dArray, dArray2, dArray3, dArray4);
    }

    public static boolean solve(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n];
        double[][] dArray9 = new double[n][n2];
        double[][] dArray10 = new double[n][n2];
        System.arraycopy(dArray5, 0, dArray7, 0, n);
        System.arraycopy(dArray6, 0, dArray8, 0, n);
        for (int i = 0; i < n; ++i) {
            System.arraycopy(dArray[i], 0, dArray9[i], 0, n2);
            System.arraycopy(dArray2[i], 0, dArray10[i], 0, n2);
        }
        if (!AXB.solve(dArray9, dArray10, dArray7, dArray8, new double[n2], new double[n2], new double[n2], new double[n2])) {
            return false;
        }
        System.arraycopy(dArray7, 0, dArray3, 0, n2);
        System.arraycopy(dArray8, 0, dArray4, 0, n2);
        return true;
    }

    public static boolean solve(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4) {
        int n = dArray[0].length;
        if (dArray3 == null) {
            dArray3 = new double[n];
        }
        if (Householder.decompose(dArray, dArray3, dArray4) == 0.0) {
            return false;
        }
        Householder.qTimes(dArray, dArray2, true, dArray4);
        for (int i = 0; i < dArray[0].length; ++i) {
            dArray[i][i] = dArray3[i];
        }
        return RXB.solve(dArray, dArray2);
    }

    public static boolean solve(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        int n4 = dArray3[0].length;
        double[][] dArray4 = new double[n2][n3];
        double[][] dArray5 = new double[n2][n4];
        for (n = 0; n < n2; ++n) {
            System.arraycopy(dArray[n], 0, dArray4[n], 0, n3);
            System.arraycopy(dArray3[n], 0, dArray5[n], 0, n4);
        }
        if (!AXB.solve(dArray4, dArray5, new double[n3], new double[n3])) {
            return false;
        }
        for (n = 0; n < n3; ++n) {
            System.arraycopy(dArray5[n], 0, dArray2[n], 0, n4);
        }
        return true;
    }

    public static boolean solve(double[][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8) {
        double[] dArray9;
        int n = dArray[0].length;
        if (dArray5 == null) {
            dArray5 = new double[n];
        }
        if (dArray6 == null) {
            dArray6 = new double[n];
        }
        if ((dArray9 = Householder.decompose(dArray, dArray2, dArray5, dArray6, dArray7, dArray8))[0] == 0.0 && dArray9[1] == 0.0) {
            return false;
        }
        Householder.qTimes(dArray, dArray2, dArray3, dArray4, true, dArray7, dArray8);
        for (int i = 0; i < dArray[0].length; ++i) {
            dArray[i][i] = dArray5[i];
            dArray2[i][i] = dArray6[i];
        }
        return RXB.solve(dArray, dArray2, dArray3, dArray4);
    }

    public static boolean solve(double[][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4, double[][] dArray5, double[][] dArray6) {
        int n;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        int n4 = dArray5[0].length;
        double[][] dArray7 = new double[n2][n3];
        double[][] dArray8 = new double[n2][n3];
        double[][] dArray9 = new double[n2][n4];
        double[][] dArray10 = new double[n2][n4];
        for (n = 0; n < n2; ++n) {
            System.arraycopy(dArray[n], 0, dArray7[n], 0, n3);
            System.arraycopy(dArray2[n], 0, dArray8[n], 0, n3);
            System.arraycopy(dArray5[n], 0, dArray9[n], 0, n4);
            System.arraycopy(dArray6[n], 0, dArray10[n], 0, n4);
        }
        if (!AXB.solve(dArray7, dArray8, dArray9, dArray10, new double[n3], new double[n3], new double[n3], new double[n3])) {
            return false;
        }
        for (n = 0; n < n3; ++n) {
            System.arraycopy(dArray9[n], 0, dArray3[n], 0, n4);
            System.arraycopy(dArray10[n], 0, dArray4[n], 0, n4);
        }
        return true;
    }
}

