/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.io.ArrayHandler;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.SequenceIterator;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.AbstractHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.models.DifferentiableHigherOrderHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.models.HigherOrderHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.models.SamplingHigherOrderHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.models.SamplingPhyloHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.DifferentiableEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.SamplingEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.SilentEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.UniformEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.AbstractConditionalDiscreteEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.DiscreteEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.PhyloDiscreteEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.ReferenceSequenceDiscreteEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.HMMTrainingParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.MaxHMMTrainingParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.SamplingHMMTrainingParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.elements.TransitionElement;
import de.jstacs.sequenceScores.statisticalModels.trainable.phylo.PhyloTree;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.Pair;
import java.lang.reflect.Constructor;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class HMMFactory {
    private static AbstractHMM getHMM(HMMTrainingParameterSet pars, String[] name, int[] emissionIdx, boolean[] forward, Emission[] emission, TransitionElement[] te, double ess, boolean likelihood) throws Exception {
        if (pars instanceof SamplingHMMTrainingParameterSet) {
            if (emission instanceof PhyloDiscreteEmission[]) {
                return new SamplingPhyloHMM((SamplingHMMTrainingParameterSet)pars, name, emissionIdx, forward, ArrayHandler.cast(PhyloDiscreteEmission.class, emission), te);
            }
            return new SamplingHigherOrderHMM((SamplingHMMTrainingParameterSet)pars, name, emissionIdx, forward, ArrayHandler.cast(SamplingEmission.class, emission), te);
        }
        boolean diff = true;
        for (int e = 0; diff && e < emission.length; ++e) {
            diff = emission[e] instanceof DifferentiableEmission;
        }
        if (diff) {
            return new DifferentiableHigherOrderHMM((MaxHMMTrainingParameterSet)pars, name, emissionIdx, forward, ArrayHandler.cast(DifferentiableEmission.class, emission), likelihood, ess, te);
        }
        return new HigherOrderHMM(pars, name, emission, te);
    }

    private static void addTransitions(int[] states, double ess, double selfTranistionPart, int o, AbstractList<TransitionElement> list) {
        int[] context = new int[o];
        SequenceIterator it = new SequenceIterator(o);
        Arrays.fill(context, states.length);
        it.setBounds(context);
        double[] hyperParams = new double[states.length];
        double e = ess * (1.0 - selfTranistionPart) / (double)(states.length - 1);
        Arrays.fill(hyperParams, e);
        do {
            for (int i = 0; i < context.length; ++i) {
                context[i] = it.discreteValAt(i);
            }
            hyperParams[context[o - 1]] = ess * selfTranistionPart;
            list.add(new TransitionElement(context, states, hyperParams));
            hyperParams[context[o - 1]] = e;
        } while (it.next());
    }

    public static AbstractHMM createErgodicHMM(HMMTrainingParameterSet pars, int order, double ess, double selfTranistionPart, double expectedSequenceLength, Emission ... emission) throws Exception {
        int n = emission.length;
        String[] name = new String[n];
        int[] states = new int[n];
        for (int i = 0; i < n; ++i) {
            name[i] = "" + i;
            states[i] = i;
            if (!(emission[i] instanceof SilentEmission)) continue;
            throw new IllegalArgumentException("An ergodic HMM can not contain silent states.");
        }
        double[] hyperParams = new double[n];
        LinkedList<TransitionElement> list = new LinkedList<TransitionElement>();
        double e = ess / (double)n;
        Arrays.fill(hyperParams, e);
        list.add(new TransitionElement(null, states, hyperParams));
        for (int o = 1; o < order; ++o) {
            HMMFactory.addTransitions(states, e, selfTranistionPart, o, list);
            e /= (double)n;
        }
        HMMFactory.addTransitions(states, ess * (expectedSequenceLength - (double)order), selfTranistionPart, order, list);
        return HMMFactory.getHMM(pars, name, null, null, emission, list.toArray(new TransitionElement[0]), ess, true);
    }

    public static AbstractHMM createPseudoErgodicHMM(HMMTrainingParameterSet pars, double ess, double selfTranistionPart, double finalTranistionPart, AlphabetContainer con, int numStates, boolean insertUniform) throws Exception {
        int i;
        Emission[] emission = new Emission[numStates + 1];
        String[] name = new String[numStates + 1];
        ArrayList<PseudoTransitionElement> list = new ArrayList<PseudoTransitionElement>();
        int[] states = new int[numStates];
        for (int i2 = 0; i2 < states.length; ++i2) {
            states[i2] = i2;
        }
        double[] hyperParams = new double[states.length];
        double e = ess / (double)hyperParams.length;
        Arrays.fill(hyperParams, e);
        list.add(new PseudoTransitionElement(null, states, hyperParams));
        states = new int[numStates + 1];
        for (i = 0; i < states.length; ++i) {
            states[i] = i;
        }
        hyperParams = new double[states.length];
        e = (1.0 - selfTranistionPart - finalTranistionPart) * ess / (double)(hyperParams.length - 2);
        Arrays.fill(hyperParams, e);
        hyperParams[numStates] = finalTranistionPart * ess;
        for (i = 0; i < numStates; ++i) {
            hyperParams[i] = selfTranistionPart * ess;
            list.add(new PseudoTransitionElement(new int[]{i}, states, hyperParams));
            hyperParams[i] = e;
        }
        name[numStates] = "F";
        states[numStates] = numStates - 1;
        emission[numStates] = new SilentEmission();
        Pair<double[][], double[]> p = HMMFactory.propagateESS(ess, list);
        double[] stateEss = p.getSecondElement();
        for (int i3 = 0; i3 < numStates; ++i3) {
            name[i3] = "" + i3;
            emission[i3] = insertUniform ? new UniformEmission(con) : new DiscreteEmission(con, stateEss[i3]);
        }
        return HMMFactory.getHMM(pars, name, null, null, emission, HMMFactory.createTransition(p.getFirstElement(), list), ess, false);
    }

    public static AbstractHMM createSunflowerHMM(HMMTrainingParameterSet pars, AlphabetContainer con, double ess, int expectedSequenceLength, boolean startCentral, int ... motifLength) throws Exception {
        return HMMFactory.createSunflowerHMM(pars, con, ess, expectedSequenceLength, startCentral, null, null, motifLength);
    }

    public static AbstractHMM createSunflowerHMM(HMMTrainingParameterSet pars, AlphabetContainer con, double ess, int expectedSequenceLength, boolean startCentral, PhyloTree[] t, double[] motifProb, int[] motifLength) throws Exception {
        int[] children;
        double[] hyperParams;
        if (motifProb == null) {
            motifProb = new double[motifLength.length];
            Arrays.fill(motifProb, 0.1 / (double)motifLength.length);
        }
        int anz = 1;
        int[] states = new int[1 + motifLength.length];
        for (int i = 0; i < motifLength.length; ++i) {
            states[1 + i] = anz;
            anz += motifLength[i];
        }
        Emission[] e = t == null ? new Emission[anz] : new PhyloDiscreteEmission[anz];
        String[] name = new String[anz];
        LinkedList<TransitionElement> list = new LinkedList<TransitionElement>();
        double[][] hyperNext = new double[motifLength.length + 1][];
        double self = 0.0;
        for (int i = 0; i < motifLength.length; ++i) {
            hyperNext[i] = new double[motifLength[i]];
            self += motifProb[i];
        }
        self = 1.0 - self;
        hyperNext[motifLength.length] = new double[1];
        double[][] stateESS = (double[][])ArrayHandler.clone((Cloneable[])hyperNext);
        if (startCentral) {
            hyperNext[motifLength.length][0] = ess;
            hyperParams = new double[]{ess};
        } else {
            hyperNext[motifLength.length][0] = ess * self;
            hyperParams = new double[anz];
            hyperParams[0] = hyperNext[motifLength.length][0];
            for (int i = 0; i < motifLength.length; ++i) {
                Arrays.fill(hyperNext[i], motifProb[i] * ess / (double)hyperNext[i].length);
                Arrays.fill(hyperParams, states[1 + i], states[1 + i] + motifLength[i], hyperNext[i][0]);
            }
        }
        if (startCentral) {
            children = new int[]{0};
        } else {
            children = new int[anz];
            for (int i = 0; i < anz; ++i) {
                children[i] = i;
            }
        }
        list.add(new TransitionElement(null, children, hyperParams));
        hyperParams = new double[motifLength.length + 1];
        for (int l = 0; l < expectedSequenceLength; ++l) {
            int i;
            double d = 0.0;
            for (i = 0; i < motifLength.length; ++i) {
                int j;
                d += hyperNext[i][motifLength[i] - 1];
                for (j = motifLength[i] - 1; j > 0; --j) {
                    double[] dArray = stateESS[i];
                    int n = j;
                    dArray[n] = dArray[n] + hyperNext[i][j];
                    hyperNext[i][j] = hyperNext[i][j - 1];
                }
                double[] dArray = stateESS[i];
                int n = j;
                dArray[n] = dArray[n] + hyperNext[i][j];
                hyperNext[i][j] = motifProb[i] * hyperNext[motifLength.length][j];
                int n2 = 1 + i;
                hyperParams[n2] = hyperParams[n2] + hyperNext[i][j];
            }
            double[] dArray = stateESS[i];
            dArray[0] = dArray[0] + hyperNext[i][0];
            hyperParams[0] = hyperParams[0] + self * hyperNext[i][0];
            hyperNext[i][0] = d + self * hyperNext[i][0];
        }
        e[0] = HMMFactory.getEmission(con, stateESS[motifLength.length][0], t == null ? null : t[0]);
        name[0] = "bg";
        list.add(new TransitionElement(new int[]{0}, states, hyperParams));
        int idx = 1;
        hyperParams = new double[1];
        for (int m = 0; m < motifLength.length; ++m) {
            hyperParams[0] = ess;
            int p = 0;
            while (p < motifLength[m]) {
                e[idx] = HMMFactory.getEmission(con, stateESS[m][p], t == null ? null : t[1]);
                name[idx] = "motif " + m + " position " + p;
                if (p == motifLength[m] - 1) {
                    list.add(new TransitionElement(new int[]{idx}, new int[]{0}, hyperParams));
                } else {
                    list.add(new TransitionElement(new int[]{idx}, new int[]{idx + 1}, hyperParams));
                }
                ++p;
                ++idx;
            }
        }
        return HMMFactory.getHMM(pars, name, null, null, e, list.toArray(new TransitionElement[0]), ess, true);
    }

    private static Emission getEmission(AlphabetContainer con, double ess, PhyloTree t) {
        if (t != null) {
            return new PhyloDiscreteEmission(con, ess, t);
        }
        return new DiscreteEmission(con, ess);
    }

    public static AbstractHMM createProfileHMM(MaxHMMTrainingParameterSet trainingParameterSet, HMMType type, boolean likelihood, int order, int numLayers, AlphabetContainer con, double ess, boolean conditionalMain, boolean closeCircle, double[][] conditionInitProbs) throws Exception {
        double[][] initFromTo = HMMFactory.getInitFromTo(type, ess);
        return HMMFactory.createProfileHMM(trainingParameterSet, initFromTo, likelihood, order, numLayers, con, ess, conditionalMain, closeCircle, conditionInitProbs, false);
    }

    public static AbstractHMM createProfileHMM(MaxHMMTrainingParameterSet trainingParameterSet, double[][] initFromTo, boolean likelihood, int order, int numLayers, AlphabetContainer con, double ess, boolean conditionalMain, boolean closeCircle, double[][] conditionInitProbs, boolean insertUniform) throws Exception {
        return HMMFactory.createProfileHMM(trainingParameterSet, initFromTo, likelihood, order, numLayers, con, ess, conditionalMain, closeCircle ? 1 : 0, conditionInitProbs, insertUniform);
    }

    public static AbstractHMM createProfileHMM(MaxHMMTrainingParameterSet trainingParameterSet, double[][] initFromTo, boolean likelihood, int order, int numLayers, AlphabetContainer con, double ess, boolean conditionalMain, int joiningStates, double[][] conditionInitProbs, boolean insertUniform) throws Exception {
        PseudoTransitionElement[] coreTransitionTemplate = null;
        LinkedList<Class<? extends DifferentiableEmission>> emList = new LinkedList<Class<? extends DifferentiableEmission>>();
        ArrayList<PseudoTransitionElement> list = new ArrayList<PseudoTransitionElement>();
        LinkedList<String> nameList = new LinkedList<String>();
        Class insertClass = insertUniform ? UniformEmission.class : DiscreteEmission.class;
        int[] endContext = new int[order];
        for (int i = 0; i < order; ++i) {
            ((AbstractList)nameList).add("E" + i);
            ((AbstractList)emList).add(SilentEmission.class);
            endContext[i] = i;
        }
        int[] startContext = new int[order];
        for (int i = 0; i < order; ++i) {
            ((AbstractList)nameList).add("S" + i);
            ((AbstractList)emList).add(SilentEmission.class);
            int[] context = new int[i];
            for (int k = 0; k < i; ++k) {
                context[k] = order + k;
            }
            list.add(new PseudoTransitionElement(context, new int[]{order + i}, new double[]{ess}));
            startContext[i] = order + i;
        }
        ArrayList<int[]> lastLayer = new ArrayList<int[]>();
        int lastStartNodeIndex = ((AbstractCollection)emList).size() - 1;
        int offset = ((AbstractCollection)emList).size();
        HMMFactory.createProfileHMMCore(numLayers, lastLayer, initFromTo, order, emList, nameList, list, offset, lastStartNodeIndex, conditionalMain, coreTransitionTemplate, "", insertClass);
        int[] states = new int[6];
        Arrays.fill(states, -1);
        states[3] = ((AbstractCollection)emList).size() - 1;
        ArrayList<int[]> newLayer = new ArrayList<int[]>();
        int i = 0;
        while (i < order) {
            HMMFactory.shiftContext(states, 3);
            states[3] = i++;
            HMMFactory.addProfileTransitions(initFromTo, order, states, list, lastLayer, newLayer);
        }
        ((AbstractList)nameList).add("F");
        ((AbstractList)emList).add(SilentEmission.class);
        if (joiningStates > 0) {
            int e = ((AbstractCollection)emList).size();
            list.add(new PseudoTransitionElement(endContext, new int[]{e - 1, e}, new double[]{ess / 2.0, ess / 2.0}));
            for (int i2 = 0; i2 < joiningStates; ++i2) {
                ((AbstractList)nameList).add("J" + i2);
                ((AbstractList)emList).add(insertClass);
            }
            int[] myContext = (int[])endContext.clone();
            System.arraycopy(myContext, 1, myContext, 0, order - 1);
            myContext[order - 1] = e;
            ContextContainer[] possible = new ContextContainer[joiningStates];
            for (int i3 = 0; i3 < joiningStates; ++i3) {
                possible[i3] = new ContextContainer();
            }
            possible[0].addConditional(myContext);
            ContextContainer extra = new ContextContainer();
            double[] hyperParams = new double[]{ess / 3.0, ess / 3.0, ess / 3.0};
            int f = e;
            int j = 0;
            while (j < joiningStates) {
                int[] children;
                if (j + 1 == joiningStates) {
                    children = new int[]{f, order};
                    hyperParams = new double[]{ess / 2.0, ess / 2.0};
                } else {
                    children = new int[]{f, f + 1, order};
                }
                for (int k = 0; k < possible[j].size(); ++k) {
                    myContext = (int[])possible[j].get(k);
                    list.add(new PseudoTransitionElement(myContext, children, hyperParams));
                    for (int l = 0; l < children.length; ++l) {
                        int[] next = (int[])myContext.clone();
                        System.arraycopy(next, 1, next, 0, order - 1);
                        next[order - 1] = children[l];
                        if (children[l] == order) {
                            extra.addConditional(next);
                            continue;
                        }
                        possible[children[l] - e].addConditional(next);
                    }
                }
                ++j;
                ++f;
            }
            for (int k = 0; k < extra.size(); ++k) {
                myContext = (int[])((int[])extra.get(k)).clone();
                for (int i4 = 0; i4 < order - 1; ++i4) {
                    list.add(new PseudoTransitionElement(myContext, new int[]{order + i4 + 1}, new double[]{ess}));
                    System.arraycopy(myContext, 1, myContext, 0, order - 1);
                    myContext[order - 1] = order + i4 + 1;
                }
            }
        } else {
            list.add(new PseudoTransitionElement(endContext, new int[]{((AbstractCollection)emList).size() - 1}, new double[]{ess}));
        }
        Pair<double[][], double[]> p = HMMFactory.propagateESS(ess, list);
        return HMMFactory.getHMM(trainingParameterSet, ((AbstractCollection)nameList).toArray(new String[0]), null, null, HMMFactory.getEmissions(nameList, emList, p.getSecondElement(), con, conditionInitProbs), HMMFactory.createTransition(p.getFirstElement(), list), ess, likelihood);
    }

    private static double[][] getInitFromTo(HMMType type, double ess) {
        double[][] initFromTo = new double[3][];
        if (type == HMMType.PLAN9) {
            initFromTo[0] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
            initFromTo[1] = (double[])initFromTo[0].clone();
            initFromTo[2] = (double[])initFromTo[1].clone();
        } else if (type == HMMType.PLAN7) {
            initFromTo[0] = new double[]{Double.NaN, Double.NaN, Double.NaN, ess / 2.0, Double.NaN, ess / 2.0};
            initFromTo[1] = new double[]{Double.NaN, ess / 2.0, Double.NaN, Double.NaN, Double.NaN, ess / 2.0};
            initFromTo[2] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
        } else if (type == HMMType.PLAN8I) {
            initFromTo[0] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
            initFromTo[1] = new double[]{Double.NaN, ess / 2.0, Double.NaN, Double.NaN, Double.NaN, ess / 2.0};
            initFromTo[2] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
        } else if (type == HMMType.PLAN8D) {
            initFromTo[0] = new double[]{Double.NaN, Double.NaN, Double.NaN, ess / 2.0, Double.NaN, ess / 2.0};
            initFromTo[1] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
            initFromTo[2] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
        }
        return initFromTo;
    }

    private static DifferentiableEmission[] getEmissions(AbstractList<String> nameList, AbstractList<Class<? extends DifferentiableEmission>> emList, double[] ess, AlphabetContainer con, double[][] conditionInitAPrioriProbs) throws Exception {
        DifferentiableEmission[] em = new DifferentiableEmission[emList.size()];
        Iterator<Class<? extends DifferentiableEmission>> it = emList.iterator();
        Iterator<String> n = nameList.iterator();
        int i = 0;
        int refIdx = 0;
        while (it.hasNext()) {
            int j;
            Class<? extends DifferentiableEmission> cl = it.next();
            String name = n.next();
            if (cl == SilentEmission.class) {
                em[i] = new SilentEmission();
            } else if (AbstractConditionalDiscreteEmission.class.isAssignableFrom(cl)) {
                if (cl == ReferenceSequenceDiscreteEmission.class) {
                    if (conditionInitAPrioriProbs != null) {
                        double[][] conditionInitHyperpars = (double[][])ArrayHandler.clone((Cloneable[])conditionInitAPrioriProbs);
                        for (j = 0; j < conditionInitHyperpars.length; ++j) {
                            int k = 0;
                            while (k < conditionInitHyperpars[j].length) {
                                double[] dArray = conditionInitHyperpars[j];
                                int n2 = k++;
                                dArray[n2] = dArray[n2] * ess[i];
                            }
                        }
                        em[i] = new ReferenceSequenceDiscreteEmission(con, con, refIdx, ess[i], conditionInitHyperpars);
                    } else {
                        em[i] = new ReferenceSequenceDiscreteEmission(con, con, refIdx, ess[i]);
                    }
                    ++refIdx;
                } else {
                    em[i] = cl.getConstructor(AlphabetContainer.class, Double.TYPE).newInstance(con, ess[i]);
                }
                String shape = name.charAt(0) == 'M' ? "rect" : "diamond";
                ((AbstractConditionalDiscreteEmission)em[i]).setShape(shape);
            } else {
                Constructor<?>[] cons = cl.getConstructors();
                block7: for (j = 0; em[i] == null && j < cons.length; ++j) {
                    Class<?>[] pars = cons[j].getParameterTypes();
                    switch (pars.length) {
                        case 1: {
                            if (pars[0] != AlphabetContainer.class) continue block7;
                            em[i] = (DifferentiableEmission)cons[j].newInstance(con);
                            continue block7;
                        }
                        case 2: {
                            if (pars[0] != AlphabetContainer.class || pars[1] != Double.TYPE) continue block7;
                            em[i] = (DifferentiableEmission)cons[j].newInstance(con, ess[i]);
                        }
                    }
                }
                if (em[i] == null) {
                    throw new Exception("Unsupported emission class.");
                }
            }
            ++i;
        }
        return em;
    }

    private static void shiftContext(int[] context) {
        HMMFactory.shiftContext(context, 1);
    }

    private static void shiftContext(int[] context, int s) {
        System.arraycopy(context, s, context, 0, context.length - s);
    }

    private static void createProfileHMMCore(int numLayers, ArrayList<int[]> lastLayer, double[][] initFromTo, int order, AbstractList<Class<? extends DifferentiableEmission>> emList, AbstractList<String> nameList, AbstractList<PseudoTransitionElement> list, int totalOffset, int lastStartNodeIndex, boolean conditionalMain, PseudoTransitionElement[] coreTransitionTemplate, String suffix, Class<? extends DifferentiableEmission> insertClass) {
        if (order < 1) {
            throw new IllegalArgumentException("The order of a profile HMM has to be at least 1.");
        }
        ArrayList<int[]> newLayer = new ArrayList<int[]>();
        emList.add(SilentEmission.class);
        nameList.add("D0" + suffix);
        emList.add(insertClass);
        nameList.add("I0" + suffix);
        int[] context = new int[order];
        for (int i = 0; i < order; ++i) {
            context[i] = lastStartNodeIndex - order + i + 1;
        }
        if (Double.isNaN(initFromTo[0][1])) {
            list.add(new PseudoTransitionElement(context, new int[]{emList.size() - 2, emList.size() - 1}, new double[]{0.5, 0.5}));
        } else {
            list.add(new PseudoTransitionElement(context, new int[]{emList.size() - 2}, new double[]{1.0}));
        }
        lastLayer.clear();
        HMMFactory.shiftContext(context);
        context[order - 1] = emList.size() - 2;
        lastLayer.add((int[])context.clone());
        if (Double.isNaN(initFromTo[0][1])) {
            context[order - 1] = emList.size() - 1;
            lastLayer.add(context);
        }
        int[] states = new int[]{-1, -1, -1, totalOffset, totalOffset + 1, -1};
        boolean[] createStates = new boolean[3];
        Arrays.fill(createStates, true);
        for (int i = 0; i < numLayers; ++i) {
            if (i == numLayers - 1) {
                for (int j = 0; j < createStates.length; ++j) {
                    createStates[j] = !Double.isNaN(initFromTo[j][3]);
                }
            }
            int last = emList.size();
            HMMFactory.createEmissions(createStates, emList, nameList, i + 1, conditionalMain, suffix, insertClass);
            HMMFactory.shiftContext(states, 3);
            for (int j = 3; j < states.length; ++j) {
                states[j] = createStates[j - 3] ? last++ : -1;
            }
            HMMFactory.addProfileTransitions(initFromTo, order, states, list, lastLayer, newLayer);
        }
        emList.add(SilentEmission.class);
        nameList.add("D" + (numLayers + 1) + suffix);
        HMMFactory.shiftContext(states, 3);
        states[3] = emList.size() - 1;
        states[4] = -1;
        states[5] = -1;
        HMMFactory.addProfileTransitions(initFromTo, order, states, list, lastLayer, newLayer);
    }

    private static void addProfileTransitions(double[][] initFromTo, int order, int[] states, List<PseudoTransitionElement> allTE, List<int[]> lastLayer, List<int[]> newLayer) {
        DoubleList hyper = new DoubleList();
        DoubleList weights = new DoubleList();
        IntList children = new IntList();
        int o = order - 1;
        for (int s = 0; s < lastLayer.size(); ++s) {
            int j;
            int[] current = lastLayer.get(s);
            int k = 0;
            while (current[o] != states[k]) {
                ++k;
            }
            hyper.clear();
            weights.clear();
            children.clear();
            int a = 0;
            for (j = 0; j < initFromTo[k].length; ++j) {
                if (Double.isNaN(initFromTo[k][j]) || states[j] < 0) continue;
                hyper.add(initFromTo[k][j]);
                children.add(states[j]);
                if (j < 3) {
                    weights.add(1000.0);
                    a = children.length();
                    continue;
                }
                weights.add(1.0);
            }
            if (children.length() > 0) {
                allTE.add(new PseudoTransitionElement(current, children.toArray(), hyper.toArray(), weights.toArray()));
            }
            int[] next = (int[])current.clone();
            HMMFactory.shiftContext(next);
            for (j = 0; j < children.length(); ++j) {
                next[o] = children.get(j);
                HMMFactory.addConditional(next, j < a ? lastLayer : newLayer);
            }
        }
        lastLayer.clear();
        lastLayer.addAll(newLayer);
        newLayer.clear();
    }

    private static boolean addConditional(int[] context, List<int[]> list) {
        for (int i = 0; i < list.size(); ++i) {
            int j;
            int[] current = list.get(i);
            for (j = 0; j < context.length && current[j] == context[j]; ++j) {
            }
            if (j != context.length) continue;
            return false;
        }
        list.add((int[])context.clone());
        return true;
    }

    private static int createEmissions(boolean[] createState, AbstractList<Class<? extends DifferentiableEmission>> emList, AbstractList<String> nameList, int offset, boolean conditionalMain, String suffix, Class<? extends DifferentiableEmission> insertClass) {
        int i = 0;
        int a = 0;
        if (createState[i]) {
            emList.add(SilentEmission.class);
            nameList.add("D" + offset + suffix);
            ++a;
        }
        if (createState[++i]) {
            emList.add(insertClass);
            nameList.add("I" + offset + suffix);
            ++a;
        }
        if (createState[++i]) {
            Class de = !conditionalMain ? DiscreteEmission.class : ReferenceSequenceDiscreteEmission.class;
            emList.add(de);
            nameList.add("M" + offset + suffix);
            ++a;
        }
        return a;
    }

    public static TransitionElement[] createTransition(double[][] hyperParams, ArrayList<PseudoTransitionElement> list) {
        TransitionElement[] t = new TransitionElement[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            PseudoTransitionElement current = list.get(i);
            t[i] = new TransitionElement(current.context, current.states, current.prob, current.weights);
        }
        return t;
    }

    public static Pair<double[][], double[]> propagateESS(double ess, ArrayList<PseudoTransitionElement> list) {
        int maxOrder = 0;
        int max = 0;
        int startIdx = -1;
        IntList end = new IntList();
        for (int i = 0; i < list.size(); ++i) {
            int[] current = list.get(i).states;
            for (int j = 0; j < current.length; ++j) {
                max = Math.max(max, current[j]);
            }
            if (list.get(i).context.length == 0) {
                if (startIdx >= 0) {
                    throw new IllegalArgumentException("Multiple start transitions!");
                }
                startIdx = i;
                continue;
            }
            maxOrder = Math.max(maxOrder, list.get(i).context.length);
        }
        for (int t = 0; t < list.size(); ++t) {
            PseudoTransitionElement te = list.get(t);
            if (te.states.length == 0) {
                end.add(t);
            }
            for (int child = 0; child < te.states.length; ++child) {
                int[] nextContext = new int[Math.min(maxOrder, te.context.length + 1)];
                nextContext[nextContext.length - 1] = te.states[child];
                int k = 1;
                int j = nextContext.length - 2;
                while (j >= 0) {
                    nextContext[j] = te.context[te.context.length - k];
                    --j;
                    ++k;
                }
                for (int s = 0; s < list.size(); ++s) {
                    int c;
                    PseudoTransitionElement te2 = list.get(s);
                    if (nextContext.length != te2.context.length) continue;
                    for (c = 0; c < nextContext.length && nextContext[c] == te2.context[c]; ++c) {
                    }
                    if (c != nextContext.length) continue;
                    ((PseudoTransitionElement)te).child[child] = s;
                    s = list.size();
                }
                if (te.child[child] != -1) continue;
                if (maxOrder == 0) {
                    ((PseudoTransitionElement)te).child[child] = 0;
                    continue;
                }
                ((PseudoTransitionElement)te).child[child] = list.size();
                list.add(new PseudoTransitionElement(nextContext, null, null));
            }
        }
        if (end.length() == 0) {
            throw new IllegalArgumentException("No absorbing state!");
        }
        double eps = 1.0E-12;
        double sum = 0.0;
        double[] cumulatedHyper = new double[list.size()];
        double[] currentHyper = new double[list.size()];
        double[] nextHyper = new double[list.size()];
        currentHyper[startIdx] = ess;
        do {
            int i;
            for (int t = 0; t < list.size(); ++t) {
                PseudoTransitionElement te = list.get(t);
                for (int child = 0; child < te.states.length; ++child) {
                    int n = te.child[child];
                    nextHyper[n] = nextHyper[n] + te.prob[child] * currentHyper[t];
                }
            }
            for (i = 0; i < cumulatedHyper.length; ++i) {
                int n = i;
                cumulatedHyper[n] = cumulatedHyper[n] + currentHyper[i];
                currentHyper[i] = nextHyper[i];
                nextHyper[i] = 0.0;
            }
            sum = 0.0;
            for (i = 0; i < currentHyper.length; ++i) {
                sum += currentHyper[i];
            }
        } while (sum > eps);
        double[][] t = new double[list.size()][];
        double[] stateESS = new double[max + 1];
        for (int i = 0; i < list.size(); ++i) {
            PseudoTransitionElement current = list.get(i);
            t[i] = new double[current.prob.length];
            for (int j = 0; j < t[i].length; ++j) {
                t[i][j] = cumulatedHyper[i] * current.prob[j];
            }
            if (current.context.length <= 0) continue;
            int n = current.context[current.context.length - 1];
            stateESS[n] = stateESS[n] + cumulatedHyper[i];
        }
        return new Pair<double[][], double[]>(t, stateESS);
    }

    public static HashMap<String, String> getHashMap() {
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("J.*", "min");
        hash.put("[EFIS].*", "same");
        hash.put("M.*", "same");
        hash.put("D.*", "max");
        return hash;
    }

    public static class PseudoTransitionElement {
        private int[] context;
        private int[] states;
        private int[] child;
        private double[] prob;
        private double[] weights;

        public PseudoTransitionElement(int[] context, int[] states, double[] posScore) {
            this(context, states, posScore, null);
        }

        public PseudoTransitionElement(int[] context, int[] states, double[] posScore, double[] weights) {
            this.context = context == null ? new int[]{} : (int[])context.clone();
            this.states = states == null ? new int[]{} : (int[])states.clone();
            this.prob = new double[this.states.length];
            if (posScore == null) {
                Arrays.fill(this.prob, 1.0 / (double)this.states.length);
            } else {
                Normalisation.sumNormalisation(posScore, this.prob, 0);
            }
            if (weights == null) {
                this.weights = new double[this.states.length];
                Arrays.fill(this.weights, 1.0);
            } else {
                this.weights = weights;
            }
            this.child = new int[this.states.length];
            Arrays.fill(this.child, -1);
        }

        public String toString() {
            int i;
            String str = "";
            String cont = "";
            for (i = 0; i < this.context.length - 1; ++i) {
                cont = cont + this.context[i] + ", ";
            }
            if (this.context.length > 0) {
                cont = cont + this.context[this.context.length - 1];
            }
            for (i = 0; i < this.states.length; ++i) {
                str = str + "P(" + this.states[i] + "|" + cont + ")\t= " + this.prob[i] + (i == this.states.length - 1 ? "\n" : "\t");
            }
            return str;
        }
    }

    private static class ContextContainer
    extends ArrayList<int[]> {
        private ContextContainer() {
        }

        public boolean addConditional(int[] newContext) {
            for (int i = 0; i < this.size(); ++i) {
                int j;
                int[] test = (int[])this.get(i);
                for (j = 0; j < newContext.length && newContext[j] == test[j]; ++j) {
                }
                if (j != newContext.length) continue;
                return false;
            }
            this.add(newContext);
            return true;
        }
    }

    public static enum HMMType {
        PLAN7,
        PLAN9,
        PLAN8I,
        PLAN8D;

    }
}

