/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.parameters;

import de.jstacs.DataType;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.FSDAGTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.InhomogeneousDGTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.parameters.IDGTrainSMParameterSet;

public class FSDAGTrainSMParameterSet
extends IDGTrainSMParameterSet {
    public FSDAGTrainSMParameterSet(StringBuffer s) throws NonParsableException {
        super(s);
    }

    public FSDAGTrainSMParameterSet() {
        this((Class<? extends FSDAGTrainSM>)FSDAGTrainSM.class);
    }

    public FSDAGTrainSMParameterSet(AlphabetContainer alphabet, int length, double ess, String description, String graph) throws Exception {
        this(FSDAGTrainSM.class, alphabet, length, ess, description, graph);
    }

    protected FSDAGTrainSMParameterSet(Class<? extends FSDAGTrainSM> clazz) {
        super((Class<? extends InhomogeneousDGTrainSM>)clazz);
        try {
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.STRING, "graph structure", "the graph structure for the model (has to be acyclic)&lt;br&gt;The graph has to be given in a semi-XML-format, i.e. if 1, 2 and 5 are the parents from node 0 enter&lt;br&gt;&lt;parents node=0&gt;1,2,5&lt;/parents&gt;&lt;br&gt;the root nodes do not have to be insert explicitly", false)});
        }
        catch (SimpleParameter.DatatypeNotValidException datatypeNotValidException) {
            // empty catch block
        }
    }

    protected FSDAGTrainSMParameterSet(Class<? extends FSDAGTrainSM> clazz, AlphabetContainer alphabet, int length, double ess, String description, String graph) throws Exception {
        super((Class<? extends InhomogeneousDGTrainSM>)clazz, alphabet, length, ess, description);
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.STRING, "graph structure", "the graph structure for the model (has to be acyclic)&lt;br&gt;The graph has to be given in a semi-XML-format, i.e. if 1, 2 and 5 are the parents from node 0 enter&lt;br&gt;&lt;parents node=0&gt;1,2,5&lt;/parents&gt;&lt;br&gt;the root nodes do not have to be insert explicitly", false)});
        ((Parameter)this.parameters.get(2)).setValue(graph);
    }

    @Override
    public String getInstanceComment() {
        return "a directed acyclic graphical (DAG) model with fixed structure (FS)";
    }

    public static String encode(int[][] graph) {
        StringBuffer encoded = new StringBuffer(1000);
        for (int i = 0; i < graph.length; ++i) {
            if (graph[i] == null || graph[i].length <= 0) continue;
            StringBuffer help = new StringBuffer(100);
            help.append(graph[i][0]);
            for (int j = 1; j < graph[i].length; ++j) {
                help.append("," + graph[i][j]);
            }
            XMLParser.addTagsAndAttributes(help, "parents", "node=\"" + i + "\"");
            encoded.append(help);
        }
        return encoded.toString();
    }
}

