/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences.annotation;

import de.jstacs.data.sequences.annotation.MotifAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.results.Result;

public class MotifAnnotationParser
extends SplitSequenceAnnotationParser {
    public MotifAnnotationParser() {
    }

    public MotifAnnotationParser(String keyValueDelimiter, String annotationDelimiter) {
        super(keyValueDelimiter, annotationDelimiter);
    }

    @Override
    public void addToAnnotation(String unparsed) {
        String[] split;
        for (String current : split = unparsed.substring(1).split(this.annotationDelimiter)) {
            int idxr;
            int idxl;
            int idx = current.indexOf(this.keyValueDelimiter);
            if (idx < 0) continue;
            String type = current.substring(0, idx).trim();
            String identifier = current.substring(idx + this.keyValueDelimiter.length()).trim();
            if ("Motif".equals(type) && (idxl = identifier.indexOf("(")) >= 0 && (idxr = identifier.indexOf(")")) >= 0) {
                String ann = identifier.substring(idxl + 1, idxr).trim();
                String[] parts = ann.split(", ");
                int position = Integer.parseInt(parts[0]);
                int length = Integer.parseInt(parts[1]);
                StrandedLocatedSequenceAnnotationWithLength.Strand strandedness = StrandedLocatedSequenceAnnotationWithLength.Strand.valueOf(parts[2].trim());
                this.add(identifier.substring(0, idxl).trim(), position, length, strandedness);
                continue;
            }
            this.add(type, identifier);
        }
    }

    protected void add(String identifier, int position, int length, StrandedLocatedSequenceAnnotationWithLength.Strand strandedness) {
        this.annot.add(new MotifAnnotation(identifier, position, length, strandedness, new Result[0]));
    }

    @Override
    public String parseAnnotationToComment(char commentChar, SequenceAnnotation ... annotations) {
        StringBuffer res = new StringBuffer();
        res.append(commentChar);
        MotifAnnotation ma = null;
        if (annotations != null && annotations.length > 0) {
            res.append(annotations[0].getType() + this.keyValueDelimiter + annotations[0].getIdentifier());
            if (annotations[0] instanceof MotifAnnotation) {
                ma = (MotifAnnotation)annotations[0];
                res.append("( " + ma.getPosition() + ", " + ma.getLength() + ", " + ma.getStrandedness().name() + " )");
            }
            for (int i = 1; i < annotations.length; ++i) {
                res.append(this.annotationDelimiter + " " + annotations[i].getType() + this.keyValueDelimiter + annotations[i].getIdentifier());
                if (!(annotations[i] instanceof MotifAnnotation)) continue;
                ma = (MotifAnnotation)annotations[i];
                res.append(" ( " + ma.getPosition() + ", " + ma.getLength() + ", " + ma.getStrandedness().name() + " )");
            }
        }
        return res.toString();
    }
}

