/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.graphs.tensor;

import de.jstacs.algorithms.graphs.tensor.Tensor;

public class SubTensor
extends Tensor {
    private int offset;
    private Tensor t;

    public SubTensor(Tensor t, int offset, int length) {
        super(length, t.order);
        if (offset < 0) {
            throw new IllegalArgumentException("The offset has to be non-negative.");
        }
        this.offset = offset;
        if (t.getNumberOfNodes() < offset + length) {
            throw new IllegalArgumentException("The length out of range.");
        }
        this.t = t;
    }

    @Override
    public int[] getMaximalEdgeFor(byte k, int child, int ... parents) {
        this.check(parents);
        this.check(child);
        this.modify(1, parents);
        int[] res = this.t.getMaximalEdgeFor(k, child + this.offset, parents);
        this.modify(-1, parents);
        return res;
    }

    @Override
    public double getRootValue(int child) {
        this.check(child);
        return this.t.getRootValue(child + this.offset);
    }

    @Override
    public double getValue(byte k, int child, int ... parents) {
        this.check(parents);
        this.check(child);
        this.modify(1, parents);
        double res = this.t.getValue(k, child + this.offset, parents);
        this.modify(-1, parents);
        return res;
    }

    @Override
    public void resetValue(byte k, int child, int ... parents) {
        this.check(parents);
        this.check(child);
        this.modify(1, parents);
        this.t.resetValue(k, child + this.offset, parents);
        this.modify(-1, parents);
    }

    @Override
    public void setRootValue(int child, double val) {
        this.check(child);
        this.t.setRootValue(child + this.offset, val);
    }

    @Override
    public void setValue(byte k, double val, int child, int ... parents) {
        this.check(parents);
        this.check(child);
        this.modify(1, parents);
        this.t.setValue(k, val, child + this.offset, parents);
        this.modify(-1, parents);
    }

    private void modify(int direction, int[] array) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] + direction * this.offset;
        }
    }

    private void check(int ... array) throws IndexOutOfBoundsException {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] >= 0 && array[i] < this.getNumberOfNodes()) continue;
            throw new IndexOutOfBoundsException("check value: " + array[i]);
        }
    }
}

