/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.models;

import de.jstacs.algorithms.optimization.termination.AbstractTerminationCondition;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.ResultSet;
import de.jstacs.results.StorableResult;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.AbstractHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.SimpleState;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.TrainableState;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.BaumWelchParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.HMMTrainingParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.MaxHMMTrainingParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.ViterbiParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.BasicHigherOrderTransition;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.TrainableTransition;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.Transition;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.AbstractMixtureTrainSM;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.Pair;
import de.jstacs.utils.Time;
import de.jstacs.utils.ToolBox;
import java.util.Arrays;
import javax.naming.OperationNotSupportedException;

public class HigherOrderHMM
extends AbstractHMM {
    protected int[] container;
    protected double[] logEmission;
    private double[][][] forwardIntermediate;
    protected double[] backwardIntermediate;
    protected int[][] numberOfSummands;
    protected IntList stateList;
    protected boolean skipInit;
    private static final String XML_TAG = "HigherOrderHMM";

    public HigherOrderHMM(HMMTrainingParameterSet trainingParameterSet, String[] name, Emission[] emission, BasicHigherOrderTransition.AbstractTransitionElement ... te) throws Exception {
        this(trainingParameterSet, name, null, null, emission, te);
    }

    public HigherOrderHMM(HMMTrainingParameterSet trainingParameterSet, String[] name, int[] emissionIdx, boolean[] forward, Emission[] emission, BasicHigherOrderTransition.AbstractTransitionElement ... te) throws Exception {
        super(trainingParameterSet, name, emissionIdx, forward, emission);
        this.createStates();
        this.initTransition(te);
        this.determineFinalStates();
    }

    @Override
    protected void createHelperVariables() {
        if (this.container == null) {
            this.container = new int[3];
            this.logEmission = new double[this.states.length];
            int m = 0;
            int max = this.transition.getMaximalMarkovOrder();
            for (int i = 0; i <= max; ++i) {
                m = Math.max(m, this.transition.getNumberOfIndexes(i));
            }
            this.forwardIntermediate = new double[2][m][this.transition.getMaximalInDegree() + 1];
            this.backwardIntermediate = new double[this.states.length + 1];
            this.numberOfSummands = new int[2][this.forwardIntermediate[0].length];
            this.stateList = new IntList();
        }
    }

    public HigherOrderHMM(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.createHelperVariables();
    }

    @Override
    protected String getXMLTag() {
        return XML_TAG;
    }

    @Override
    protected void appendFurtherInformation(StringBuffer xml) {
        XMLParser.appendObjectWithTags(xml, this.skipInit, "skipInit");
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.skipInit = XMLParser.extractObjectForTags(xml, "skipInit", Boolean.TYPE);
    }

    @Override
    public HigherOrderHMM clone() throws CloneNotSupportedException {
        HigherOrderHMM clone = (HigherOrderHMM)super.clone();
        clone.container = null;
        clone.createHelperVariables();
        return clone;
    }

    @Override
    protected void createStates() {
        this.states = new SimpleState[this.emissionIdx.length];
        for (int i = 0; i < this.emissionIdx.length; ++i) {
            this.states[i] = new SimpleState(this.emission[this.emissionIdx[i]], this.name[i], this.forward[i]);
        }
    }

    @Override
    public double getLogPriorTerm() {
        double res = this.transition.getLogPriorTerm();
        for (int e = 0; e < this.emission.length; ++e) {
            res += this.emission[e].getLogPriorTerm();
        }
        return res;
    }

    @Override
    public double getLogProbForPath(IntList path, int startPos, Sequence seq) throws Exception {
        if (!this.finalState[path.get(path.length() - 1)]) {
            throw new IllegalArgumentException("The last state of the path is no final state. Hence the path is not valid.");
        }
        double res = 0.0;
        int layer = 0;
        this.container[1] = 0;
        for (int l = 0; l < path.length(); ++l) {
            int state = path.get(l);
            int childIdx = this.transition.getChildIdx(layer, this.container[1], state);
            if (childIdx < 0) {
                throw new IllegalArgumentException("Impossible path");
            }
            res += this.transition.getLogScoreFor(layer, this.container[1], childIdx, seq, startPos) + this.states[state].getLogScoreFor(startPos, startPos, seq);
            this.transition.fillTransitionInformation(layer, this.container[1], childIdx, this.container);
            if (this.container[2] != 1) continue;
            ++startPos;
            ++layer;
        }
        return res;
    }

    @Override
    protected void fillLogStatePosteriorMatrix(double[][] statePosterior, int startPos, int endPos, Sequence seq, boolean silentZero) throws Exception {
        int len = endPos - startPos + 1;
        if (this.transition.getMaximalMarkovOrder() == 0) {
            for (int l = 0; l < len; ++l) {
                for (int s = 0; s < this.states.length; ++s) {
                    this.transition.fillTransitionInformation(0, 0, s, this.container);
                    double d = this.transition.getLogScoreFor(0, 0, s, seq, startPos + l) + this.states[this.container[0]].getLogScoreFor(startPos + l, startPos + l, seq);
                    statePosterior[this.container[0]][l + 1] = d;
                    this.logEmission[s] = d;
                }
                double d = Normalisation.getLogSum(this.logEmission);
                for (int s = 0; s < this.states.length; ++s) {
                    double[] dArray = statePosterior[s];
                    int n = l + 1;
                    dArray[n] = dArray[n] - d;
                }
            }
        } else {
            this.fillFwdMatrix(startPos, endPos, seq);
            this.fillBwdMatrix(startPos, endPos, seq);
            double logProb = this.bwdMatrix[0][0];
            for (int l = 0; l <= len; ++l) {
                int s;
                for (s = 0; s < this.states.length; ++s) {
                    statePosterior[s][l] = Double.NEGATIVE_INFINITY;
                }
                for (int c = 0; c < this.fwdMatrix[l].length; ++c) {
                    int state = this.transition.getLastContextState(l, c);
                    if (state < 0 || silentZero && this.states[state].isSilent()) continue;
                    statePosterior[state][l] = Normalisation.getLogSum(statePosterior[state][l], this.fwdMatrix[l][c] + this.bwdMatrix[l][c]);
                }
                for (s = 0; s < this.states.length; ++s) {
                    double[] dArray = statePosterior[s];
                    int n = l;
                    dArray[n] = dArray[n] - logProb;
                }
                ++startPos;
            }
        }
    }

    @Override
    protected void fillFwdMatrix(int startPos, int endPos, Sequence seq) throws OperationNotSupportedException, WrongLengthException {
        double logTransition;
        int n;
        int context;
        int h;
        int stateID;
        int l = 0;
        this.provideMatrix(0, endPos - startPos + 1);
        Arrays.fill(this.numberOfSummands[0], 0);
        this.numberOfSummands[0][0] = 1;
        this.forwardIntermediate[0][0][0] = 0.0;
        while (startPos <= endPos) {
            for (stateID = 0; stateID < this.states.length; ++stateID) {
                this.logEmission[stateID] = this.states[stateID].getLogScoreFor(startPos, startPos, seq);
            }
            h = l % 2;
            Arrays.fill(this.numberOfSummands[1 - h], 0);
            for (context = 0; context < this.fwdMatrix[l].length; ++context) {
                n = this.transition.getNumberOfChildren(l, context);
                if (this.numberOfSummands[h][context] > 0) {
                    this.fwdMatrix[l][context] = Normalisation.getLogSum(0, this.numberOfSummands[h][context], this.forwardIntermediate[h][context]);
                    for (stateID = 0; stateID < n; ++stateID) {
                        this.transition.fillTransitionInformation(l, context, stateID, this.container);
                        logTransition = this.transition.getLogScoreFor(l, context, stateID, seq, startPos);
                        int hh = (h + this.container[2]) % 2;
                        this.forwardIntermediate[hh][this.container[1]][this.numberOfSummands[hh][this.container[1]]] = this.fwdMatrix[l][context] + this.logEmission[this.container[0]] + logTransition;
                        int[] nArray = this.numberOfSummands[hh];
                        int n2 = this.container[1];
                        nArray[n2] = nArray[n2] + 1;
                    }
                    continue;
                }
                this.fwdMatrix[l][context] = Double.NEGATIVE_INFINITY;
            }
            ++l;
            ++startPos;
        }
        h = l % 2;
        for (context = 0; context < this.fwdMatrix[l].length; ++context) {
            n = this.transition.getNumberOfChildren(l, context);
            if (this.numberOfSummands[h][context] > 0) {
                this.fwdMatrix[l][context] = Normalisation.getLogSum(0, this.numberOfSummands[h][context], this.forwardIntermediate[h][context]);
                for (stateID = 0; stateID < n; ++stateID) {
                    this.transition.fillTransitionInformation(l, context, stateID, this.container);
                    if (!this.states[this.container[0]].isSilent()) continue;
                    logTransition = this.transition.getLogScoreFor(l, context, stateID, seq, startPos);
                    int[] nArray = this.numberOfSummands[h];
                    int n3 = this.container[1];
                    int n4 = nArray[n3];
                    nArray[n3] = n4 + 1;
                    this.forwardIntermediate[h][this.container[1]][n4] = this.fwdMatrix[l][context] + logTransition;
                }
                continue;
            }
            this.fwdMatrix[l][context] = Double.NEGATIVE_INFINITY;
        }
    }

    @Override
    protected void fillBwdMatrix(int startPos, int endPos, Sequence seq) throws Exception {
        this.fillBwdOrViterbiMatrix(Type.LIKELIHOOD, startPos, endPos, 1.0, seq);
    }

    protected void fillBwdOrViterbiMatrix(Type t, int startPos, int endPos, double weight, Sequence seq) throws Exception {
        double newWeight;
        int stateID;
        int n;
        int context;
        int l = endPos - startPos + 1;
        boolean zero = this.transition.getMaximalMarkovOrder() == 0;
        this.provideMatrix(1, endPos - startPos + 1);
        double res = t != Type.BAUM_WELCH ? Double.NaN : this.computeLogScoreFromForward(l);
        for (context = this.bwdMatrix[l].length - 1; context >= 0; --context) {
            n = this.transition.getNumberOfChildren(l, context);
            this.numberOfSummands[0][0] = 0;
            double val = zero || this.finalState[this.transition.getLastContextState(l, context)] ? 0.0 : Double.NEGATIVE_INFINITY;
            for (stateID = 0; stateID < n; ++stateID) {
                this.transition.fillTransitionInformation(l, context, stateID, this.container);
                if (!this.states[this.container[0]].isSilent()) continue;
                this.backwardIntermediate[this.numberOfSummands[0][0]] = this.bwdMatrix[l][this.container[1]] + this.transition.getLogScoreFor(l, context, stateID, seq, endPos);
                if (t == Type.BAUM_WELCH) {
                    newWeight = weight * Math.exp(this.fwdMatrix[l][context] + this.backwardIntermediate[this.numberOfSummands[0][0]] - res);
                    ((TrainableTransition)this.transition).addToStatistic(l, context, stateID, newWeight, seq, endPos);
                }
                int[] nArray = this.numberOfSummands[0];
                nArray[0] = nArray[0] + 1;
            }
            this.bwdMatrix[l][context] = this.numberOfSummands[0][0] == 0 ? val : (t == Type.VITERBI ? Math.max(val, ToolBox.max(0, this.numberOfSummands[0][0], this.backwardIntermediate)) : Normalisation.getLogSum(val, Normalisation.getLogSum(0, this.numberOfSummands[0][0], this.backwardIntermediate)));
        }
        while (--l >= 0) {
            for (stateID = 0; stateID < this.states.length; ++stateID) {
                this.logEmission[stateID] = this.states[stateID].getLogScoreFor(endPos, endPos, seq);
            }
            for (context = this.bwdMatrix[l].length - 1; context >= 0; --context) {
                n = this.transition.getNumberOfChildren(l, context);
                for (stateID = 0; stateID < n; ++stateID) {
                    this.transition.fillTransitionInformation(l, context, stateID, this.container);
                    this.backwardIntermediate[stateID] = this.bwdMatrix[l + this.container[2]][this.container[1]] + this.logEmission[this.container[0]] + this.transition.getLogScoreFor(l, context, stateID, seq, endPos);
                    if (t != Type.BAUM_WELCH) continue;
                    newWeight = weight * Math.exp(this.fwdMatrix[l][context] + this.backwardIntermediate[stateID] - res);
                    ((TrainableState)this.states[this.container[0]]).addToStatistic(endPos, endPos, newWeight, seq);
                    ((TrainableTransition)this.transition).addToStatistic(l, context, stateID, newWeight, seq, endPos);
                }
                this.bwdMatrix[l][context] = n > 0 ? (t == Type.VITERBI ? ToolBox.max(0, n, this.backwardIntermediate) : Normalisation.getLogSum(0, n, this.backwardIntermediate)) : Double.NEGATIVE_INFINITY;
            }
            --endPos;
        }
    }

    @Override
    public Pair<IntList, Double> getViterbiPathFor(int startPos, int endPos, Sequence seq) throws Exception {
        IntList path = new IntList(endPos - startPos + 1);
        double score = this.viterbi(path, startPos, endPos, 0.0, seq);
        return new Pair<IntList, Double>(path, score);
    }

    protected double viterbi(IntList path, int startPos, int endPos, double weight, Sequence seq) throws Exception {
        double dist;
        double current;
        int stateID;
        int childIdx;
        int state;
        int newContext;
        int add;
        double bestDist;
        int n;
        this.fillBwdOrViterbiMatrix(Type.VITERBI, startPos, endPos, 0.0, seq);
        int l = endPos - startPos + 1;
        int layer = 0;
        int context = 0;
        if (path != null) {
            path.clear();
        }
        while (layer < l) {
            n = this.transition.getNumberOfChildren(layer, context);
            bestDist = Double.POSITIVE_INFINITY;
            add = -1000;
            newContext = -1000;
            state = -1000;
            childIdx = -1000;
            for (stateID = 0; stateID < n; ++stateID) {
                this.transition.fillTransitionInformation(layer, context, stateID, this.container);
                current = this.bwdMatrix[layer + this.container[2]][this.container[1]] + this.states[this.container[0]].getLogScoreFor(startPos, startPos, seq) + this.transition.getLogScoreFor(layer, context, stateID, seq, startPos);
                dist = current - this.bwdMatrix[layer][context];
                dist *= dist;
                if (!(dist < bestDist)) continue;
                childIdx = stateID;
                state = this.container[0];
                newContext = this.container[1];
                add = this.container[2];
                bestDist = dist;
            }
            if (path == null) {
                ((TrainableTransition)this.transition).addToStatistic(layer, context, childIdx, weight, seq, startPos);
                ((TrainableState)this.states[state]).addToStatistic(startPos, startPos, weight, seq);
            } else {
                path.add(state);
            }
            startPos += add;
            layer += add;
            context = newContext;
        }
        while (true) {
            n = this.transition.getNumberOfChildren(layer, context);
            dist = this.finalState[this.transition.getLastContextState(layer, context)] ? 0.0 - this.bwdMatrix[layer][context] : Double.NEGATIVE_INFINITY;
            bestDist = dist * dist;
            add = -1000;
            newContext = -1000;
            state = -1000;
            childIdx = -1000;
            for (stateID = 0; stateID < n; ++stateID) {
                this.transition.fillTransitionInformation(layer, context, stateID, this.container);
                if (this.container[2] != 0) continue;
                current = this.bwdMatrix[layer][this.container[1]] + this.states[this.container[0]].getLogScoreFor(startPos, startPos, seq) + this.transition.getLogScoreFor(layer, context, stateID, seq, startPos);
                dist = current - this.bwdMatrix[layer][context];
                if (!((dist *= dist) < bestDist)) continue;
                childIdx = stateID;
                state = this.container[0];
                newContext = this.container[1];
                bestDist = dist;
            }
            if (state < 0) break;
            if (path == null) {
                ((TrainableTransition)this.transition).addToStatistic(layer, context, childIdx, weight, seq, startPos);
                ((TrainableState)this.states[state]).addToStatistic(startPos, startPos, weight, seq);
            } else {
                path.add(state);
            }
            context = newContext;
        }
        return this.bwdMatrix[0][0];
    }

    protected double baumWelch(int startPos, int endPos, double weight, Sequence seq) throws Exception {
        this.fillFwdMatrix(startPos, endPos, seq);
        this.fillBwdOrViterbiMatrix(Type.BAUM_WELCH, startPos, endPos, weight, seq);
        return this.bwdMatrix[0][0];
    }

    @Override
    public void train(DataSet data, double[] weights) throws Exception {
        if (!(this.trainingParameter instanceof MaxHMMTrainingParameterSet)) {
            throw new IllegalArgumentException("This kind of training is currently not supported.");
        }
        Transition bestTransition = null;
        Emission[] bestEmissions = null;
        double best = Double.NEGATIVE_INFINITY;
        int numberOfStarts = this.trainingParameter.getNumberOfStarts();
        AbstractTerminationCondition tc = ((MaxHMMTrainingParameterSet)this.trainingParameter).getTerminationCondition();
        Compute compute = new Compute(this.threads, this);
        compute.setDataSet(data, weights);
        Time time = Time.getTimeInstance(this.sostream);
        for (int start = 0; start < numberOfStarts; ++start) {
            this.sostream.writeln("start " + start + " ============================");
            if (!this.skipInit) {
                this.initialize(data, weights);
                compute.setParameters();
            }
            double new_value = Double.NEGATIVE_INFINITY;
            int it = 0;
            time.reset();
            while (true) {
                double old_value = new_value;
                new_value = this.getLogPriorTerm() + compute.oneIteration();
                this.sostream.writeln(it++ + "\t" + time.getElapsedTime() + "\t" + new_value + "\t" + (new_value - old_value));
                if (!tc.doNextIteration(it, old_value, new_value, null, null, Double.NaN, time)) break;
                compute.estimateFromStatistics();
            }
            if (!(new_value > best)) continue;
            best = new_value;
            if (numberOfStarts <= 1) continue;
            bestEmissions = (Emission[])ArrayHandler.clone((Cloneable[])this.emission);
            bestTransition = this.transition.clone();
        }
        this.sostream.writeln("best result: " + best);
        if (bestEmissions != null) {
            this.emission = bestEmissions;
            this.transition = bestTransition;
            this.createStates();
        }
        compute.stopThreads();
    }

    private double doOneStep(DataSet data, double[] weights, int start, int end) throws Exception {
        double weight = 1.0;
        double newValue = 0.0;
        for (int n = start; n < end; ++n) {
            Sequence seq = data.getElementAt(n);
            if (weights != null) {
                weight = weights[n];
            }
            if (this.trainingParameter instanceof ViterbiParameterSet) {
                newValue += this.viterbi(null, 0, seq.getLength() - 1, weight, seq);
                continue;
            }
            if (this.trainingParameter instanceof BaumWelchParameterSet) {
                newValue += this.baumWelch(0, seq.getLength() - 1, weight, seq);
                continue;
            }
            throw new IllegalArgumentException("Training mode not available.");
        }
        return newValue;
    }

    protected void initialize(DataSet data, double[] weight) throws Exception {
        this.initializeRandomly();
    }

    protected void initializeRandomly() {
        this.transition.initializeRandomly();
        for (int e = 0; e < this.emission.length; ++e) {
            this.emission[e].initializeFunctionRandomly();
        }
    }

    protected void resetStatistics() {
        ((TrainableTransition)this.transition).resetStatistic();
        for (int e = 0; e < this.emission.length; ++e) {
            this.emission[e].resetStatistic();
        }
    }

    protected void estimateFromStatistics() {
        ((TrainableTransition)this.transition).estimateFromStatistic();
        for (int e = 0; e < this.emission.length; ++e) {
            this.emission[e].estimateFromStatistic();
        }
    }

    @Override
    public final byte getMaximalMarkovOrder() throws UnsupportedOperationException {
        return 127;
    }

    @Override
    public ResultSet getCharacteristics() throws Exception {
        return new ResultSet(this.getNumericalCharacteristics().getResults(), {new StorableResult("model", "the xml representation of the model", this)});
    }

    @Override
    public String getInstanceName() {
        return "HMM(" + this.transition.getMaximalMarkovOrder() + ") " + this.trainingParameter.getClass().getSimpleName();
    }

    @Override
    public double[] getLogScoreFor(DataSet data) throws Exception {
        double[] logProb = new double[data.getNumberOfElements()];
        this.getLogScoreFor(data, logProb);
        return logProb;
    }

    @Override
    public void getLogScoreFor(DataSet data, double[] res) throws Exception {
        if (!data.getAlphabetContainer().checkConsistency(this.getAlphabetContainer())) {
            throw new WrongAlphabetException("The AlphabetContainer of the sample and the model do not match.");
        }
        int len = this.getLength();
        int l = data.getElementLength();
        if (len != 0 && l != len) {
            throw new WrongLengthException("The length of the sample and the model do not match.");
        }
        for (int n = 0; n < data.getNumberOfElements(); ++n) {
            Sequence seq = data.getElementAt(n);
            res[n] = this.logProb(0, seq.getLength() - 1, seq);
        }
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        return null;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    protected void finalize() throws Throwable {
        this.emission = null;
        this.emissionIdx = null;
        this.forward = null;
        this.name = null;
        this.container = null;
        this.numberOfSummands = null;
        this.logEmission = null;
        this.forwardIntermediate = null;
        this.backwardIntermediate = null;
        super.finalize();
    }

    public void samplePath(IntList path, int startPos, int endPos, Sequence seq) throws Exception {
        double logTransition;
        int stateID;
        int n;
        this.fillBwdMatrix(startPos, endPos, seq);
        int l = 0;
        int context = 0;
        this.provideMatrix(0, endPos - startPos + 1);
        path.clear();
        while (startPos <= endPos) {
            n = this.transition.getNumberOfChildren(l, context);
            for (stateID = 0; stateID < n; ++stateID) {
                this.transition.fillTransitionInformation(l, context, stateID, this.container);
                logTransition = this.transition.getLogScoreFor(l, context, stateID, seq, startPos);
                this.backwardIntermediate[stateID] = this.bwdMatrix[l + this.container[2]][this.container[1]] + this.states[this.container[0]].getLogScoreFor(startPos, startPos, seq) + logTransition;
            }
            Normalisation.logSumNormalisation(this.backwardIntermediate, 0, n);
            stateID = AbstractMixtureTrainSM.draw(this.backwardIntermediate, 0);
            this.transition.fillTransitionInformation(l, context, stateID, this.container);
            path.add(this.container[0]);
            context = this.container[1];
            l += this.container[2];
            startPos += this.container[2];
        }
        int last = path.get(path.length() - 1);
        while (true) {
            int add;
            n = this.transition.getNumberOfChildren(l, context);
            this.stateList.clear();
            for (stateID = 0; stateID < n; ++stateID) {
                this.transition.fillTransitionInformation(l, context, stateID, this.container);
                if (!this.states[this.container[0]].isSilent()) continue;
                logTransition = this.transition.getLogScoreFor(l, context, stateID, seq, startPos);
                this.backwardIntermediate[this.stateList.length()] = this.bwdMatrix[l][this.container[1]] + logTransition;
                this.stateList.add(stateID);
            }
            if (this.finalState[last]) {
                this.backwardIntermediate[this.stateList.length()] = 0.0;
                add = 1;
            } else {
                add = 0;
            }
            Normalisation.logSumNormalisation(this.backwardIntermediate, 0, this.stateList.length() + add);
            n = AbstractMixtureTrainSM.draw(this.backwardIntermediate, 0);
            if (add == 1 && n == this.stateList.length()) break;
            this.transition.fillTransitionInformation(l, context, this.stateList.get(n), this.container);
            path.add(this.container[0]);
            context = this.container[1];
            l += this.container[2];
            startPos += this.container[2];
            last = this.container[0];
        }
    }

    private double computeLogScoreFromForward(int l) {
        double res = Double.NEGATIVE_INFINITY;
        if (this.transition.getMaximalMarkovOrder() > 0) {
            for (int i = 0; i < this.fwdMatrix[l].length; ++i) {
                if (!this.finalState[this.transition.getLastContextState(l, i)]) continue;
                res = Normalisation.getLogSum(res, this.fwdMatrix[l][i]);
            }
        } else {
            res = Normalisation.getLogSum(this.fwdMatrix[l]);
        }
        return res;
    }

    private static class Compute {
        WorkerThread[] workers;
        TrainableTransition[] transition;
        Emission[] emission;

        public Compute(int threads, HigherOrderHMM hmm) throws CloneNotSupportedException {
            this.workers = new WorkerThread[threads];
            this.workers[0] = new WorkerThread(0, hmm);
            for (int i = 1; i < threads; ++i) {
                this.workers[i] = new WorkerThread(i, hmm.clone());
            }
            this.transition = new TrainableTransition[threads];
            this.emission = new Emission[threads];
        }

        private synchronized void waitUntilWorkersFinished() {
            int t = -1;
            boolean exception = false;
            while (true) {
                int i;
                for (i = 0; i < this.workers.length && this.workers[i].isWaiting(); ++i) {
                    if (!this.workers[i].exception) continue;
                    t = i;
                    exception = true;
                }
                if (i == this.workers.length) {
                    if (!exception) break;
                    for (i = 0; i < this.workers.length; ++i) {
                        this.workers[i].interrupt();
                    }
                    this.stopThreads();
                    throw new RuntimeException("Terminate program, since at least thread " + t + " throws an exception.");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
        }

        private void stopThreads() {
            for (int i = 0; i < this.workers.length; ++i) {
                this.workers[i].setState(WorkerState.STOP);
                this.workers[i] = null;
            }
        }

        private void setDataSet(DataSet data, double[] weights) {
            int last = 0;
            int N = data.getNumberOfElements();
            for (int i = 0; i < this.workers.length - 1; ++i) {
                this.workers[i].set(last, (i + 1) * N / this.workers.length, data, weights);
                last = this.workers[i].end;
            }
            this.workers[this.workers.length - 1].set(last, N, data, weights);
        }

        private double oneIteration() {
            for (int i = 0; i < this.workers.length; ++i) {
                this.workers[i].hmm.resetStatistics();
                this.workers[i].setState(WorkerState.TRAIN);
            }
            this.waitUntilWorkersFinished();
            double res = 0.0;
            for (int i = 0; i < this.workers.length; ++i) {
                res += this.workers[i].getScore();
            }
            return res;
        }

        private void estimateFromStatistics() {
            if (this.workers.length > 1) {
                for (int i = 0; i < this.workers.length; ++i) {
                    this.transition[i] = (TrainableTransition)this.workers[i].hmm.transition;
                }
                ((TrainableTransition)this.workers[0].hmm.transition).joinStatistics(this.transition);
                for (int e = 0; e < this.workers[0].hmm.emission.length; ++e) {
                    for (int j = 0; j < this.workers.length; ++j) {
                        this.emission[j] = this.workers[j].hmm.emission[e];
                    }
                    this.workers[0].hmm.emission[e].joinStatistics(this.emission);
                }
            }
            this.workers[0].hmm.estimateFromStatistics();
            this.setParameters();
        }

        private void setParameters() {
            for (int i = 1; i < this.workers.length; ++i) {
                this.workers[i].hmm.transition.setParameters(this.workers[0].hmm.transition);
                for (int e = 0; e < this.workers[0].hmm.emission.length; ++e) {
                    this.workers[i].hmm.emission[e].setParameters(this.workers[0].hmm.emission[e]);
                }
            }
        }

        private class WorkerThread
        extends Thread {
            private boolean exception;
            private WorkerState state;
            private int idx;
            private int start;
            private int end;
            private double score;
            private DataSet data;
            private double[] weights;
            private HigherOrderHMM hmm;

            public WorkerThread(int idx, HigherOrderHMM hmm) {
                this.idx = idx;
                this.hmm = hmm;
                this.setDaemon(true);
                this.state = WorkerState.WAIT;
                this.start();
            }

            private void set(int start, int end, DataSet data, double[] weights) {
                this.start = start;
                this.end = end;
                this.score = 0.0;
                this.data = data;
                this.weights = weights;
                this.state = WorkerState.WAIT;
            }

            public double getScore() {
                return this.score;
            }

            public synchronized void setState(WorkerState state) {
                this.state = state;
                this.notify();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void run() {
                this.exception = false;
                while (this.state != WorkerState.STOP) {
                    if (this.state == WorkerState.WAIT) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {}
                        continue;
                    }
                    try {
                        this.score = this.hmm.doOneStep(this.data, this.weights, this.start, this.end);
                    }
                    catch (Exception e) {
                        this.exception = true;
                        e.printStackTrace();
                    }
                    Compute compute = Compute.this;
                    synchronized (compute) {
                        this.state = WorkerState.WAIT;
                        Compute.this.notify();
                    }
                }
            }

            public boolean isWaiting() {
                return this.state == WorkerState.WAIT;
            }
        }

        private static enum WorkerState {
            TRAIN,
            WAIT,
            STOP;

        }
    }

    protected static enum Type {
        LIKELIHOOD,
        VITERBI,
        BAUM_WELCH;

    }
}

