/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.DataType;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.TwoClassAbstractPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;

public class PositivePredictiveValueForFixedSensitivity
extends TwoClassAbstractPerformanceMeasure
implements NumericalPerformanceMeasure {
    public PositivePredictiveValueForFixedSensitivity() {
        try {
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Sensitivity", "The fixed sensitivity for the positive predictive value.", true, new NumberValidator<Double>(0.0, 1.0), 0.95)});
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
    }

    public PositivePredictiveValueForFixedSensitivity(double sensitivity) throws Exception {
        this();
        this.getParameterAt(0).setValue(sensitivity);
    }

    public PositivePredictiveValueForFixedSensitivity(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public String getName() {
        return "Positive predictive value for fixed sensitivity";
    }

    @Override
    public NumericalResultSet compute(double[] sortedScoresClass0, double[] sortedScoresClass1) {
        int j;
        double sensitivity = (Double)this.getParameterAt(0).getValue();
        int d = sortedScoresClass1.length;
        int i = d - 1;
        double threshold = sortedScoresClass0[j];
        for (j = (int)Math.ceil((1.0 - sensitivity) * (double)(sortedScoresClass0.length - 1)); j >= 0 && sortedScoresClass0[j] == threshold; --j) {
        }
        j = sortedScoresClass0.length - 1 - j;
        while (i >= 0 && sortedScoresClass1[i] >= threshold) {
            --i;
        }
        i = d - 1 - i;
        return new NumericalResultSet(new NumericalResult[][]{{new NumericalResult(this.getName() + " of " + sensitivity, "", (double)j / (double)(i + j)), new NumericalResult("Threshold for the " + this.getName().toLowerCase() + " of " + sensitivity, "", threshold)}});
    }

    @Override
    public NumericalResultSet compute(double[][][] classSpecificScores) {
        return (NumericalResultSet)super.compute(classSpecificScores);
    }
}

