/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.graphs;

import java.util.Arrays;
import java.util.LinkedList;

public class Chu_Liu_Edmonds {
    public static final byte MAXIMALBRANCHING = 0;
    public static final byte MINIMALBRANCHING = 1;
    private static final double[] INFTY = new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
    private static final byte[] NULLBYTEARRAY = new byte[0];

    private Chu_Liu_Edmonds() {
    }

    public static byte[][] getOptimalBranching(double[][] graph, double[][] rootWeights, byte type) throws IllegalArgumentException, Exception {
        if (!(type == 0 ^ type == 1)) {
            throw new IllegalArgumentException("Error in Chu_Liu_Edmonds.getOptimalBranching(): given type has to be either Chu_Liu_Edmonds.MAXIMALBRANCHING or Chu_Liu_Edmonds.MINIMALBRANCHING");
        }
        byte root = -1;
        double[][] optimalResult = null;
        if (rootWeights.length == 0 || rootWeights == null) {
            optimalResult = Chu_Liu_Edmonds.Chu_Liu_Edmonds_Algo(Chu_Liu_Edmonds.copyGraph(graph, type), root, type);
        } else {
            double optimalScore = INFTY[type];
            for (byte i = 0; i < rootWeights.length; i = (byte)(i + 1)) {
                root = i;
                double[][] result = Chu_Liu_Edmonds.Chu_Liu_Edmonds_Algo(Chu_Liu_Edmonds.copyGraph(graph, type), root, type);
                double tempScore = 0.0;
                block1: for (int l = 0; l < result.length; l = (int)((byte)(l + 1))) {
                    for (int j = 0; j < result[l].length; j = (int)((byte)(j + 1))) {
                        if (Double.isInfinite(result[l][j])) continue;
                        tempScore += result[l][j];
                        continue block1;
                    }
                }
                if (!(type == 0 && tempScore + rootWeights[root][0] > optimalScore) && (type != 1 || !(tempScore + rootWeights[root][0] < optimalScore))) continue;
                optimalScore = tempScore + rootWeights[root][0];
                optimalResult = result;
            }
        }
        byte[][] randVarDeps = new byte[graph.length][];
        for (byte l = 0; l < optimalResult.length; l = (byte)((byte)(l + 1))) {
            boolean foundDep = false;
            for (byte j = 0; j < optimalResult[l].length; j = (byte)((byte)(j + 1))) {
                if (Double.isInfinite(optimalResult[l][j])) continue;
                byte[] temp = new byte[]{j, l};
                randVarDeps[l] = temp;
                foundDep = true;
                break;
            }
            if (foundDep) continue;
            byte[] temp = new byte[]{l};
            randVarDeps[l] = temp;
        }
        return randVarDeps;
    }

    private static double[][] Chu_Liu_Edmonds_Algo(double[][] graph, byte root, byte type) throws Exception {
        byte[] parents = new byte[graph.length];
        Arrays.fill(parents, (byte)-1);
        for (byte i = 0; i < graph.length; i = (byte)(i + 1)) {
            int tempParent;
            parents[i] = i != root ? (tempParent = Chu_Liu_Edmonds.getMaxParent(i, graph, type)) : -1;
        }
        byte[][] cycli = Chu_Liu_Edmonds.getCycles(parents);
        byte[] tempCycle = cycli.length == 0 ? NULLBYTEARRAY : cycli[0];
        if (tempCycle.length != 0) {
            if (tempCycle.length == graph.length) {
                byte unoptimalRandVar = (byte)Chu_Liu_Edmonds.getMostUnoptimalParams(graph, tempCycle, parents, type)[0];
                parents[unoptimalRandVar] = -1;
                Chu_Liu_Edmonds.reduceGraph(graph, parents, type);
                return graph;
            }
            if (tempCycle.length == 1) {
                throw new Exception("Error in Chu_Liu_Edmonds: Cycle has length 1");
            }
            Arrays.sort(tempCycle);
            double[] temp = Chu_Liu_Edmonds.getMostUnoptimalParams(graph, tempCycle, parents, type);
            double cycleMostUnoptimalScore = temp[2];
            byte mostUnoptimalRandVar = (byte)temp[0];
            byte mostUnoptimalParent = (byte)temp[1];
            int tempCycleCounter = 0;
            int newRandVarOrderCounter = 0;
            byte newPosOfRoot = -1;
            byte[] newRandVarOrder = new byte[graph.length];
            for (int m = 0; m < newRandVarOrder.length; m = (int)((byte)(m + 1))) {
                if (tempCycleCounter >= tempCycle.length || m != tempCycle[tempCycleCounter]) {
                    int n = newRandVarOrderCounter;
                    newRandVarOrderCounter = (byte)(newRandVarOrderCounter + 1);
                    newRandVarOrder[n] = m;
                    if (m != root) continue;
                    newPosOfRoot = (byte)(newRandVarOrderCounter - 1);
                    continue;
                }
                newRandVarOrder[newRandVarOrder.length - 1 - tempCycleCounter] = m;
                tempCycleCounter = (byte)(tempCycleCounter + 1);
            }
            double[][] reducedMatrix = new double[graph.length - tempCycle.length + 1][graph.length - tempCycle.length + 1];
            byte[] maxHeadFromIngoingEdge = new byte[reducedMatrix.length - 1];
            int cycleRegion = newRandVarOrder.length - tempCycle.length;
            for (int m = 0; m < newRandVarOrder.length; m = (int)((byte)(m + 1))) {
                for (int l = 0; l < newRandVarOrder.length; l = (int)((byte)(l + 1))) {
                    if (m < cycleRegion && l < cycleRegion) {
                        if (m == l) {
                            reducedMatrix[m][l] = INFTY[type];
                            continue;
                        }
                        reducedMatrix[m][l] = graph[newRandVarOrder[m]][newRandVarOrder[l]];
                        continue;
                    }
                    if (m < cycleRegion && l >= cycleRegion) {
                        if (l == cycleRegion) {
                            reducedMatrix[m][cycleRegion] = graph[newRandVarOrder[m]][newRandVarOrder[l]];
                            continue;
                        }
                        switch (type) {
                            case 0: {
                                if (!(reducedMatrix[m][cycleRegion] < graph[newRandVarOrder[m]][newRandVarOrder[l]])) break;
                                reducedMatrix[m][cycleRegion] = graph[newRandVarOrder[m]][newRandVarOrder[l]];
                                break;
                            }
                            case 1: {
                                if (!(reducedMatrix[m][cycleRegion] > graph[newRandVarOrder[m]][newRandVarOrder[l]])) break;
                                reducedMatrix[m][cycleRegion] = graph[newRandVarOrder[m]][newRandVarOrder[l]];
                            }
                        }
                        continue;
                    }
                    if (m >= cycleRegion && l < cycleRegion) {
                        double tempScore;
                        if (m == cycleRegion) {
                            reducedMatrix[cycleRegion][l] = tempScore = graph[newRandVarOrder[m]][newRandVarOrder[l]] + cycleMostUnoptimalScore - graph[newRandVarOrder[m]][parents[newRandVarOrder[m]]];
                            maxHeadFromIngoingEdge[l] = m;
                            continue;
                        }
                        tempScore = graph[newRandVarOrder[m]][newRandVarOrder[l]] + cycleMostUnoptimalScore - graph[newRandVarOrder[m]][parents[newRandVarOrder[m]]];
                        switch (type) {
                            case 0: {
                                if (!(reducedMatrix[cycleRegion][l] < tempScore)) break;
                                reducedMatrix[cycleRegion][l] = tempScore;
                                maxHeadFromIngoingEdge[l] = m;
                                break;
                            }
                            case 1: {
                                if (!(reducedMatrix[cycleRegion][l] > tempScore)) break;
                                reducedMatrix[cycleRegion][l] = tempScore;
                                maxHeadFromIngoingEdge[l] = m;
                            }
                        }
                        continue;
                    }
                    if (newRandVarOrder[l] == parents[newRandVarOrder[m]]) continue;
                    graph[newRandVarOrder[m]][newRandVarOrder[l]] = INFTY[type];
                }
            }
            reducedMatrix[reducedMatrix.length - 1][reducedMatrix.length - 1] = INFTY[type];
            double[][] newWeights = Chu_Liu_Edmonds.Chu_Liu_Edmonds_Algo(reducedMatrix, newPosOfRoot, type);
            boolean exsistsIngoingEdge = false;
            int headNodeOfIngoingEdge = -1;
            for (int m = 0; m < newRandVarOrder.length; m = (int)((byte)(m + 1))) {
                for (int l = 0; l < newRandVarOrder.length; l = (int)((byte)(l + 1))) {
                    if (m < cycleRegion && l < cycleRegion) {
                        graph[newRandVarOrder[m]][newRandVarOrder[l]] = reducedMatrix[m][l];
                        continue;
                    }
                    if (m < cycleRegion && l >= cycleRegion) {
                        if (Double.isInfinite(reducedMatrix[m][cycleRegion]) || graph[newRandVarOrder[m]][newRandVarOrder[l]] != reducedMatrix[m][cycleRegion]) {
                            graph[newRandVarOrder[m]][newRandVarOrder[l]] = INFTY[type];
                            continue;
                        }
                        graph[newRandVarOrder[m]][newRandVarOrder[l]] = reducedMatrix[m][cycleRegion];
                        continue;
                    }
                    if (m < cycleRegion || l >= cycleRegion) continue;
                    if (Double.isInfinite(reducedMatrix[cycleRegion][l])) {
                        graph[newRandVarOrder[m]][newRandVarOrder[l]] = INFTY[type];
                        continue;
                    }
                    exsistsIngoingEdge = true;
                    if (m != maxHeadFromIngoingEdge[l]) {
                        graph[newRandVarOrder[m]][newRandVarOrder[l]] = INFTY[type];
                        continue;
                    }
                    headNodeOfIngoingEdge = newRandVarOrder[m];
                }
            }
            if (exsistsIngoingEdge) {
                graph[headNodeOfIngoingEdge][parents[headNodeOfIngoingEdge]] = INFTY[type];
            } else {
                graph[mostUnoptimalRandVar][mostUnoptimalParent] = INFTY[type];
            }
            return graph;
        }
        Chu_Liu_Edmonds.reduceGraph(graph, parents, type);
        return graph;
    }

    private static byte[][] getCycles(byte[] parents) {
        boolean[] traversed = new boolean[parents.length];
        boolean[] tempWalk = new boolean[parents.length];
        Arrays.fill(traversed, false);
        LinkedList<byte[]> cycli = new LinkedList<byte[]>();
        for (int randVar = 0; randVar < parents.length; randVar = (int)((byte)(randVar + 1))) {
            if (traversed[randVar]) continue;
            int tempRandVar = randVar;
            Arrays.fill(tempWalk, false);
            while (tempRandVar != -1 && !tempWalk[tempRandVar] && !traversed[tempRandVar]) {
                tempWalk[tempRandVar] = true;
                tempRandVar = parents[tempRandVar];
            }
            if (tempRandVar != -1 && !traversed[tempRandVar]) {
                int cycleLength = 0;
                int cycleElement = tempRandVar;
                do {
                    tempRandVar = parents[tempRandVar];
                    ++cycleLength;
                } while (tempRandVar != cycleElement);
                byte[] cyclus = new byte[cycleLength];
                tempRandVar = cycleElement;
                for (int i = 0; i < cyclus.length; i = (int)((byte)(i + 1))) {
                    cyclus[i] = tempRandVar;
                    tempRandVar = parents[tempRandVar];
                }
                cycli.add(cyclus);
            }
            int i = 0;
            while (i < traversed.length) {
                traversed[i] = traversed[i] | tempWalk[i++];
            }
        }
        if (cycli.size() == 0) {
            return new byte[0][0];
        }
        int size = cycli.size();
        byte[][] ret = new byte[size][];
        for (int i = 0; i < size; ++i) {
            ret[i] = (byte[])cycli.removeFirst();
        }
        return ret;
    }

    private static byte getMaxParent(byte randVar, double[][] weights, byte type) {
        int optimalParent = -1;
        double optimalScore = INFTY[type];
        switch (type) {
            case 1: {
                for (int i = 0; i < weights[randVar].length; i = (int)((byte)(i + 1))) {
                    if (i == randVar || !(weights[randVar][i] < optimalScore)) continue;
                    optimalScore = weights[randVar][i];
                    optimalParent = i;
                }
                break;
            }
            case 0: {
                for (int i = 0; i < weights[randVar].length; i = (int)((byte)(i + 1))) {
                    if (i == randVar || !(weights[randVar][i] > optimalScore)) continue;
                    optimalScore = weights[randVar][i];
                    optimalParent = i;
                }
                break;
            }
        }
        return (byte)optimalParent;
    }

    private static void reduceGraph(double[][] graph, byte[] parents, byte type) {
        for (int m = 0; m < graph.length; m = (int)((byte)(m + 1))) {
            for (int l = 0; l < graph.length; l = (int)((byte)(l + 1))) {
                if (m == l || l == parents[m]) continue;
                graph[m][l] = INFTY[type];
            }
        }
    }

    private static double[] getMostUnoptimalParams(double[][] graph, byte[] tempCycle, byte[] parents, byte type) {
        double mostUnoptimalScore = INFTY[1 - type];
        double[] ret = new double[3];
        block4: for (int m = 0; m < tempCycle.length; m = (int)((byte)(m + 1))) {
            switch (type) {
                case 0: {
                    if (!(graph[tempCycle[m]][parents[tempCycle[m]]] < mostUnoptimalScore)) continue block4;
                    mostUnoptimalScore = graph[tempCycle[m]][parents[tempCycle[m]]];
                    ret[0] = tempCycle[m];
                    ret[1] = parents[tempCycle[m]];
                    continue block4;
                }
                case 1: {
                    if (!(graph[tempCycle[m]][parents[tempCycle[m]]] > mostUnoptimalScore)) continue block4;
                    mostUnoptimalScore = graph[tempCycle[m]][parents[tempCycle[m]]];
                    ret[0] = tempCycle[m];
                    ret[1] = parents[tempCycle[m]];
                }
            }
        }
        ret[2] = mostUnoptimalScore;
        return ret;
    }

    private static double[][] copyGraph(double[][] graph, byte type) {
        double[][] ret = new double[graph.length][graph.length];
        for (int i = 0; i < graph.length; ++i) {
            for (int j = 0; j < graph.length; ++j) {
                ret[i][j] = i == j ? INFTY[type] : graph[i][j];
            }
        }
        return ret;
    }

    private static void printMatrix(double[][] m) {
        System.out.println("matrixausgabe:***********************");
        for (int i = 0; i < m.length; i = (int)((byte)(i + 1))) {
            for (int j = 0; j < m[i].length; j = (int)((byte)(j + 1))) {
                System.out.print(m[i][j] + "\t");
            }
            System.out.println();
        }
        System.out.println("ende*********************************");
    }

    private static void printCycle(byte[] c) {
        System.out.println("start Zyklus:****************");
        for (int i = 0; i < c.length; ++i) {
            System.out.print(c[i] + "\t");
        }
        System.out.println("\nende Zyklus******************");
    }
}

