/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.geodesic;

import de.jtem.numericalMethods.geometry.geodesic.IntTriple;

public class TriangleStrip {
    TriangleStrip() {
    }

    public static int[] getStripBetweenElements(int[][] nArray, int[][] nArray2, int n, int n2) {
        int[] nArray3;
        int n3 = nArray.length;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        if (n >= 0 && n < n3 && n2 >= 0 && n2 < n3) {
            throw new IllegalArgumentException("elements are not part of triangulations");
        }
        int[] nArray4 = new int[n3];
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        int n7 = 0;
        while (n7 < n3) {
            nArray6[n7++] = -1;
        }
        nArray4[n6++] = n;
        while (n4 != n2 && n6 > 0) {
            ++n5;
            int n8 = 0;
            for (int i = 0; i < n6; ++i) {
                int n9 = nArray4[i];
                for (n7 = 0; n7 < 3; ++n7) {
                    n4 = nArray2[n9][n7];
                    if (n4 != -1 && nArray6[n4] == -1) {
                        nArray5[n8++] = n4;
                        nArray6[n4] = n9;
                    }
                    if (n4 == n2) break;
                }
                if (n4 == n2) break;
            }
            nArray3 = nArray4;
            nArray4 = nArray5;
            n6 = n8;
            nArray5 = nArray3;
        }
        if (n4 != n2) {
            return null;
        }
        nArray3 = new int[n5 + 1];
        n7 = n5;
        nArray3[n7] = n2;
        int n10 = nArray3[n7];
        while (n7 > 0) {
            n10 = nArray3[--n7] = nArray6[n10];
        }
        return nArray3;
    }

    public static int[] getOptimizedStrip(int[][] nArray, int[] nArray2) {
        int n = TriangleStrip.optimizeStrip(nArray, nArray2, 2);
        if (n == nArray2.length) {
            return nArray2;
        }
        int[] nArray3 = new int[n];
        System.arraycopy(nArray2, 0, nArray3, 0, n);
        return nArray3;
    }

    public static int[] getComplexOptimizedStrip(int[][] nArray, int[] nArray2) {
        int n = TriangleStrip.optimizeStrip(nArray, nArray2, 1);
        if (n == nArray2.length) {
            return nArray2;
        }
        int[] nArray3 = new int[n];
        System.arraycopy(nArray2, 0, nArray3, 0, n);
        return nArray3;
    }

    static int optimizeStrip(int[][] nArray, int[] nArray2, int n) {
        int n2 = nArray2.length;
        int[] nArray3 = new int[3];
        while (n2 > 1) {
            int n3 = 0;
            int n4 = nArray2[n3];
            for (int i = 1; i < n2; ++i) {
                int n5 = nArray2[i];
                int n6 = IntTriple.getMap(nArray3, nArray[n4], nArray[n5]);
                if (n6 == 0) {
                    throw new RuntimeException("strip is not connected");
                }
                if (i + 1 < n2) {
                    int n7;
                    int n8;
                    int n9 = IntTriple.getMap(nArray3, nArray[n5], nArray[nArray2[i + 1]]);
                    for (int j = i + 1; j < n2 && (n8 = IntTriple.getMap(nArray3, nArray[n4], nArray[n7 = nArray2[j]])) != 0; ++j) {
                        if (n8 <= n && n8 < n6 && (j != i + 1 || n8 < n9)) continue;
                        i = j;
                        n5 = n7;
                        n6 = n8;
                    }
                }
                nArray2[++n3] = n4 = n5;
            }
            if (n2 == n3 + 1) break;
            n2 = n3 + 1;
        }
        return n2;
    }

    public static int[] getSimpleOptimizedStrip(int[][] nArray, int[] nArray2) {
        int n = nArray2.length;
        while (n > 1) {
            int n2 = 0;
            int n3 = nArray2[n2];
            int n4 = 1;
            while (n4 < n) {
                int n5 = nArray2[n4];
                if (n5 == n3) {
                    ++n4;
                    continue;
                }
                int n6 = n4 + 1;
                if (n6 < n) {
                    int n7 = nArray2[n6];
                    if (n7 != n3) {
                        nArray2[++n2] = n3 = n5;
                        n4 = n6;
                        continue;
                    }
                    if (n2 > 0) {
                        n3 = nArray2[--n2];
                        n4 = n6;
                        continue;
                    }
                    n4 = n6 + 1;
                    continue;
                }
                nArray2[++n2] = n5;
                break;
            }
            if (n == n2 + 1) break;
            n = n2 + 1;
        }
        if (n == nArray2.length) {
            return nArray2;
        }
        int[] nArray3 = new int[n];
        System.arraycopy(nArray2, 0, nArray3, 0, n);
        return nArray3;
    }
}

