/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.gui.sequence.OverlayMarker;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.seq.FeatureHolder;

public class LayeredRenderer {
    public static final LayeredRenderer INSTANCE = new LayeredRenderer();

    public double getDepth(List srcL, List renderers) {
        if (srcL.size() != renderers.size()) {
            throw new IllegalArgumentException("srcL and renderers must be the same size: " + srcL.size() + ":" + renderers.size());
        }
        double depth = 0.0;
        Iterator srcI = srcL.iterator();
        Iterator i = renderers.iterator();
        while (srcI.hasNext() && i.hasNext()) {
            SequenceRenderContext src = (SequenceRenderContext)srcI.next();
            SequenceRenderer sRend = (SequenceRenderer)i.next();
            if (sRend instanceof OverlayMarker) {
                depth += 0.0;
                continue;
            }
            depth += sRend.getDepth(src);
        }
        return depth;
    }

    public double getMinimumLeader(List srcL, List renderers) {
        if (srcL.size() != renderers.size()) {
            throw new IllegalArgumentException("srcL and renderers must be the same size: " + srcL.size() + ":" + renderers.size());
        }
        double max = 0.0;
        Iterator srcI = srcL.iterator();
        Iterator i = renderers.iterator();
        while (srcI.hasNext() && i.hasNext()) {
            SequenceRenderContext src = (SequenceRenderContext)srcI.next();
            SequenceRenderer sRend = (SequenceRenderer)i.next();
            max = Math.max(max, sRend.getMinimumLeader(src));
        }
        return max;
    }

    public double getMinimumTrailer(List srcL, List renderers) {
        if (srcL.size() != renderers.size()) {
            throw new IllegalArgumentException("srcL and renderers must be the same size: " + srcL.size() + ":" + renderers.size());
        }
        double max = 0.0;
        Iterator srcI = srcL.iterator();
        Iterator i = renderers.iterator();
        while (srcI.hasNext() && i.hasNext()) {
            SequenceRenderContext src = (SequenceRenderContext)srcI.next();
            SequenceRenderer sRend = (SequenceRenderer)i.next();
            max = Math.max(max, sRend.getMinimumTrailer(src));
        }
        return max;
    }

    public void paint(Graphics2D g, List srcL, List renderers) {
        if (srcL.size() != renderers.size()) {
            throw new IllegalArgumentException("srcL and renderers must be the same size: " + srcL.size() + ":" + renderers.size());
        }
        double offset = 0.0;
        double allocatedOffset = 0.0;
        Iterator srcI = srcL.iterator();
        Iterator i = renderers.iterator();
        Rectangle2D.Double clip = new Rectangle2D.Double();
        while (srcI.hasNext() && i.hasNext()) {
            SequenceRenderContext src = (SequenceRenderContext)srcI.next();
            SequenceRenderer sRend = (SequenceRenderer)i.next();
            int dir = src.getDirection();
            double depth = sRend.getDepth(src);
            double minP = src.sequenceToGraphics(src.getRange().getMin()) - sRend.getMinimumLeader(src);
            double maxP = src.sequenceToGraphics(src.getRange().getMax() + 1) + sRend.getMinimumTrailer(src);
            if (dir == 0) {
                clip.setFrame(minP, 0.0, maxP - minP + 1.0, depth + 1.0);
                g.translate(0.0, offset);
            } else {
                clip.setFrame(0.0, minP, depth + 1.0, maxP - minP + 1.0);
                g.translate(offset, 0.0);
            }
            Shape oldClip = g.getClip();
            g.clip(clip);
            sRend.paint(g, src);
            g.setClip(oldClip);
            if (dir == 0) {
                g.translate(0.0, -offset);
            } else {
                g.translate(-offset, 0.0);
            }
            if (sRend instanceof OverlayMarker) {
                allocatedOffset = Math.max(allocatedOffset, sRend.getDepth(src));
                continue;
            }
            offset += Math.max(sRend.getDepth(src), allocatedOffset);
            allocatedOffset = 0.0;
        }
    }

    public SequenceViewerEvent processMouseEvent(List srcL, MouseEvent me, List path, List renderers) {
        if (srcL.size() != renderers.size()) {
            throw new IllegalArgumentException("srcL and renderers must be the same size: " + srcL.size() + ":" + renderers.size());
        }
        double offset = 0.0;
        Iterator srcI = srcL.iterator();
        Iterator i = renderers.iterator();
        SequenceViewerEvent sve = null;
        while (srcI.hasNext() && i.hasNext()) {
            SequenceRenderContext src = (SequenceRenderContext)srcI.next();
            SequenceRenderer sRend = (SequenceRenderer)i.next();
            double depth = sRend.getDepth(src);
            SequenceViewerEvent thisSve = null;
            if (src.getDirection() == 0) {
                if ((double)me.getY() >= offset && (double)me.getY() < offset + depth) {
                    me.translatePoint(0, (int)(-offset));
                    thisSve = sRend.processMouseEvent(src, me, path);
                    me.translatePoint(0, (int)offset);
                }
            } else if ((double)me.getX() >= offset && (double)me.getX() < offset + depth) {
                me.translatePoint((int)(-offset), 0);
                thisSve = sRend.processMouseEvent(src, me, path);
                me.translatePoint((int)offset, 0);
            }
            if (thisSve != null) {
                if (sve == null) {
                    sve = thisSve;
                } else if (thisSve.getTarget() instanceof FeatureHolder && ((FeatureHolder)thisSve.getTarget()).countFeatures() > 0) {
                    sve = thisSve;
                }
            }
            if (sRend instanceof OverlayMarker) continue;
            offset += depth;
        }
        return sve;
    }
}

