/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.sql.SQLException;
import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.RealizingFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.biosql.BioSQLFeatureChangeHub;
import org.biojava.bio.seq.db.biosql.BioSQLFeatureReceiver;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceI;
import org.biojava.bio.seq.db.biosql.FeaturesSQL;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.ontology.OntoTools;
import org.biojava.ontology.Term;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

class BioSQLFeature
implements Feature,
RealizingFeatureHolder {
    private Annotation _annotation;
    private int id;
    private String type;
    private String source;
    private Location location;
    private int parentID = -1;
    private final BioSQLSequenceI sequence;
    private SimpleFeatureHolder childFeatures;

    BioSQLFeature(Sequence seq, Feature.Template templ) throws IllegalAlphabetException {
        this.type = templ.type;
        this.source = templ.source;
        this.location = templ.location;
        this.sequence = (BioSQLSequenceI)seq;
        this._annotation = templ.annotation;
    }

    BioSQLFeature(Sequence seq, FeatureHolder parent, Feature.Template templ) throws IllegalAlphabetException {
        this(seq, templ);
        this.parentID = parent instanceof BioSQLFeature ? ((BioSQLFeature)parent)._getInternalID() : -1;
    }

    public void hintChildFree() {
        if (this.childFeatures == null) {
            this.childFeatures = new SimpleFeatureHolder();
        }
    }

    public void setParentID(int i) {
        this.parentID = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(String s) throws ChangeVetoException {
        BioSQLFeatureChangeHub featureHub = this.sequence.getSequenceDB().getFeatureChangeHub();
        ChangeEvent cev = new ChangeEvent(this, Feature.TYPE, this.getType(), s);
        BioSQLFeatureChangeHub bioSQLFeatureChangeHub = featureHub;
        synchronized (bioSQLFeatureChangeHub) {
            featureHub.firePreChange(cev);
            try {
                ((BioSQLSequenceI)this.getSequence()).getSequenceDB().getFeaturesSQL().setFeatureType(this.id, s);
            }
            catch (SQLException ex) {
                throw new BioRuntimeException("Error updating feature in database", ex);
            }
            this.type = s;
            featureHub.firePostChange(cev);
        }
    }

    public String getType() {
        return this.type;
    }

    public Term getTypeTerm() {
        return OntoTools.ANY;
    }

    public void setTypeTerm(Term source) throws ChangeVetoException {
        throw new ChangeVetoException("FIXME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSource(String s) throws ChangeVetoException {
        BioSQLFeatureChangeHub featureHub = this.sequence.getSequenceDB().getFeatureChangeHub();
        ChangeEvent cev = new ChangeEvent(this, Feature.SOURCE, this.getSource(), s);
        BioSQLFeatureChangeHub bioSQLFeatureChangeHub = featureHub;
        synchronized (bioSQLFeatureChangeHub) {
            featureHub.firePreChange(cev);
            try {
                ((BioSQLSequenceI)this.getSequence()).getSequenceDB().getFeaturesSQL().setFeatureSource(this.id, s);
            }
            catch (SQLException ex) {
                throw new BioRuntimeException("Error updating feature in database", ex);
            }
            this.source = s;
            featureHub.firePostChange(cev);
        }
    }

    public String getSource() {
        return this.source;
    }

    public Term getSourceTerm() {
        return OntoTools.ANY;
    }

    public void setSourceTerm(Term source) throws ChangeVetoException {
        throw new ChangeVetoException("FIXME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocation(Location l) throws ChangeVetoException {
        BioSQLFeatureChangeHub featureHub = this.sequence.getSequenceDB().getFeatureChangeHub();
        ChangeEvent cev = new ChangeEvent(this, Feature.LOCATION, this.getLocation(), l);
        BioSQLFeatureChangeHub bioSQLFeatureChangeHub = featureHub;
        synchronized (bioSQLFeatureChangeHub) {
            featureHub.firePreChange(cev);
            try {
                ((BioSQLSequenceI)this.getSequence()).getSequenceDB().getFeaturesSQL().setFeatureLocation(this.id, l, StrandedFeature.UNKNOWN);
            }
            catch (SQLException ex) {
                throw new BioRuntimeException("Error updating feature in database", ex);
            }
            this.location = l;
            featureHub.firePostChange(cev);
        }
    }

    public Location getLocation() {
        return this.location;
    }

    public FeatureHolder getParent() {
        if (this.parentID == -1) {
            return this.sequence;
        }
        return this.sequence.getSequenceDB().getFeatureByID(this.parentID);
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void _setAnnotation(Annotation a) {
        this._annotation = a;
    }

    public Feature realizeFeature(FeatureHolder fh, Feature.Template templ) throws BioException {
        try {
            RealizingFeatureHolder rfh = (RealizingFeatureHolder)this.getParent();
            return rfh.realizeFeature(fh, templ);
        }
        catch (ClassCastException ex) {
            throw new BioException("Couldn't propagate feature creation request.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feature createFeature(Feature.Template templ) throws BioException, ChangeVetoException {
        Feature f = this.realizeFeature(this, templ);
        BioSQLFeatureChangeHub featureHub = this.sequence.getSequenceDB().getFeatureChangeHub();
        ChangeEvent cev = new ChangeEvent(this, FeatureHolder.FEATURES, f, null);
        BioSQLFeatureChangeHub bioSQLFeatureChangeHub = featureHub;
        synchronized (bioSQLFeatureChangeHub) {
            featureHub.firePreChange(cev);
            this.getFeatures().addFeature(f);
            ((BioSQLSequenceI)this.getSequence()).persistFeature(f, this.id);
            featureHub.firePostChange(cev);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeature(Feature f) throws ChangeVetoException {
        BioSQLFeatureChangeHub featureHub = this.sequence.getSequenceDB().getFeatureChangeHub();
        ChangeEvent cev = new ChangeEvent(this, FeatureHolder.FEATURES, null, f);
        BioSQLFeatureChangeHub bioSQLFeatureChangeHub = featureHub;
        synchronized (bioSQLFeatureChangeHub) {
            featureHub.firePreChange(cev);
            this.getFeatures().removeFeature(f);
            ((BioSQLSequenceI)this.getSequence()).getSequenceDB().getFeaturesSQL().removeFeature((BioSQLFeature)f);
            featureHub.firePostChange(cev);
        }
    }

    public Annotation getAnnotation() {
        return this._annotation;
    }

    public void _setInternalID(int i) {
        this.id = i;
    }

    public int _getInternalID() {
        return this.id;
    }

    public synchronized void _addFeature(Feature f) throws ChangeVetoException {
        if (this.childFeatures == null) {
            this.childFeatures = new SimpleFeatureHolder();
        }
        this.childFeatures.addFeature(f);
    }

    protected void fillTemplate(Feature.Template template) {
        template.source = this.source;
        template.type = this.type;
        template.location = this.location;
        template.annotation = this._annotation;
    }

    public Feature.Template makeTemplate() {
        Feature.Template template = new Feature.Template();
        this.fillTemplate(template);
        return template;
    }

    public Iterator features() {
        return this.getFeatures().features();
    }

    public int countFeatures() {
        return this.getFeatures().countFeatures();
    }

    public boolean containsFeature(Feature f) {
        return this.getFeatures().containsFeature(f);
    }

    public FeatureFilter getSchema() {
        return new FeatureFilter.ByParent(new FeatureFilter.ByFeature(this));
    }

    public FeatureHolder filter(FeatureFilter ff) {
        FeatureFilter.And childFilter = new FeatureFilter.And(new FeatureFilter.ContainedByLocation(this.getLocation()), new FeatureFilter.Not(FeatureFilter.top_level));
        if (FilterUtils.areDisjoint(ff, childFilter)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getFeatures().filter(ff);
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        FeatureFilter.ContainedByLocation childFilter = new FeatureFilter.ContainedByLocation(this.getLocation());
        if (FilterUtils.areDisjoint(ff, childFilter)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getFeatures().filter(ff, recurse);
    }

    private synchronized SimpleFeatureHolder getFeatures() {
        if (this.childFeatures == null) {
            try {
                BioSQLSequenceI seqi = this.sequence;
                this.childFeatures = new SimpleFeatureHolder();
                FeaturesSQL adaptor = seqi.getSequenceDB().getFeaturesSQL();
                adaptor.retrieveFeatures(seqi.getBioEntryID(), new FeatureReceiver(), null, this.id, -1);
            }
            catch (SQLException ex) {
                throw new BioRuntimeException("SQL error while reading features", ex);
            }
            catch (BioException ex) {
                throw new BioRuntimeException(ex);
            }
        }
        return this.childFeatures;
    }

    public SymbolList getSymbols() {
        return this.getLocation().symbols(this.getSequence());
    }

    public int hashCode() {
        return this.makeTemplate().hashCode();
    }

    public void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        this.sequence.getSequenceDB().getFeatureChangeHub().addListener(new Integer(this.id), cl, ct);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        this.sequence.getSequenceDB().getFeatureChangeHub().removeListener(new Integer(this.id), cl, ct);
    }

    public boolean isUnchanging(ChangeType ct) {
        return false;
    }

    private class FeatureReceiver
    extends BioSQLFeatureReceiver {
        FeatureReceiver() {
            super(BioSQLFeature.this.sequence);
        }

        protected void deliverTopLevelFeature(Feature f) throws ParseException, ChangeVetoException {
            BioSQLFeature.this.childFeatures.addFeature(f);
        }
    }
}

