/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.hmm.transitions.elements;

import de.jstacs.NonParsableException;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.XMLParser;
import de.jstacs.models.hmm.transitions.elements.BasicTransitionElement;

public class ReferenceBasedTransitionElement
extends BasicTransitionElement {
    protected String annotationID;
    protected double[] probabilities;
    protected double[][] statisticsTransitionProb;
    protected double ess;
    protected int diagElement;

    private static double[] getHyperParameters(double ess, int states) {
        double[] hyper = new double[states];
        ess /= (double)states;
        for (int i = 0; i < states; ++i) {
            hyper[i] = ess;
        }
        return hyper;
    }

    public ReferenceBasedTransitionElement(int[] context, int[] states, double ess, double[] probabilities, String annotationID) {
        this(context, states, ess, probabilities, annotationID, null);
    }

    public ReferenceBasedTransitionElement(int[] context, int[] states, double ess, double[] probabilities, String annotationID, double[] weight) {
        super(context, states, ReferenceBasedTransitionElement.getHyperParameters(ess, states.length), weight);
        this.probabilities = (double[])probabilities.clone();
        this.initializeRandomly();
        this.annotationID = annotationID;
        this.ess = ess;
        this.init();
    }

    public ReferenceBasedTransitionElement(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    protected void init() {
        this.determineDiagonalElement();
        super.init();
    }

    @Override
    public ReferenceBasedTransitionElement clone() throws CloneNotSupportedException {
        ReferenceBasedTransitionElement clone = (ReferenceBasedTransitionElement)super.clone();
        clone.probabilities = (double[])this.probabilities.clone();
        clone.statisticsTransitionProb = (double[][])ArrayHandler.clone((Cloneable[])this.statisticsTransitionProb);
        return clone;
    }

    protected void determineDiagonalElement() {
        this.diagElement = -1;
        if (this.context.length != 0) {
            int last = this.context[this.context.length - 1];
            this.diagElement = 0;
            while (this.diagElement < this.states.length && this.states[this.diagElement] != last) {
                ++this.diagElement;
            }
        }
        if (this.diagElement < 0 || this.diagElement >= this.states.length) {
            throw new IllegalArgumentException("Could not determine the diagonal element.");
        }
    }

    @Override
    protected void precompute() {
    }

    @Override
    public double getLogPriorTerm() {
        if (this.ess == 0.0) {
            return 0.0;
        }
        double logPriorVal = 0.0;
        for (int i = 0; i < this.states.length; ++i) {
            logPriorVal += Math.log(this.parameters[i]) * this.hyperParameters[i];
        }
        return logPriorVal;
    }

    @Override
    public double getLogGammaScoreFromStatistic() {
        return Double.NaN;
    }

    @Override
    public void initializeRandomly() {
        System.arraycopy(this.probabilities, 0, this.parameters, 0, this.states.length);
    }

    @Override
    protected void appendFurtherInformation(StringBuffer xml) {
        XMLParser.appendObjectWithTags(xml, this.annotationID, "annotationID");
        XMLParser.appendObjectWithTags(xml, this.probabilities, "probabilities");
        XMLParser.appendObjectWithTags(xml, this.ess, "ess");
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.annotationID = (String)XMLParser.extractObjectForTags(xml, "annotationID");
        this.probabilities = (double[])XMLParser.extractObjectForTags(xml, "probabilities");
        this.ess = (Double)XMLParser.extractObjectForTags(xml, "ess");
    }
}

