/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.WrongAlphabetException;
import de.jstacs.data.Alphabet;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sequence;
import de.jstacs.data.alphabets.DiscreteAlphabetMapping;
import de.jstacs.data.sequences.SimpleDiscreteSequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;

public class MappedDiscreteSequence
extends SimpleDiscreteSequence {
    protected SimpleDiscreteSequence original;
    protected AlphabetContainer originalAlphabetContainer = null;
    protected DiscreteAlphabetMapping[] transformation;

    public static final AlphabetContainer getNewAlphabetContainer(AlphabetContainer original, DiscreteAlphabetMapping ... transformation) {
        int n = original.getNumberOfAlphabets();
        if (n != 1 && n != transformation.length) {
            throw new IllegalArgumentException("Check number of transformations.");
        }
        int[] index = new int[transformation.length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        Alphabet[] abc = new Alphabet[transformation.length];
        for (int i = 0; i < abc.length; ++i) {
            abc[i] = transformation[i].getNewAlphabet();
        }
        return new AlphabetContainer(abc, index);
    }

    protected MappedDiscreteSequence(AlphabetContainer originalAlphabetContainer, SequenceAnnotation[] seqAn, DiscreteAlphabetMapping ... transformation) throws WrongAlphabetException {
        super(MappedDiscreteSequence.getNewAlphabetContainer(originalAlphabetContainer, transformation), seqAn);
        if (originalAlphabetContainer.getNumberOfAlphabets() > 1) {
            this.originalAlphabetContainer = originalAlphabetContainer;
        }
        this.transformation = (DiscreteAlphabetMapping[])transformation.clone();
    }

    public MappedDiscreteSequence(SimpleDiscreteSequence original, DiscreteAlphabetMapping ... transformation) throws WrongAlphabetException {
        this(original.getAlphabetContainer(), original.getAnnotation(), transformation);
        this.original = original;
    }

    @Override
    public int discreteVal(int pos) {
        return this.transformation[this.getIndex(pos)].getNewDiscreteValue(this.original.discreteVal(pos));
    }

    @Override
    protected Sequence flatCloneWithoutAnnotation() {
        return null;
    }

    @Override
    public int getLength() {
        return this.original.getLength();
    }

    public double getLogNumberOfPossibleOriginalSequences() {
        return this.getLogNumberOfPossibleOriginalSequences(0, this.getLength());
    }

    public double getLogNumberOfPossibleOriginalSequences(int start, int end) {
        double res = 0.0;
        while (start < end) {
            res += this.transformation[this.getIndex(start)].getLogNumberOfSimilarSymbols(this.original.discreteVal(start));
            ++start;
        }
        return res;
    }

    private int getIndex(int pos) {
        return this.originalAlphabetContainer == null ? pos : this.originalAlphabetContainer.getAlphabetIndexForPosition(pos);
    }

    @Override
    public final int[] getEmptyContainer() {
        return new int[1];
    }

    @Override
    public final void fillContainer(int[] container, int pos) {
        container[0] = this.discreteVal(pos);
    }
}

