/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.taxa;

import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.taxa.SimpleTaxon;
import org.biojava.bio.taxa.Taxon;
import org.biojava.bio.taxa.TaxonFactory;
import org.biojava.utils.SmallSet;

public class SimpleTaxonFactory
implements TaxonFactory {
    public static final SimpleTaxonFactory GLOBAL = new SimpleTaxonFactory("GLOBAL");
    private final Taxon root;
    private final String name;
    private final Map taxonBySciName = new HashMap();

    public SimpleTaxonFactory(String name) {
        this.name = name;
        this.root = this.createTaxon("ROOT", "");
    }

    public Taxon getRoot() {
        return this.root;
    }

    public String getName() {
        return this.name;
    }

    public Taxon importTaxon(Taxon taxon) {
        SimpleTaxon can = this.canonicalize(taxon);
        if (can == null) {
            can = new SimpleTaxon(taxon.getScientificName(), taxon.getCommonName());
            for (Taxon child : taxon.getChildren()) {
                this.addChild(can, child);
            }
            return can;
        }
        return can;
    }

    public Taxon createTaxon(String scientificName, String commonName) {
        SimpleTaxon taxon = new SimpleTaxon(scientificName, commonName);
        this.taxonBySciName.put(scientificName, taxon);
        return taxon;
    }

    public Taxon addChild(Taxon parent, Taxon child) {
        if (this.canonicalize(parent) == null) {
            throw new IllegalArgumentException("Parent taxon not owned by this TaxonFactory");
        }
        SimpleTaxon sparent = (SimpleTaxon)parent;
        SimpleTaxon schild = (SimpleTaxon)this.importTaxon(child);
        if (sparent.children == null) {
            sparent.children = new SmallSet();
        }
        sparent.children.add(schild);
        schild.setParent(sparent);
        return schild;
    }

    public Taxon removeChild(Taxon parent, Taxon child) {
        SimpleTaxon sparent = this.canonicalize(parent);
        SimpleTaxon schild = this.canonicalize(child);
        if (sparent == null) {
            throw new IllegalArgumentException("Don't know about parent Taxon");
        }
        if (schild != null && sparent.children != null && sparent.children.remove(schild)) {
            return schild;
        }
        return null;
    }

    public Taxon search(Object id) {
        return (Taxon)this.taxonBySciName.get(id);
    }

    private SimpleTaxon canonicalize(Taxon taxon) {
        return (SimpleTaxon)this.search(taxon.getScientificName());
    }
}

