/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import de.jstacs.InstantiableFromParameterSet;
import de.jstacs.io.RegExFilenameFilter;
import de.jstacs.parameters.CollectionParameter;
import de.jstacs.parameters.InstanceParameterSet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SubclassFinder {
    public static <T> LinkedList<Class<? extends T>> findInstantiableSubclasses(Class<T> clazz, String startPackage) throws ClassNotFoundException, IOException {
        LinkedList<Class<T>> list = SubclassFinder.findSubclasses(clazz, startPackage);
        LinkedList<Class<T>> list2 = new LinkedList<Class<T>>();
        for (Class clazz2 : list) {
            if (clazz2.isInterface() || Modifier.isAbstract(clazz2.getModifiers())) continue;
            list2.add(clazz2);
        }
        return list2;
    }

    public static <S, T> LinkedList<Class<? extends S>> filterBySuperclass(Class<S> superclass, LinkedList<Class<? extends T>> listToFilter) {
        LinkedList<Class<S>> list2 = new LinkedList<Class<S>>();
        for (Class clazz : listToFilter) {
            if (!superclass.isAssignableFrom(clazz)) continue;
            list2.add(clazz);
        }
        return list2;
    }

    public static LinkedList<Class<? extends InstanceParameterSet>> getParameterSetFor(Class<? extends InstantiableFromParameterSet> clazz) {
        Constructor<?>[] cons = clazz.getConstructors();
        Class<?>[] types = null;
        LinkedList<Class<? extends InstanceParameterSet>> list = new LinkedList<Class<? extends InstanceParameterSet>>();
        for (int i = 0; i < cons.length; ++i) {
            types = cons[i].getParameterTypes();
            if (types.length != 1 || !InstanceParameterSet.class.isAssignableFrom(types[0])) continue;
            list.add(types[0]);
        }
        return list;
    }

    public static <T> LinkedList<Class<? extends T>> findSubclasses(Class<T> clazz, String startPackage) throws ClassNotFoundException, IOException {
        String name = startPackage;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        name = name.replace(".", "/");
        URL[] urls = SubclassFinder.getResources(name);
        LinkedList<Class<T>> list = new LinkedList<Class<T>>();
        for (URL url : urls) {
            if (url == null) continue;
            File dir = new File(url.getFile());
            if (dir.exists()) {
                File[] files = dir.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        list.addAll(SubclassFinder.findSubclasses(clazz, startPackage + "." + files[i].getName()));
                        continue;
                    }
                    if (!files[i].isFile() || !files[i].getName().endsWith(".class")) continue;
                    SubclassFinder.add(clazz, list, startPackage + "." + files[i].getName().substring(0, files[i].getName().lastIndexOf(".")));
                }
                continue;
            }
            JarURLConnection con = (JarURLConnection)url.openConnection();
            JarFile jar = con.getJarFile();
            String starts = con.getEntryName();
            Enumeration<JarEntry> en = jar.entries();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                String entryname = entry.getName();
                if (starts != null && !entryname.startsWith(starts) || !entryname.endsWith(".class")) continue;
                String classname = entryname.substring(0, entryname.length() - 6);
                if (classname.startsWith("/")) {
                    classname.substring(1);
                }
                SubclassFinder.add(clazz, list, classname.replace("/", "."));
            }
        }
        return list;
    }

    private static <T> void add(Class<T> clazz, AbstractList<Class<? extends T>> list, String className) {
        try {
            Class<?> c = Class.forName(className);
            if (clazz.isAssignableFrom(c)) {
                list.add(c);
            }
        }
        catch (Exception e) {
        }
        catch (Error error) {
            // empty catch block
        }
    }

    private static URL[] getResources(String startPackage) throws MalformedURLException {
        JarURLConnection con;
        URL url;
        String cp = System.getProperty("java.class.path");
        String ext = System.getProperty("java.ext.dirs");
        String sun = System.getProperty("sun.boot.class.path");
        LinkedList<URL> list = new LinkedList<URL>();
        String startStart = startPackage;
        if (startStart.startsWith("/")) {
            startStart = startStart.substring(1);
        }
        if (sun != null) {
            cp = cp + System.getProperty("path.separator") + sun;
        }
        if (ext != null) {
            String[] extDirs;
            for (String dir : extDirs = ext.split(System.getProperty("path.separator"))) {
                File[] jars;
                File temp = new File(dir);
                if (!temp.isDirectory()) continue;
                for (File jar : jars = temp.listFiles(new RegExFilenameFilter("", false, true, ".*(\\.jar|\\.zip)"))) {
                    url = new URL("jar:file:" + jar.getAbsolutePath() + "!" + startPackage);
                    try {
                        con = (JarURLConnection)url.openConnection();
                        con.getJarFile();
                        list.add(url);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
        }
        String[] cps = cp.split(System.getProperty("path.separator"));
        block8: for (int i = 0; i < cps.length; ++i) {
            cps[i] = cps[i].trim();
            File curr = new File(cps[i]);
            if (curr.exists() && curr.isDirectory() && new File(cps[i] + System.getProperty("file.separator") + startPackage).exists()) {
                list.add(new URL("file:" + cps[i] + startPackage));
                continue;
            }
            if (!cps[i].endsWith(".jar") && !cps[i].endsWith(".zip")) continue;
            url = new URL("jar:file:" + cps[i] + "!" + startPackage);
            try {
                con = (JarURLConnection)url.openConnection();
                con.getJarFile();
                list.add(url);
                continue;
            }
            catch (IOException e) {
                try {
                    url = new URL("jar:file:" + cps[i] + "!/");
                    con = (JarURLConnection)url.openConnection();
                    JarFile fj = con.getJarFile();
                    Enumeration<JarEntry> en = fj.entries();
                    while (en.hasMoreElements()) {
                        if (!en.nextElement().getName().startsWith(startStart)) continue;
                        list.add(url);
                        continue block8;
                    }
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return list.toArray(new URL[0]);
    }

    public static <T> CollectionParameter getCollection(Class<T> clazz, String startPackage, String name, String comment, boolean required) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        return new CollectionParameter(SubclassFinder.getInstanceParameterSets(clazz, startPackage).toArray(new InstanceParameterSet[0]), name, comment, required);
    }

    public static <T> LinkedList<InstanceParameterSet> getInstanceParameterSets(Class<T> clazz, String startPackage) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException {
        LinkedList<Class<? extends T>> classes = SubclassFinder.findInstantiableSubclasses(clazz, startPackage);
        LinkedList<Class<InstantiableFromParameterSet>> filteredClasses = SubclassFinder.filterBySuperclass(InstantiableFromParameterSet.class, classes);
        LinkedList<InstanceParameterSet> sets = new LinkedList<InstanceParameterSet>();
        Iterator it = filteredClasses.iterator();
        while (it.hasNext()) {
            Iterator psIt = SubclassFinder.getParameterSetFor((Class)it.next()).iterator();
            while (psIt.hasNext()) {
                sets.add((InstanceParameterSet)((Class)psIt.next()).newInstance());
            }
        }
        return sets;
    }
}

