/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.alphabets;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.data.Alphabet;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;

public class ContinuousAlphabet
extends Alphabet {
    private static final String XML_TAG = "ContinuousAlphabet";
    private double min;
    private double max;
    private ContinuousAlphabetParameterSet parameters;

    public ContinuousAlphabet(ContinuousAlphabetParameterSet parameters) {
        this((Double)parameters.getParameterAt(0).getValue(), (Double)parameters.getParameterAt(1).getValue());
        try {
            this.parameters = (ContinuousAlphabetParameterSet)parameters.clone();
        }
        catch (Exception e) {
            this.parameters = null;
        }
    }

    public ContinuousAlphabet(double min, double max) throws IllegalArgumentException {
        if (Double.isInfinite(min) || Double.isNaN(min) || Double.isNaN(max) || Double.isInfinite(max)) {
            throw new IllegalArgumentException("min and max have to be numbers (not infinity, NaN, ...)");
        }
        if (min >= max) {
            throw new IllegalArgumentException("constraint violated: min < max");
        }
        this.min = min;
        this.max = max;
    }

    public ContinuousAlphabet() {
        this(-1.7976931348623157E308, Double.MAX_VALUE);
    }

    public ContinuousAlphabet(StringBuffer xml) throws NonParsableException {
        StringBuffer help = XMLParser.extractForTag(xml, XML_TAG);
        this.min = XMLParser.extractObjectForTags(help, "MIN", Double.TYPE);
        this.max = XMLParser.extractObjectForTags(help, "MAX", Double.TYPE);
    }

    @Override
    public ContinuousAlphabetParameterSet getCurrentParameterSet() throws Exception {
        if (this.parameters != null) {
            return (ContinuousAlphabetParameterSet)this.parameters.clone();
        }
        return new ContinuousAlphabetParameterSet(this.min, this.max);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(100);
        xml.append("\t");
        XMLParser.appendObjectWithTags(xml, this.min, "MIN");
        xml.append("\t");
        XMLParser.appendObjectWithTags(xml, this.max, "MAX");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    @Override
    public int compareTo(Alphabet a) {
        if (!this.getClass().equals(a.getClass())) {
            return this.getClass().getName().compareTo(a.getClass().getName());
        }
        ContinuousAlphabet b = (ContinuousAlphabet)a;
        int s = (int)Math.signum(this.min - b.min);
        if (s == 0) {
            return (int)Math.signum(this.max - b.max);
        }
        return s;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public final boolean isEncodedSymbol(double candidat) {
        return this.min <= candidat && candidat <= this.max;
    }

    @Override
    public double length() {
        return this.max - this.min;
    }

    @Override
    public String toString() {
        return "[" + this.min + ", " + this.max + "]";
    }

    public static class ContinuousAlphabetParameterSet
    extends Alphabet.AlphabetParameterSet {
        public ContinuousAlphabetParameterSet() {
            super(ContinuousAlphabet.class);
        }

        public ContinuousAlphabetParameterSet(double min, double max) throws Exception {
            this();
            this.loadParameters();
            ((Parameter)this.parameters.get(0)).setValue(new Double(min));
            ((Parameter)this.parameters.get(1)).setValue(new Double(max));
        }

        public ContinuousAlphabetParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        @Override
        protected void loadParameters() throws Exception {
            this.initParameterList();
            this.parameters.add(new SimpleParameter(DataType.DOUBLE, "Minimum", "The minimal value of the alphabet.", true));
            this.parameters.add(new SimpleParameter(DataType.DOUBLE, "Maximum", "The maximum value of the alphabet", true));
        }

        @Override
        public String getInstanceComment() {
            return "An alphabet that consists of real values between a minimum and a maximum value.";
        }
    }
}

