/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization.termination;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.algorithms.optimization.termination.AbstractTerminationCondition;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.utils.Time;

public class SmallDifferenceOfFunctionEvaluationsCondition
extends AbstractTerminationCondition {
    private double eps;

    public SmallDifferenceOfFunctionEvaluationsCondition(double epsilon) throws Exception {
        this(new SmallDifferenceOfFunctionEvaluationsConditionParameterSet(epsilon));
    }

    public SmallDifferenceOfFunctionEvaluationsCondition(SmallDifferenceOfFunctionEvaluationsConditionParameterSet parameter) throws CloneNotSupportedException {
        super(parameter);
    }

    @Override
    protected void set() {
        this.eps = (Double)this.parameter.getParameterAt(0).getValue();
    }

    @Override
    protected String getXmlTag() {
        return "SmallDifferenceOfFunctionEvaluationsCondition";
    }

    public SmallDifferenceOfFunctionEvaluationsCondition(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public boolean doNextIteration(int iteration, double f_last, double f_current, double[] gradient, double[] direction, double alpha, Time t) {
        return this.eps <= Math.abs(f_last - f_current);
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    public static class SmallDifferenceOfFunctionEvaluationsConditionParameterSet
    extends AbstractTerminationCondition.AbstractTerminationConditionParameterSet {
        public SmallDifferenceOfFunctionEvaluationsConditionParameterSet() {
            super(SmallDifferenceOfFunctionEvaluationsCondition.class);
        }

        public SmallDifferenceOfFunctionEvaluationsConditionParameterSet(StringBuffer xml) throws NonParsableException {
            super(xml);
        }

        public SmallDifferenceOfFunctionEvaluationsConditionParameterSet(double eps) throws IllegalArgumentException, SimpleParameter.IllegalValueException {
            this();
            this.getParameterAt(0).setValue(eps);
        }

        @Override
        public String getInstanceComment() {
            return "a set of parameters for the SmallDifferenceOfFunctionEvaluationsCondition";
        }

        @Override
        public String getInstanceName() {
            return "SmallDifferenceOfFunctionEvaluationsConditionParameterSet";
        }

        @Override
        protected void loadParameters() throws Exception {
            this.initParameterList();
            this.parameters.add(new SimpleParameter(DataType.DOUBLE, "epsilon", "the epsilon for the difference of function evaluations used for deciding whether to stop the algorithm or not", true, new NumberValidator<Double>(new Double(0.0), new Double(Double.MAX_VALUE))));
        }
    }
}

