/*
 * This file is part of Jstacs.
 * 
 * Jstacs is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * Jstacs is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * Jstacs. If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

package de.jstacs.data.sequences;

import de.jstacs.WrongAlphabetException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;

/**
 * This is the super class of discrete sequences.
 * 
 * @author Jens Keilwagen
 */
public abstract class DiscreteSequence extends Sequence<int[]> {
	
	/**
	 * This constructor creates a new {@link DiscreteSequence} with the
	 * {@link AlphabetContainer} <code>container</code> and the annotation
	 * <code>annotation</code> but without the content. The content has to be
	 * set by the constructor of the subclass.
	 * 
	 * @param container
	 *            the {@link AlphabetContainer} of the sequence
	 * @param annotation
	 *            the annotation of the sequence
	 * 
	 * @see Sequence#Sequence(AlphabetContainer, SequenceAnnotation[])
	 */
	protected DiscreteSequence( AlphabetContainer container, SequenceAnnotation[] annotation ) {
		super( container, annotation );
	}

	public int compareTo( int[] t1, int[] t2 ) {
		if( t1.length == t2.length ) {
			for( int i = 0; i < t1.length; i++ ) {
				if( t1[i] != t2[i] ) {
					return t1[i]-t2[i];
				}
			}
			return 0;
		} else {
			return t1.length - t2.length;
		}
	}
}