/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization.termination;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.algorithms.optimization.termination.AbstractTerminationCondition;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.utils.Time;

public class AbsoluteValueCondition
extends AbstractTerminationCondition {
    private double threshold;

    public AbsoluteValueCondition(double threshold) throws Exception {
        this(new AbsoluteValueConditionParameterSet(threshold));
    }

    public AbsoluteValueCondition(AbsoluteValueConditionParameterSet parameter) throws CloneNotSupportedException {
        super(parameter);
    }

    @Override
    protected void set() {
        this.threshold = (Double)this.parameter.getParameterAt(0).getValue();
    }

    @Override
    protected String getXmlTag() {
        return "AbsoluteValueCondition";
    }

    public AbsoluteValueCondition(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public boolean doNextIteration(int iteration, double f_last, double f_current, double[] gradient, double[] direction, double alpha, Time t) {
        return this.threshold > f_current;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    public static class AbsoluteValueConditionParameterSet
    extends AbstractTerminationCondition.AbstractTerminationConditionParameterSet {
        public AbsoluteValueConditionParameterSet() {
            super(AbsoluteValueCondition.class);
        }

        public AbsoluteValueConditionParameterSet(StringBuffer xml) throws NonParsableException {
            super(xml);
        }

        public AbsoluteValueConditionParameterSet(double absValue) throws IllegalArgumentException, SimpleParameter.IllegalValueException {
            this();
            this.getParameterAt(0).setValue(absValue);
        }

        @Override
        public String getInstanceComment() {
            return "a set of parameters for the AbsoluteValueCondition";
        }

        @Override
        public String getInstanceName() {
            return "AbsoluteValueConditionParameterSet";
        }

        @Override
        protected void loadParameters() throws Exception {
            this.initParameterList();
            this.parameters.add(new SimpleParameter(DataType.DOUBLE, "absolute value", "if the optimized value is smaller than this value the algorithm is stopped", true, new NumberValidator<Double>(new Double(0.0), new Double(Double.MAX_VALUE))));
        }
    }
}

