/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.functionApproximation.bestFitting;

import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.BasisFunction;
import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.LinearFunctionSpace;
import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.Monomial;

public class LinearFunctionSpaceFactory {
    LinearFunctionSpaceFactory() {
    }

    public static LinearFunctionSpace createSum(LinearFunctionSpace linearFunctionSpace, LinearFunctionSpace linearFunctionSpace2) {
        int n;
        if (linearFunctionSpace.n != linearFunctionSpace2.n) {
            throw new IllegalArgumentException("function space do not match for this operation");
        }
        if (linearFunctionSpace.m != linearFunctionSpace2.m) {
            throw new IllegalArgumentException("function space do not match for this operation");
        }
        int n2 = linearFunctionSpace.m;
        BasisFunction[][] basisFunctionArray = new BasisFunction[linearFunctionSpace.dim + linearFunctionSpace2.dim][n2];
        for (n = 0; n < linearFunctionSpace.dim; ++n) {
            System.arraycopy(linearFunctionSpace.f[n], 0, basisFunctionArray[n], 0, n2);
        }
        n = 0;
        int n3 = linearFunctionSpace.dim;
        while (n < linearFunctionSpace2.dim) {
            System.arraycopy(linearFunctionSpace2.f[n], 0, basisFunctionArray[n3], 0, n2);
            ++n;
            ++n3;
        }
        return new LinearFunctionSpace(basisFunctionArray);
    }

    public static LinearFunctionSpace createPower(LinearFunctionSpace linearFunctionSpace, int n) {
        int n2 = linearFunctionSpace.m;
        BasisFunction[][] basisFunctionArray = new BasisFunction[linearFunctionSpace.dim][n * n2];
        for (int i = 0; i < linearFunctionSpace.dim; ++i) {
            int n3 = 0;
            int n4 = 0;
            while (n3 < n) {
                System.arraycopy(linearFunctionSpace.f[i], 0, basisFunctionArray[i], n4, n2);
                ++n3;
                n4 += n2;
            }
        }
        return new LinearFunctionSpace(basisFunctionArray);
    }

    public static LinearFunctionSpace createProduct(LinearFunctionSpace linearFunctionSpace, LinearFunctionSpace linearFunctionSpace2) {
        if (linearFunctionSpace.n != linearFunctionSpace2.n) {
            throw new IllegalArgumentException("function space do not match for this operation");
        }
        if (linearFunctionSpace.dim != linearFunctionSpace2.dim) {
            throw new IllegalArgumentException("function space do not match for this operation");
        }
        int n = linearFunctionSpace.n;
        int n2 = linearFunctionSpace.dim;
        BasisFunction[][] basisFunctionArray = new BasisFunction[linearFunctionSpace.dim][linearFunctionSpace.m + linearFunctionSpace2.m];
        for (int i = 0; i < linearFunctionSpace.dim; ++i) {
            System.arraycopy(linearFunctionSpace.f[i], 0, basisFunctionArray[i], 0, linearFunctionSpace.m);
            System.arraycopy(linearFunctionSpace.f[i], 0, basisFunctionArray[i], linearFunctionSpace.m, linearFunctionSpace2.m);
        }
        return new LinearFunctionSpace(basisFunctionArray);
    }

    public static LinearFunctionSpace createPartialDerivative(LinearFunctionSpace linearFunctionSpace, int n) {
        if (n >= linearFunctionSpace.n) {
            throw new IllegalArgumentException("wrong dimension");
        }
        BasisFunction[][] basisFunctionArray = new BasisFunction[linearFunctionSpace.dim][linearFunctionSpace.m];
        for (int i = 0; i < linearFunctionSpace.f.length; ++i) {
            for (int j = 0; j < linearFunctionSpace.f[i].length; ++j) {
                basisFunctionArray[i][j] = linearFunctionSpace.f[i][j].getPartialDerivative(n);
            }
        }
        return new LinearFunctionSpace(basisFunctionArray);
    }

    public static LinearFunctionSpace createConstant(int n, int n2) {
        BasisFunction[][] basisFunctionArray = new Monomial[1][1];
        basisFunctionArray[0][0] = new Monomial.Constant(n);
        return LinearFunctionSpaceFactory.createPower(new LinearFunctionSpace(basisFunctionArray), n2);
    }

    public static LinearFunctionSpace createLinear(int n, int n2) {
        BasisFunction[][] basisFunctionArray = new Monomial[n][1];
        for (int i = 0; i < n; ++i) {
            basisFunctionArray[i][0] = new Monomial.Linear(i, n);
        }
        return LinearFunctionSpaceFactory.createPower(new LinearFunctionSpace(basisFunctionArray), n2);
    }

    public static LinearFunctionSpace createAffine(int n, int n2) {
        return LinearFunctionSpaceFactory.createPower(LinearFunctionSpaceFactory.createSum(LinearFunctionSpaceFactory.createConstant(n, 1), LinearFunctionSpaceFactory.createLinear(n, 1)), n2);
    }

    public static LinearFunctionSpace createExactOrder2(int n) {
        BasisFunction[][] basisFunctionArray = new Monomial[n * (n + 1) / 2][1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            while (n3 <= i) {
                basisFunctionArray[n2][0] = new Monomial.Quadratic(n3, i, n);
                ++n3;
                ++n2;
            }
        }
        return new LinearFunctionSpace(basisFunctionArray);
    }

    public static LinearFunctionSpace createQuadratic(int n, int n2) {
        return LinearFunctionSpaceFactory.createPower(LinearFunctionSpaceFactory.createSum(LinearFunctionSpaceFactory.createAffine(n, 1), LinearFunctionSpaceFactory.createExactOrder2(n)), n2);
    }

    public static LinearFunctionSpace createExactOrder3(int n) {
        BasisFunction[][] basisFunctionArray = new Monomial[n * (n + 1) * (2 * n + 4) / 12][1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                int n3 = 0;
                while (n3 <= j) {
                    basisFunctionArray[n2][0] = new Monomial.Cubic(j, i, n3, n);
                    ++n3;
                    ++n2;
                }
            }
        }
        return new LinearFunctionSpace(basisFunctionArray);
    }

    public static LinearFunctionSpace createCubic(int n, int n2) {
        return LinearFunctionSpaceFactory.createPower(LinearFunctionSpaceFactory.createSum(LinearFunctionSpaceFactory.createQuadratic(n, 1), LinearFunctionSpaceFactory.createExactOrder3(n)), n2);
    }
}

