/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.indexdb;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import org.biojava.bio.program.indexdb.BioStore;
import org.biojava.bio.program.indexdb.Record;
import org.biojava.bio.program.indexdb.SearchableFileAsList;
import org.biojava.utils.io.RAF;

class PrimaryIDList
extends SearchableFileAsList {
    private Comparator INDEX_COMPARATOR = new Comparator(){

        public int compare(Object a, Object b) {
            String as = a instanceof Record ? ((Record)a).getID() : (String)a;
            String bs = b instanceof Record ? ((Record)b).getID() : (String)b;
            return BioStore.STRING_CASE_SENSITIVE_ORDER.compare(as, bs);
        }
    };
    private BioStore store;

    public PrimaryIDList(File file, int recordLen, BioStore store) throws IOException {
        super(file, recordLen);
        this.store = store;
    }

    public PrimaryIDList(File file, BioStore store, boolean mutable) throws IOException {
        super(file, mutable);
        this.store = store;
    }

    protected Object parseRecord(byte[] buffer) {
        int lastI = 0;
        int newI = 0;
        while (buffer[newI] != 9) {
            ++newI;
        }
        String id = new String(buffer, lastI, newI - lastI);
        lastI = ++newI;
        while (buffer[newI] != 9) {
            ++newI;
        }
        RAF file = this.store.getFileForID(Integer.parseInt(new String(buffer, lastI, newI - lastI).trim()));
        lastI = ++newI;
        while (buffer[newI] != 9) {
            ++newI;
        }
        long start = Long.parseLong(new String(buffer, lastI, newI - lastI));
        int length = Integer.parseInt(new String(buffer, ++newI, buffer.length - newI).trim());
        return new Record.Impl(id, file, start, length);
    }

    protected void generateRecord(byte[] buffer, Object item) throws IOException {
        String id = null;
        int fileID = -1;
        String start = null;
        String length = null;
        try {
            int j;
            Record indx = (Record)item;
            id = indx.getID();
            if (id == null) {
                throw new NullPointerException("Can't process null ID: " + indx);
            }
            fileID = this.store.getIDForFile(indx.getFile());
            start = String.valueOf(indx.getOffset());
            length = String.valueOf(indx.getLength());
            int i = 0;
            byte[] str = id.getBytes();
            for (j = 0; j < str.length; ++j) {
                buffer[i++] = str[j];
            }
            buffer[i++] = 9;
            str = String.valueOf(fileID).getBytes();
            for (j = 0; j < str.length; ++j) {
                buffer[i++] = str[j];
            }
            buffer[i++] = 9;
            str = start.getBytes();
            for (j = 0; j < str.length; ++j) {
                buffer[i++] = str[j];
            }
            buffer[i++] = 9;
            str = length.getBytes();
            for (j = 0; j < str.length; ++j) {
                buffer[i++] = str[j];
            }
            while (i < buffer.length) {
                buffer[i++] = 32;
            }
        }
        catch (IOException ex) {
            String attemptedLine = id + "\t" + fileID + "\t" + start + "\t" + length;
            throw (IOException)new IOException("Could not build record. Record length: " + buffer.length + " Line length: " + attemptedLine.length() + " " + attemptedLine).initCause(ex);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            String attemptedLine = id + "\t" + fileID + "\t" + start + "\t" + length;
            throw (IOException)new IOException("Could not build record. Record length: " + buffer.length + " Line length: " + attemptedLine.length() + " " + attemptedLine).initCause(ex);
        }
    }

    public Comparator getComparator() {
        return this.INDEX_COMPARATOR;
    }
}

