/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.ParameterValidator;

public class FileParameter
extends Parameter {
    private String name;
    private String comment;
    private boolean required;
    private String mime;
    private FileRepresentation value;
    private FileRepresentation defaultValue;
    private boolean isSet;
    private String errorMessage;
    private ParameterValidator valid;

    @Override
    public FileParameter clone() throws CloneNotSupportedException {
        FileParameter clone = (FileParameter)super.clone();
        clone.value = this.value == null ? null : this.value.clone();
        clone.defaultValue = this.defaultValue == null ? null : this.defaultValue.clone();
        return clone;
    }

    public FileParameter(StringBuffer buf) throws NonParsableException {
        this.fromXML(buf);
    }

    public FileParameter(String name, String comment, String mime, boolean required) {
        this.name = name;
        this.comment = comment;
        this.mime = mime;
        this.required = required;
    }

    public FileParameter(String name, String comment, String mime, boolean required, ParameterValidator validator) {
        this(name, comment, mime, required);
        this.valid = validator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public DataType getDatatype() {
        return DataType.FILE;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void reset() {
        this.value = null;
        this.isSet = false;
        this.errorMessage = null;
    }

    public FileRepresentation getFileContents() {
        return this.value;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean checkValue(Object value) {
        if (this.valid != null) {
            if (this.valid.checkValue(value)) {
                this.errorMessage = null;
                return true;
            }
            this.errorMessage = this.valid.getErrorMessage();
            return false;
        }
        if (value != null && value instanceof FileRepresentation) {
            FileRepresentation f = (FileRepresentation)value;
            if (f.getFilename() != null && f.getFilename().length() != 0 && f.getContent() != null && f.getContent().length() != 0) {
                this.errorMessage = null;
                return true;
            }
            this.errorMessage = "No file specified or file is empty.";
            return false;
        }
        this.errorMessage = "Value is no file or null.";
        return false;
    }

    @Override
    public void setDefault(Object defaultValue) throws SimpleParameter.IllegalValueException {
        if (!this.checkValue(defaultValue)) {
            throw new SimpleParameter.IllegalValueException(this.errorMessage);
        }
        this.defaultValue = (FileRepresentation)defaultValue;
        this.setValue(defaultValue);
    }

    @Override
    public void simplify() {
    }

    @Override
    public void setValue(Object value) throws SimpleParameter.IllegalValueException {
        if (!this.checkValue(value)) {
            throw new SimpleParameter.IllegalValueException(this.errorMessage);
        }
        this.value = (FileRepresentation)value;
        this.isSet = true;
    }

    @Override
    public Object getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.getFilename();
    }

    @Override
    public boolean hasDefaultOrIsSet() {
        return this.isSet();
    }

    @Override
    public boolean isSet() {
        return this.isSet;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superParameter");
        XMLParser.appendStringWithTags(buf, this.name, "name");
        XMLParser.appendStringWithTags(buf, this.comment, "comment");
        XMLParser.appendStringWithTags(buf, this.mime, "mime");
        XMLParser.appendBooleanWithTags(buf, this.required, "required");
        XMLParser.appendBooleanWithTags(buf, this.isSet, "isSet");
        XMLParser.appendStringWithTags(buf, this.errorMessage, "errorMessage");
        if (this.value == null) {
            XMLParser.appendStringWithTags(buf, "null", "value");
        } else {
            XMLParser.appendStringWithTags(buf, this.value.toXML().toString(), "value");
        }
        if (this.valid == null) {
            XMLParser.appendStringWithTags(buf, "null", "validator");
        } else {
            StringBuffer buf2 = new StringBuffer();
            XMLParser.appendStringWithTags(buf2, this.valid.getClass().getName(), "className");
            buf2.append(this.valid.toXML());
            XMLParser.appendStringWithTags(buf, buf2.toString(), "validator");
        }
        XMLParser.addTags(buf, "fileParameter");
        return buf;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        String val;
        StringBuffer buf = XMLParser.extractForTag(representation, "fileParameter");
        super.fromXML(XMLParser.extractForTag(representation, "superParameter"));
        this.name = XMLParser.extractStringForTag(buf, "name");
        this.comment = XMLParser.extractStringForTag(buf, "comment");
        this.mime = XMLParser.extractStringForTag(buf, "mime");
        this.required = XMLParser.extractBooleanForTag(buf, "required");
        this.isSet = XMLParser.extractBooleanForTag(buf, "isSet");
        this.errorMessage = XMLParser.extractStringForTag(buf, "errorMessage");
        if (this.errorMessage != null && this.errorMessage.equals("null")) {
            this.errorMessage = null;
        }
        this.value = (val = XMLParser.extractStringForTag(buf, "value")).equals("null") ? null : new FileRepresentation(new StringBuffer(val));
        val = XMLParser.extractStringForTag(buf, "validator");
        if (val.equals("null")) {
            this.valid = null;
        } else {
            StringBuffer buf2 = new StringBuffer(val);
            String className = XMLParser.extractStringForTag(buf2, "className");
            try {
                this.valid = (ParameterValidator)Class.forName(className).getConstructor(StringBuffer.class).newInstance(buf2);
            }
            catch (Exception e) {
                throw new NonParsableException(e.getMessage());
            }
        }
    }

    public String getAcceptedMimeType() {
        return this.mime;
    }

    public static class FileRepresentation
    implements Storable,
    Cloneable {
        private String filename;
        private String content;

        public FileRepresentation(String filename, String content) {
            this.filename = filename;
            this.content = content;
        }

        public FileRepresentation(StringBuffer buf) throws NonParsableException {
            this.fromXML(buf);
        }

        public FileRepresentation clone() throws CloneNotSupportedException {
            return (FileRepresentation)super.clone();
        }

        public String getFilename() {
            return this.filename;
        }

        public String getContent() {
            return this.content;
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer buf = new StringBuffer();
            XMLParser.appendStringWithTags(buf, this.filename, "filename");
            XMLParser.appendStringWithTags(buf, this.content, "content");
            XMLParser.addTags(buf, "fileRepresentation");
            return buf;
        }

        private void fromXML(StringBuffer representation) throws NonParsableException {
            representation = XMLParser.extractForTag(representation, "fileRepresentation");
            this.filename = XMLParser.extractStringForTag(representation, "filename");
            this.content = XMLParser.extractStringForTag(representation, "content");
        }
    }
}

