/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das.dasstructure;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Calendar;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.bio.program.das.dasstructure.DASStructureXMLResponseParser;
import org.biojava.bio.structure.Structure;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DASStructureCall {
    String serverurl;

    public DASStructureCall() {
        this.serverurl = "";
    }

    public DASStructureCall(String url) {
        this.serverurl = url;
    }

    protected String getTimeStamp() {
        Calendar cal = Calendar.getInstance();
        int hour24 = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        String s = "time: " + hour24 + " " + min + " " + sec;
        return s;
    }

    public void setServerurl(String s) {
        this.serverurl = s;
    }

    public String getServerurl() {
        return this.serverurl;
    }

    public Structure getStructure(String pdb_code) throws IOException {
        String connstr = this.serverurl + pdb_code;
        System.out.println("DASStructureCall: connstr" + connstr);
        URL dasUrl = null;
        try {
            dasUrl = new URL(connstr);
        }
        catch (Exception e) {
            throw new IOException("error during creation of URL " + e.getMessage());
        }
        InputStream inStream = this.connectDASServer(dasUrl);
        Structure structure = null;
        try {
            structure = this.parseDASResponse(inStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("error during parsing of DAS response " + e.getMessage());
        }
        return structure;
    }

    private InputStream connectDASServer(URL url) throws IOException {
        System.out.println(this.getTimeStamp());
        System.out.println("opening connection to DAS Structure server");
        HttpURLConnection huc = null;
        huc = (HttpURLConnection)url.openConnection();
        System.out.println(huc);
        huc.setRequestProperty("Accept-Encoding", "gzip");
        System.out.println("getContentEncoding");
        String contentEncoding = huc.getContentEncoding();
        System.out.println("getInputStream");
        InputStream inStream = huc.getInputStream();
        if (contentEncoding != null && contentEncoding.indexOf("gzip") != -1) {
            inStream = new GZIPInputStream(inStream);
            System.out.println("using gzip encoding!");
        }
        System.out.println(this.getTimeStamp());
        System.out.println("got InputStream from  DAS Structure server");
        System.out.println("encoding: " + contentEncoding);
        System.out.println("code:" + huc.getResponseCode());
        return inStream;
    }

    private Structure parseDASResponse(InputStream inStream) throws IOException, SAXException {
        SAXParserFactory spfactory = SAXParserFactory.newInstance();
        SAXParser saxParser = null;
        try {
            saxParser = spfactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        XMLReader xmlreader = saxParser.getXMLReader();
        DASStructureXMLResponseParser cont_handle = new DASStructureXMLResponseParser();
        xmlreader.setContentHandler(cont_handle);
        xmlreader.setErrorHandler(new DefaultHandler());
        InputSource insource = new InputSource();
        insource.setByteStream(inStream);
        xmlreader.parse(insource);
        return cont_handle.get_structure();
    }
}

