/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.homogeneous;

import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.io.XMLParser;
import de.jstacs.scoringFunctions.homogeneous.HomogeneousScoringFunction;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;

public class UniformHomogeneousScoringFunction
extends HomogeneousScoringFunction {
    private double ess;
    private double p;
    private double logP;

    public UniformHomogeneousScoringFunction(AlphabetContainer alphabets, double ess) {
        super(alphabets);
        if (ess < 0.0) {
            throw new IllegalArgumentException("The given ess has to be non-negative.");
        }
        this.ess = ess;
        this.computeLogP();
    }

    private void computeLogP() {
        this.p = 1.0 / this.alphabets.getAlphabetLengthAt(0);
        this.logP = Math.log(this.p);
    }

    public UniformHomogeneousScoringFunction(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public String getInstanceName() {
        return "uniform";
    }

    @Override
    public double getLogScore(Sequence seq, int start, int length) {
        return (double)length * this.logP;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, int length, IntList indices, DoubleList dList) {
        return (double)length * this.logP;
    }

    @Override
    public int getNumberOfParameters() {
        return 0;
    }

    @Override
    public void setParameters(double[] params, int start) {
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer b = new StringBuffer(1000);
        XMLParser.appendIntWithTags(b, this.length, "length");
        XMLParser.appendStorableWithTags(b, this.alphabets, "alphabets");
        XMLParser.appendDoubleWithTags(b, this.ess, "ess");
        XMLParser.addTags(b, this.getClass().getSimpleName());
        return b;
    }

    @Override
    public double getLogNormalizationConstant(int length) {
        return 0.0;
    }

    @Override
    public void initializeFunction(int index, boolean meila, Sample[] data, double[][] weights) {
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        StringBuffer b = XMLParser.extractForTag(xml, this.getClass().getSimpleName());
        this.length = XMLParser.extractIntForTag(b, "length");
        this.alphabets = (AlphabetContainer)XMLParser.extractStorableForTag(b, "alphabets");
        this.ess = XMLParser.extractDoubleForTag(b, "ess");
        this.computeLogP();
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 0;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex, int length) throws Exception {
        throw new IndexOutOfBoundsException("Since a uniform scoring function has no parameters, this method can not be used");
    }

    @Override
    public double getEss() {
        return this.ess;
    }

    public String toString() {
        return this.p + " for each element of " + this.alphabets.getAlphabetAt(0).toString();
    }

    @Override
    public double getLogPriorTerm() {
        return 0.0;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) {
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        return new double[0];
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public boolean isNormalized() {
        return true;
    }

    @Override
    public int getMaximalMarkovOrder() {
        return 0;
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
    }

    @Override
    public void setStatisticForHyperparameters(int[] length, double[] weights) throws Exception {
    }

    @Override
    public void initializeUniformly(boolean freeParams) {
    }
}

