/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery;

import de.jstacs.data.Sequence;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.results.ImageResult;
import de.jstacs.utils.REnvironment;

public class MotifDiscovererToolBox {
    private static final String PLOT = "plot( 0:(length(profile)-1),profile, \"l\", ylab=\"score\", xlab=\"position\", ylim=lim );\n";
    private static final String ANNOTATE = "abline( h = threshold, lty=2, col=2 );\nfor( i in 1:length(profile)){\nif( profile[i] >= threshold ){ h = paste( i-1, \": \", substr(seq,i,i+w-1), sep=\"\" ); text( i-1, profile[i], h, pos=4, col=4 ); }\n}";

    public static ImageResult plot(MotifDiscoverer motifDisc, int component, int motif, Sequence sequence, int startpos, REnvironment r, int width, int height, MotifDiscoverer.KindOfProfile kind) throws Exception {
        r.createVector("profile", motifDisc.getProfileOfScoresFor(component, motif, sequence, startpos, kind));
        r.voidEval("lim=c(min(profile),max(profile))");
        return new ImageResult("profile", "the profile of scores for " + sequence.toString(startpos), r.plot(PLOT, width, height));
    }

    public static ImageResult plotAndAnnotate(MotifDiscoverer motifDisc, int component, int motif, Sequence sequence, int startpos, REnvironment r, int width, int height, double yMin, double yMax, double threshold, MotifDiscoverer.KindOfProfile kind) throws Exception {
        r.createVector("profile", motifDisc.getProfileOfScoresFor(component, motif, sequence, startpos, kind));
        r.voidEval("lim=c(" + yMin + "," + yMax + ")");
        r.voidEval("threshold = " + threshold);
        String seq = sequence.toString(startpos);
        r.voidEval("seq = \"" + seq + "\"");
        r.voidEval("w = " + motifDisc.getMotifLength(motifDisc.getGlobalIndexOfMotifInComponent(component, motif)));
        return new ImageResult("annotated profile with threshold " + threshold, "the annotated profile of scores for " + seq, r.plot("plot( 0:(length(profile)-1),profile, \"l\", ylab=\"score\", xlab=\"position\", ylim=lim );\nabline( h = threshold, lty=2, col=2 );\nfor( i in 1:length(profile)){\nif( profile[i] >= threshold ){ h = paste( i-1, \": \", substr(seq,i,i+w-1), sep=\"\" ); text( i-1, profile[i], h, pos=4, col=4 ); }\n}", width, height));
    }
}

