/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization.termination;

import de.jstacs.algorithms.optimization.termination.TerminationCondition;
import de.jstacs.utils.Time;

public class SmallDifferenceOfFunctionEvaluationsCondition
implements TerminationCondition {
    private double eps;

    public SmallDifferenceOfFunctionEvaluationsCondition(double epsilon) {
        if (epsilon <= 0.0) {
            throw new IllegalArgumentException("The epsilon has to be non negative.");
        }
        this.eps = epsilon;
    }

    @Override
    public boolean doNextIteration(int iteration, double f_last, double f_current, double[] gradient, double[] direction, double alpha, Time t) {
        return this.eps <= f_last - f_current;
    }
}

