/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.RangeParameter;
import de.jstacs.parameters.Rangeable;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.parameters.validation.ParameterValidator;

public class SimpleParameter
extends Parameter
implements Rangeable {
    protected DataType datatype;
    protected String name;
    protected String comment;
    protected boolean required;
    protected Object value;
    protected Object defaultValue;
    protected ParameterValidator validator;
    private boolean isSet;
    private String errorMessage;
    private boolean isRangeable;

    public SimpleParameter(StringBuffer representation) throws NonParsableException {
        this.fromXML(representation);
    }

    public SimpleParameter(DataType datatype, String name, String comment, boolean required) throws DatatypeNotValidException {
        if (datatype != DataType.BOOLEAN && datatype != DataType.BYTE && datatype != DataType.CHAR && datatype != DataType.DOUBLE && datatype != DataType.FLOAT && datatype != DataType.INT && datatype != DataType.LONG && datatype != DataType.SHORT && datatype != DataType.STRING) {
            throw new DatatypeNotValidException("Only primitive datatypes and Strings are allowed as datatypes of a SimpleParameter!");
        }
        this.datatype = datatype;
        this.name = name;
        this.comment = comment;
        this.required = required;
        this.validator = null;
        this.isSet = false;
        this.isRangeable = datatype != DataType.STRING && datatype != DataType.CHAR;
    }

    public SimpleParameter(DataType datatype, String name, String comment, boolean required, Object defaultVal) throws ParameterException {
        this(datatype, name, comment, required);
        if (!this.checkValue(defaultVal)) {
            throw new IllegalValueException("Value not valid");
        }
        this.setDefault(defaultVal);
    }

    public SimpleParameter(DataType datatype, String name, String comment, boolean required, ParameterValidator validator) throws DatatypeNotValidException {
        this(datatype, name, comment, required);
        this.validator = validator;
    }

    public SimpleParameter(DataType datatype, String name, String comment, boolean required, ParameterValidator validator, Object defaultVal) throws ParameterException {
        this(datatype, name, comment, required, validator);
        if (!this.checkValue(defaultVal)) {
            throw new IllegalValueException("Value not valid");
        }
        this.setDefault(defaultVal);
    }

    @Override
    public SimpleParameter clone() throws CloneNotSupportedException {
        SimpleParameter clone = (SimpleParameter)super.clone();
        if (this.validator != null) {
            clone.validator = this.validator.clone();
        }
        return clone;
    }

    @Override
    public boolean hasDefaultOrIsSet() {
        if (this.isSet) {
            return true;
        }
        return this.getValue() != null;
    }

    @Override
    public boolean isSet() {
        return this.isSet;
    }

    @Override
    public boolean isRangeable() {
        return this.isRangeable;
    }

    public void setRangeable(boolean rangeable) {
        this.isRangeable = rangeable;
    }

    @Override
    public Parameter getRangedInstance() throws Exception {
        if (this.isRangeable()) {
            return new RangeParameter(this);
        }
        throw new Exception("Parameter " + this.name + " is not rangeable!");
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataType getDatatype() {
        return this.datatype;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkValue(Object value) {
        Object value2;
        block56: {
            if (this.validator == null) {
                if (this.datatype == DataType.BOOLEAN) {
                    if (value instanceof Boolean || value instanceof String) {
                        this.errorMessage = null;
                        return true;
                    }
                    this.errorMessage = "The specified value is no boolean.";
                } else if (this.datatype == DataType.CHAR) {
                    if (value instanceof Character || value instanceof String && ((String)value).length() == 1) {
                        this.errorMessage = null;
                        return true;
                    }
                    this.errorMessage = "The specified value is no character or null.";
                } else if (this.datatype == DataType.BYTE) {
                    if (value instanceof Byte) {
                        this.errorMessage = null;
                        return true;
                    }
                    if (value instanceof String) {
                        try {
                            Byte.parseByte((String)value);
                            this.errorMessage = null;
                            return true;
                        }
                        catch (NumberFormatException e) {
                            this.errorMessage = "Specified value is not a byte.";
                            return false;
                        }
                    }
                } else if (this.datatype == DataType.SHORT) {
                    if (value instanceof Short) {
                        this.errorMessage = null;
                        return true;
                    }
                    if (value instanceof String) {
                        try {
                            Short.parseShort((String)value);
                            this.errorMessage = null;
                            return true;
                        }
                        catch (NumberFormatException e) {
                            this.errorMessage = "Specified value is not a short.";
                            return false;
                        }
                    }
                } else if (this.datatype == DataType.INT) {
                    if (value instanceof Integer) {
                        this.errorMessage = null;
                        return true;
                    }
                    if (value instanceof String) {
                        try {
                            Integer.parseInt((String)value);
                            this.errorMessage = null;
                            return true;
                        }
                        catch (NumberFormatException e) {
                            this.errorMessage = "Specified value is not an integer.";
                            return false;
                        }
                    }
                } else if (this.datatype == DataType.LONG) {
                    if (value instanceof Long) {
                        this.errorMessage = null;
                        return true;
                    }
                    if (value instanceof String) {
                        try {
                            Long.parseLong((String)value);
                            this.errorMessage = null;
                            return true;
                        }
                        catch (NumberFormatException e) {
                            this.errorMessage = "Specified value is not a long.";
                            return false;
                        }
                    }
                } else if (this.datatype == DataType.FLOAT) {
                    if (value instanceof Float) {
                        this.errorMessage = null;
                        return true;
                    }
                    if (value instanceof String) {
                        try {
                            Float.parseFloat((String)value);
                            this.errorMessage = null;
                            return true;
                        }
                        catch (NumberFormatException e) {
                            this.errorMessage = "Specified value is not a float.";
                            return false;
                        }
                    }
                } else if (this.datatype == DataType.DOUBLE) {
                    if (value instanceof Double) {
                        this.errorMessage = null;
                        return true;
                    }
                    if (value instanceof String) {
                        try {
                            Double.parseDouble((String)value);
                            this.errorMessage = null;
                            return true;
                        }
                        catch (NumberFormatException e) {
                            this.errorMessage = "Specified value is not a double.";
                            return false;
                        }
                    }
                } else if (this.datatype == DataType.STRING && value instanceof String && (!this.required || ((String)value).length() > 0)) {
                    this.errorMessage = null;
                    return true;
                }
                if (value == null || value instanceof String && ((String)value).length() == 0) {
                    this.errorMessage = null;
                    return false;
                }
                this.errorMessage = "Value is not of the expected format or null.";
                return false;
            }
            value2 = value;
            if (value instanceof String) {
                if (((String)value).length() <= 0) {
                    this.errorMessage = "";
                    return false;
                }
                try {
                    if (this.datatype == DataType.BYTE) {
                        value2 = new Byte((String)value);
                        break block56;
                    }
                    if (this.datatype == DataType.SHORT) {
                        value2 = new Short((String)value);
                        break block56;
                    }
                    if (this.datatype == DataType.INT) {
                        value2 = new Integer((String)value);
                        break block56;
                    }
                    if (this.datatype == DataType.LONG) {
                        value2 = new Long((String)value);
                        break block56;
                    }
                    if (this.datatype == DataType.FLOAT) {
                        value2 = new Float((String)value);
                        break block56;
                    }
                    if (this.datatype == DataType.DOUBLE) {
                        value2 = new Double((String)value);
                    }
                }
                catch (NumberFormatException e) {
                    this.errorMessage = "Value is not of the expected format or null.";
                    return false;
                }
            }
        }
        if (this.validator.checkValue(value2)) {
            this.errorMessage = this.validator.getErrorMessage();
            return true;
        }
        this.errorMessage = this.validator.getErrorMessage();
        return false;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void setDefault(Object defaultValue) throws IllegalValueException {
        if (!this.checkValue(defaultValue)) {
            System.out.println("value not valid!");
            throw new IllegalValueException("default value not valid");
        }
        this.defaultValue = defaultValue;
        this.setValue(defaultValue);
    }

    @Override
    public void simplify() {
    }

    @Override
    public void reset() {
        if (this.defaultValue != null) {
            try {
                this.setDefault(this.defaultValue);
            }
            catch (Exception e) {
                this.value = null;
            }
        } else {
            this.value = null;
        }
    }

    @Override
    public void setValue(Object value2) throws IllegalValueException {
        if (this.checkValue(value2)) {
            if (value2 instanceof String && this.datatype != DataType.STRING) {
                String s = (String)value2;
                try {
                    switch (this.datatype) {
                        case BOOLEAN: {
                            this.value = new Boolean(s);
                            break;
                        }
                        case CHAR: {
                            this.value = Character.valueOf(s.toCharArray()[0]);
                            break;
                        }
                        case BYTE: {
                            this.value = new Byte(s);
                            break;
                        }
                        case SHORT: {
                            this.value = new Short(s);
                            break;
                        }
                        case INT: {
                            this.value = new Integer(s);
                            break;
                        }
                        case LONG: {
                            this.value = new Long(s);
                            break;
                        }
                        case FLOAT: {
                            this.value = new Float(s);
                            break;
                        }
                        case DOUBLE: {
                            this.value = new Double(s);
                            break;
                        }
                        default: {
                            this.errorMessage = "Parameter value not of the expected type!";
                            throw new IllegalValueException(this.errorMessage);
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("value not valid2!");
                    this.errorMessage = "Value not valid\n" + e.getMessage();
                    throw new IllegalValueException("Value not valid\n" + e.getMessage());
                }
            } else {
                this.value = value2;
                this.isSet = true;
            }
        } else {
            System.out.println("value not valid!");
            throw new IllegalValueException("value not valid");
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superParameter");
        XMLParser.appendEnumWithTags(buf, this.datatype, "datatype");
        XMLParser.appendStringWithTags(buf, this.name, "name");
        XMLParser.appendStringWithTags(buf, this.comment, "comment");
        XMLParser.appendBooleanWithTags(buf, this.required, "required");
        XMLParser.appendBooleanWithTags(buf, this.isSet, "isSet");
        XMLParser.appendStringWithTags(buf, this.errorMessage, "errorMessage");
        XMLParser.appendBooleanWithTags(buf, this.isRangeable, "isRangeable");
        if (this.validator != null) {
            StringBuffer buf2 = new StringBuffer();
            XMLParser.appendStringWithTags(buf2, this.validator.getClass().getName(), "className");
            buf2.append(this.validator.toXML());
            XMLParser.addTags(buf2, "validator");
            buf.append(buf2);
        } else {
            XMLParser.appendStringWithTags(buf, "null", "validator");
        }
        if (this.value != null) {
            XMLParser.appendStringWithTags(buf, this.value.toString(), "value");
        } else {
            XMLParser.appendStringWithTags(buf, "null", "value");
        }
        XMLParser.addTags(buf, "simpleParameter");
        return buf;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        StringBuffer help;
        representation = XMLParser.extractForTag(representation, "simpleParameter");
        super.fromXML(XMLParser.extractForTag(representation, "superParameter"));
        this.datatype = (DataType)((Object)XMLParser.extractEnumForTag(representation, "datatype"));
        this.name = XMLParser.extractStringForTag(representation, "name");
        this.comment = XMLParser.extractStringForTag(representation, "comment");
        this.required = XMLParser.extractBooleanForTag(representation, "required");
        this.isSet = XMLParser.extractBooleanForTag(representation, "isSet");
        this.errorMessage = XMLParser.extractStringForTag(representation, "errorMessage");
        if (this.errorMessage != null && this.errorMessage.equals("null")) {
            this.errorMessage = null;
        }
        this.isRangeable = (help = XMLParser.extractForTag(representation, "isRangeable")) == null ? false : Boolean.parseBoolean(help.toString());
        String valid = XMLParser.extractStringForTag(representation, "validator");
        if (valid.equals("null")) {
            this.validator = null;
        } else {
            StringBuffer buf = new StringBuffer(valid);
            String className = XMLParser.extractStringForTag(buf, "className");
            try {
                this.validator = (ParameterValidator)Class.forName(className).getConstructor(StringBuffer.class).newInstance(buf);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NonParsableException(e.getMessage());
            }
        }
        String val = XMLParser.extractStringForTag(representation, "value");
        if (val.equals("null")) {
            this.value = null;
        } else {
            try {
                this.setValue(val);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NonParsableException(e.getMessage());
            }
        }
    }

    public boolean equals(Object o2) {
        if (o2 instanceof SimpleParameter) {
            SimpleParameter par2 = (SimpleParameter)o2;
            return par2.comment.equals(this.comment) && par2.name.equals(this.name) && par2.required == this.required && par2.datatype == this.datatype;
        }
        return false;
    }

    public ParameterValidator getValidator() {
        return this.validator;
    }

    public void setValidator(ParameterValidator validator) {
        this.validator = validator;
    }

    public String toString() {
        return this.name + " (" + this.comment + (this.validator != null && this.validator instanceof NumberValidator ? ", " + this.validator.toString() : "") + (this.defaultValue != null ? ", default = " + this.defaultValue.toString() : "") + (this.required ? "" : ", OPTIONAL") + ")\t= " + this.value;
    }

    public static class IllegalValueException
    extends ParameterException {
        private static final long serialVersionUID = 1L;

        public IllegalValueException(String reason) {
            super("Parameter not permitted: " + reason);
        }
    }

    public static class DatatypeNotValidException
    extends ParameterException {
        private static final long serialVersionUID = 1L;

        public DatatypeNotValidException(String reason) {
            super("The datatype is not valid for this type of parameter: " + reason);
        }
    }
}

