/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.AbstractStringExtractor;

public class LimitedStringExtractor
extends AbstractStringExtractor {
    private AbstractStringExtractor se;
    private int num;
    private int current;

    public LimitedStringExtractor(AbstractStringExtractor se, int num) {
        super(se.ignore);
        this.se = se;
        if (num < 0) {
            throw new IllegalArgumentException("The number has to be non-negative.");
        }
        this.num = num;
        this.current = 0;
        this.annotation = "limited sample (max=" + num + ") of " + se.getAnnotation();
    }

    @Override
    public boolean hasMoreElements() {
        return this.current < this.num && this.se.hasMoreElements();
    }

    @Override
    public String nextElement() {
        String res = (String)this.se.nextElement();
        ++this.current;
        return res;
    }

    @Override
    public SequenceAnnotation[] getCurrentSequenceAnnotations() {
        return this.se.getCurrentSequenceAnnotations();
    }
}

