/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization.termination;

import de.jstacs.algorithms.optimization.termination.TerminationCondition;
import de.jstacs.utils.Time;

public class CombinedCondition
implements TerminationCondition {
    private TerminationCondition[] condition;
    private int threshold;

    public CombinedCondition(int threshold, TerminationCondition ... condition) {
        if (threshold > condition.length) {
            throw new IllegalArgumentException("The threshold has to be smaller than the number of conditions");
        }
        this.threshold = threshold;
        this.condition = condition;
    }

    @Override
    public boolean doNextIteration(int iteration, double f_last, double f_current, double[] gradient, double[] direction, double alpha, Time t) {
        int positive = 0;
        for (int i = 0; i < this.condition.length; ++i) {
            if (!this.condition[i].doNextIteration(iteration, f_last, f_current, gradient, direction, alpha, t)) continue;
            ++positive;
        }
        return positive >= this.threshold;
    }
}

