/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;

public class ExpandableParameterSet
extends ParameterSet {
    protected ParameterSet template;
    protected String nameTemplate;
    protected String commentTemplate;
    private int count;
    private int initCount;

    public ExpandableParameterSet(ParameterSet template, String nameTemplate, String commentTemplate) {
        this.template = template;
        this.nameTemplate = nameTemplate;
        this.commentTemplate = commentTemplate;
        this.count = 0;
        this.initCount = 1;
    }

    public ExpandableParameterSet(ParameterSet template, String nameTemplate, String commentTemplate, int initCount) {
        this.template = template;
        this.nameTemplate = nameTemplate;
        this.commentTemplate = commentTemplate;
        this.count = 0;
        this.initCount = initCount;
    }

    public ExpandableParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public ExpandableParameterSet(ParameterSet[] templateAndContent, String nameTemplate, String commentTemplate) {
        if (templateAndContent.length == 0) {
            throw new IllegalArgumentException("You must provide at least one ParameterSet.");
        }
        this.template = templateAndContent[0];
        this.nameTemplate = nameTemplate;
        this.commentTemplate = commentTemplate;
        if (this.notAllGivenParameterSetsAreOfTemplateType(templateAndContent)) {
            throw new IllegalArgumentException("At least one of the given ParameterSets is not of the specified template-Type");
        }
        this.initParameterList(templateAndContent.length);
        for (int i = 0; i < templateAndContent.length; ++i) {
            this.parameters.add(new ParameterSetContainer(nameTemplate + " no. " + (i + 1), commentTemplate, templateAndContent[i]));
        }
        this.initCount = this.count = templateAndContent.length;
    }

    @Override
    public ExpandableParameterSet clone() throws CloneNotSupportedException {
        ExpandableParameterSet clone = (ExpandableParameterSet)super.clone();
        clone.template = this.template.clone();
        return clone;
    }

    @Override
    protected void loadParameters() throws Exception {
        if (this.parameters == null) {
            this.initParameterList();
            for (int i = 0; i < this.initCount; ++i) {
                this.addParameterToSet();
            }
        }
    }

    @Override
    protected void replaceParametersWithRangedInstance() throws Exception {
        this.template.makeRanged();
        super.replaceParametersWithRangedInstance();
    }

    public void addParameterToSet() throws CloneNotSupportedException {
        if (this.parameters == null) {
            try {
                this.loadParameters();
                if (this.ranged) {
                    this.replaceParametersWithRangedInstance();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ParameterSetContainer simplePar = new ParameterSetContainer(this.nameTemplate + " no. " + ++this.count, this.commentTemplate, this.template.clone());
        this.parameters.add(simplePar);
    }

    public boolean replaceContentWith(ParameterSet[] paramSetArray) {
        if (this.notAllGivenParameterSetsAreOfTemplateType(paramSetArray)) {
            return false;
        }
        this.initParameterList(paramSetArray.length);
        for (int i = 0; i < paramSetArray.length; ++i) {
            this.parameters.add(new ParameterSetContainer(this.nameTemplate + " no. " + (i + 1), this.commentTemplate, paramSetArray[i]));
        }
        this.count = paramSetArray.length;
        return true;
    }

    private boolean notAllGivenParameterSetsAreOfTemplateType(ParameterSet[] temp) {
        Class<?> clazz = this.template.getClass();
        for (int i = 0; i < temp.length; ++i) {
            if (temp[i].getClass() == clazz) continue;
            return true;
        }
        return false;
    }

    public boolean parameterRemovable() {
        return this.count > 0;
    }

    public void removeParameterFromSet() {
        if (this.parameters == null) {
            try {
                this.loadParameters();
                if (this.ranged) {
                    this.replaceParametersWithRangedInstance();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.count > 0) {
            this.parameters.remove(this.parameters.size() - 1);
            --this.count;
        }
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superParameters");
        XMLParser.appendStorableWithTags(buf, this.template, "template");
        XMLParser.appendStringWithTags(buf, this.nameTemplate, "nameTemplate");
        XMLParser.appendStringWithTags(buf, this.commentTemplate, "commentTemplate");
        XMLParser.appendIntWithTags(buf, this.initCount, "initCount");
        XMLParser.addTags(buf, "expandableParameterSet");
        return buf;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "expandableParameterSet");
        super.fromXML(XMLParser.extractForTag(representation, "superParameters"));
        this.template = (ParameterSet)XMLParser.extractStorableForTag(representation, "template");
        this.nameTemplate = XMLParser.extractStringForTag(representation, "nameTemplate");
        this.commentTemplate = XMLParser.extractStringForTag(representation, "commentTemplate");
        this.initCount = XMLParser.extractIntForTag(representation, "initCount");
    }
}

