/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.CollectionParameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;

public class EnumParameter
extends CollectionParameter {
    private Class<? extends Enum> enumInstance;
    private Enum[] enumConstants;

    private static String[] getKeys(Class<? extends Enum> e) {
        Enum[] all = e.getEnumConstants();
        String[] keys = new String[all.length];
        for (int i = 0; i < all.length; ++i) {
            keys[i] = all[i].name();
        }
        return keys;
    }

    public EnumParameter(Class<? extends Enum> enumInstance, String comment, boolean required) throws ParameterException {
        super(DataType.STRING, EnumParameter.getKeys(enumInstance), (Object[])EnumParameter.getKeys(enumInstance), enumInstance.getSimpleName(), comment, required);
        this.enumInstance = enumInstance;
        this.enumConstants = enumInstance.getEnumConstants();
    }

    public EnumParameter(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    protected void appendCollection(StringBuffer buf) {
        XMLParser.appendStringWithTags(buf, super.getValue().toString(), "selectedEnum");
        if (this.hasDefault()) {
            XMLParser.appendStringWithTags(buf, this.parameters.getParameterAt(this.getDefault()).getValue().toString(), "defaultSelectedEnum");
        }
        XMLParser.appendStringWithTags(buf, this.enumInstance.getName(), "enumName");
    }

    @Override
    protected void extractCollection(StringBuffer buf) throws NonParsableException {
        try {
            this.enumInstance = Class.forName(XMLParser.extractStringForTag(buf, "enumName"));
            this.enumConstants = this.enumInstance.getEnumConstants();
            this.createParameterSet(EnumParameter.getKeys(this.enumInstance), EnumParameter.getKeys(this.enumInstance), null);
            if (this.hasDefault()) {
                this.setDefault(XMLParser.extractStringForTag(buf, "defaultSelectedEnum"));
            }
            this.setValue(XMLParser.extractStringForTag(buf, "selectedEnum"));
        }
        catch (Exception e) {
            throw new NonParsableException(e.getMessage());
        }
    }

    @Override
    public Enum getValue() {
        int idx = 0;
        Object v = super.getValue();
        while (!this.enumConstants[idx].name().equals(v)) {
            ++idx;
        }
        return this.enumConstants[idx];
    }

    @Override
    public void setValue(Object value) throws SimpleParameter.IllegalValueException {
        if (value != null && value instanceof Enum) {
            if (!this.enumInstance.isInstance(value)) {
                throw new SimpleParameter.IllegalValueException("Wrong Enum type.");
            }
            value = ((Enum)value).name();
        }
        super.setValue(value);
    }

    @Override
    public void setDefault(Object defaultValue) throws SimpleParameter.IllegalValueException {
        if (defaultValue != null && defaultValue instanceof Enum) {
            if (!this.enumInstance.isInstance(defaultValue)) {
                throw new SimpleParameter.IllegalValueException("Wrong Enum type.");
            }
            defaultValue = ((Enum)defaultValue).name();
        }
        super.setDefault(defaultValue);
    }
}

