/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.WrongAlphabetException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.EmptySampleException;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.alphabets.ComplementableDiscreteAlphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.DiscreteSequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.AbstractStringExtractor;
import de.jstacs.io.SymbolExtractor;
import java.util.LinkedList;
import javax.naming.OperationNotSupportedException;

public final class SparseSequence
extends DiscreteSequence {
    private static final int MAX_NUMBER_OF_SYMBOLS_IN_ONE_LONG = 32;
    private static final int LOG_MAX_NUMBER = 5;
    private static final int MAX_NUMBER_MINUS_ONE = 31;
    private int length;
    private long[] content;

    public SparseSequence(AlphabetContainer alphCon, String seq) throws WrongSequenceTypeException, WrongAlphabetException {
        this(alphCon, new SymbolExtractor(seq, alphCon.getDelim()));
    }

    public SparseSequence(AlphabetContainer alphCon, SymbolExtractor se) throws WrongSequenceTypeException, WrongAlphabetException {
        this(alphCon, se.countElements(), null);
        if (!alphCon.isSimple() || alphCon.getAlphabetLengthAt(0) != 4.0) {
            throw new WrongSequenceTypeException();
        }
        DiscreteAlphabet abc = (DiscreteAlphabet)alphCon.getAlphabetAt(0);
        int index = 0;
        int l = 0;
        while (l < this.length) {
            this.content[index] = 0L;
            for (int j = 0; j < 32 && l < this.length; ++j, ++l) {
                int n = index;
                this.content[n] = this.content[n] + ((long)abc.getCode(se.nextElement()) << 2 * j);
            }
            ++index;
        }
    }

    private SparseSequence(AlphabetContainer con, int length, SequenceAnnotation[] annotation) throws WrongAlphabetException {
        super(con, annotation);
        this.length = length;
        this.content = new long[length / 32 + (length % 32 > 0 ? 1 : 0)];
    }

    @Override
    public int discreteVal(int pos) {
        if (pos < 0 || pos >= this.length) {
            throw new IndexOutOfBoundsException("The index " + pos + " is out of bounds [0," + this.length + "]");
        }
        return (int)(this.content[pos >> 5] >> ((pos & 0x1F) << 1) & 3L);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public SparseSequence complement(int start, int end) throws OperationNotSupportedException {
        if (this.alphabetCon.isReverseComplementable()) {
            SparseSequence erg;
            try {
                erg = new SparseSequence(this.alphabetCon, end - start, null);
            }
            catch (WrongAlphabetException e) {
                throw new RuntimeException(e.getMessage());
            }
            ComplementableDiscreteAlphabet compAbc = (ComplementableDiscreteAlphabet)this.alphabetCon.getAlphabetAt(0);
            int l = start;
            int index = 0;
            while (l < end) {
                erg.content[index] = 0L;
                for (int j = 0; j < 32 && l < end; ++j, ++l) {
                    int n = index;
                    erg.content[n] = erg.content[n] + ((long)compAbc.getComplementaryCode(this.discreteVal(l)) << 2 * j);
                }
                ++index;
            }
            return erg;
        }
        throw new OperationNotSupportedException("The alphabet of sequence has to be complementable.");
    }

    @Override
    public SparseSequence reverse(int start, int end) throws OperationNotSupportedException {
        SparseSequence erg;
        try {
            erg = new SparseSequence(this.alphabetCon, end - start, null);
        }
        catch (WrongAlphabetException e) {
            throw new RuntimeException(e.getMessage());
        }
        int l = end - 1;
        int index = 0;
        while (l >= start) {
            erg.content[index] = 0L;
            for (int j = 0; j < 32 && l >= start; ++j, --l) {
                int n = index;
                erg.content[n] = erg.content[n] + ((long)this.discreteVal(l) << 2 * j);
            }
            ++index;
        }
        return erg;
    }

    @Override
    public SparseSequence reverseComplement(int start, int end) throws OperationNotSupportedException {
        if (this.rc != null && start == 0 && end == this.getLength()) {
            return (SparseSequence)this.rc;
        }
        if (this.alphabetCon.isReverseComplementable()) {
            SparseSequence erg;
            try {
                erg = new SparseSequence(this.alphabetCon, end - start, null);
            }
            catch (WrongAlphabetException e) {
                throw new RuntimeException(e.getMessage());
            }
            ComplementableDiscreteAlphabet compAbc = (ComplementableDiscreteAlphabet)this.alphabetCon.getAlphabetAt(0);
            int l = end - 1;
            int index = 0;
            while (l >= start) {
                erg.content[index] = 0L;
                for (int j = 0; j < 32 && l >= start; ++j, --l) {
                    int n = index;
                    erg.content[n] = erg.content[n] + ((long)compAbc.getComplementaryCode(this.discreteVal(l)) << 2 * j);
                }
                ++index;
            }
            if (start == 0 && end == this.getLength()) {
                this.rc = erg;
                erg.rc = this;
            }
            return erg;
        }
        throw new OperationNotSupportedException("The alphabet of sequence has to be complementable.");
    }

    @Override
    protected Sequence flatCloneWithoutAnnotation() {
        try {
            SparseSequence erg = new SparseSequence(this.alphabetCon, this.length, null);
            erg.content = this.content;
            return erg;
        }
        catch (Exception doesnothappen) {
            throw new RuntimeException(doesnothappen);
        }
    }

    public static final Sample getSample(AlphabetContainer con, AbstractStringExtractor se) throws WrongSequenceTypeException, WrongAlphabetException, EmptySampleException {
        String s;
        LinkedList<SparseSequence> list = new LinkedList<SparseSequence>();
        SymbolExtractor symEx = new SymbolExtractor(con.getDelim());
        while (se.hasMoreElements()) {
            s = (String)se.nextElement();
            symEx.setStringToBeParsed(s);
            list.add(new SparseSequence(con, symEx));
        }
        s = se.getAnnotation();
        return new Sample(s, list.toArray(new Sequence[0]));
    }
}

