/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.homogeneous;

import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.io.XMLParser;
import de.jstacs.scoringFunctions.homogeneous.HomogeneousScoringFunction;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.util.Arrays;

public class UniformHomogeneousScoringFunction
extends HomogeneousScoringFunction {
    private double ess;
    private double p;
    private double logP;

    public UniformHomogeneousScoringFunction(AlphabetContainer alphabets, double ess) {
        super(alphabets);
        if (ess < 0.0) {
            throw new IllegalArgumentException("The given ess has to be non-negative.");
        }
        this.ess = ess;
        this.computeLogP();
    }

    private void computeLogP() {
        this.p = 1.0 / this.alphabets.getAlphabetLengthAt(0);
        this.logP = Math.log(this.p);
    }

    public UniformHomogeneousScoringFunction(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    public String getInstanceName() {
        return "uniform";
    }

    public double getLogScore(Sequence seq, int start, int length) {
        return (double)length * this.logP;
    }

    public double getLogScoreAndPartialDerivation(Sequence seq, int start, int length, IntList indices, DoubleList dList) {
        return (double)length * this.logP;
    }

    public int getNumberOfParameters() {
        return 0;
    }

    public void setParameters(double[] params, int start) {
    }

    public StringBuffer toXML() {
        StringBuffer b = new StringBuffer(1000);
        XMLParser.appendIntWithTags(b, this.length, "length");
        XMLParser.appendStorableWithTags(b, this.alphabets, "alphabets");
        XMLParser.appendDoubleWithTags(b, this.ess, "ess");
        XMLParser.addTags(b, this.getClass().getSimpleName());
        return b;
    }

    public double getNormalizationConstant(int length) {
        return 1.0;
    }

    public void initializeFunction(int index, boolean meila, Sample[] data, double[][] weights) {
    }

    protected void fromXML(StringBuffer xml) throws NonParsableException {
        StringBuffer b = XMLParser.extractForTag(xml, this.getClass().getSimpleName());
        this.length = XMLParser.extractIntForTag(b, "length");
        this.alphabets = (AlphabetContainer)XMLParser.extractStorableForTag(b, "alphabets");
        this.ess = XMLParser.extractDoubleForTag(b, "ess");
        this.computeLogP();
    }

    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 0;
    }

    public double getPartialNormalizationConstant(int parameterIndex, int length) throws Exception {
        throw new IndexOutOfBoundsException("Since a uniform scoring function has no parameters, this method can not be used");
    }

    public double getEss() {
        return this.ess;
    }

    public String toString() {
        return this.p + " for each element of " + this.alphabets.getAlphabetAt(0).toString();
    }

    public double getLogPriorTerm() {
        return 0.0;
    }

    public void addGradientOfLogPriorTerm(double[] grad, int start) {
    }

    public double[] getCurrentParameterValues() throws Exception {
        return new double[0];
    }

    public boolean isInitialized() {
        return true;
    }

    public boolean isNormalized() {
        return true;
    }

    public int getMaximalMarkovOrder() {
        return 0;
    }

    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
    }

    public double[][][] getAllConditionalStationaryDistributions() {
        double[][][] res = new double[1][1][(int)this.alphabets.getAlphabetLengthAt(0)];
        Arrays.fill(res[0][0], this.p);
        return res;
    }

    public void setStatisticForHyperparameters(int[] length, double[] weights) throws Exception {
    }

    public void initializeUniformly(boolean freeParams) {
    }
}

