/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data;

import de.jstacs.WrongAlphabetException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.ComplementableDiscreteAlphabet;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.data.sequences.ByteSequence;
import de.jstacs.data.sequences.DiscreteSequence;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.RecursiveSequence;
import de.jstacs.data.sequences.ShortSequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import javax.naming.OperationNotSupportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Sequence
implements Comparable<Sequence> {
    protected AlphabetContainer alphabetCon;
    protected Sequence rc;
    protected SequenceAnnotation[] annotation;

    protected Sequence(AlphabetContainer container, SequenceAnnotation[] annotation) {
        if (container == null) {
            throw new NullPointerException();
        }
        this.alphabetCon = container;
        if (annotation != null) {
            this.annotation = (SequenceAnnotation[])annotation.clone();
        }
    }

    public abstract double continuousVal(int var1);

    public abstract int discreteVal(int var1);

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Sequence)) {
            return false;
        }
        Sequence s = (Sequence)o;
        return this.compareTo(s) == 0 && this.alphabetCon.checkConsistency(s.alphabetCon);
    }

    public final AlphabetContainer getAlphabetContainer() {
        return this.alphabetCon;
    }

    public final SequenceAnnotation[] getAnnotation() {
        if (this.annotation != null) {
            return (SequenceAnnotation[])this.annotation.clone();
        }
        return null;
    }

    public Sequence getCompositeSequence(AlphabetContainer abc, int[] starts, int[] lengths) {
        return new CompositeSequence(abc, this, starts, lengths);
    }

    public Sequence getCompositeSequence(int[] starts, int[] lengths) {
        return new CompositeSequence(this, starts, lengths);
    }

    public final Sequence getSubSequence(AlphabetContainer abc, int start) {
        return this.getSubSequence(abc, start, this.getLength() - start);
    }

    public Sequence getSubSequence(AlphabetContainer abc, int start, int length) {
        if (start == 0 && length == this.getLength()) {
            return this;
        }
        return new SubSequence(abc, this, start, length);
    }

    public final Sequence getSubSequence(int start) {
        return this.getSubSequence(start, this.getLength() - start);
    }

    public Sequence getSubSequence(int start, int length) {
        if (start == 0 && length == this.getLength()) {
            return this;
        }
        return new SubSequence(this, start, length);
    }

    public Sequence annotate(boolean add, SequenceAnnotation ... annotation) {
        Sequence seq = this.flatCloneWithoutAnnotation();
        if (add) {
            int num = 0;
            if (annotation != null) {
                num += annotation.length;
            }
            if (this.annotation != null) {
                num += this.annotation.length;
            }
            SequenceAnnotation[] temp = new SequenceAnnotation[num];
            for (num = 0; annotation != null && num < annotation.length; ++num) {
                temp[num] = annotation[num];
            }
            for (int i = 0; this.annotation != null && i < this.annotation.length; ++i) {
                temp[num + i] = this.annotation[i];
            }
            seq.annotation = temp;
        } else {
            seq.annotation = annotation != null ? (SequenceAnnotation[])annotation.clone() : null;
        }
        return seq;
    }

    protected abstract Sequence flatCloneWithoutAnnotation();

    public abstract int getLength();

    public String toString() {
        return this.toString(this.alphabetCon.getDelim(), 0, this.getLength());
    }

    public String toString(int start) {
        return this.toString(this.alphabetCon.getDelim(), start, this.getLength());
    }

    public String toString(int start, int end) {
        return this.toString(this.alphabetCon.getDelim(), start, end);
    }

    @Override
    public int compareTo(Sequence s) {
        int c = this.alphabetCon.compareTo(s.alphabetCon);
        if (c == 0) {
            int seqL;
            int l = this.getLength();
            if (l == (seqL = s.getLength())) {
                int i;
                if (this.alphabetCon.isDiscrete()) {
                    int thisVal = 0;
                    int seqVal = 0;
                    for (i = 0; i < l && (thisVal = this.discreteVal(i)) == (seqVal = s.discreteVal(i)); ++i) {
                    }
                    return thisVal - seqVal;
                }
                double thisVal = 0.0;
                double seqVal = 0.0;
                while (i < l && (thisVal = this.continuousVal(i)) == (seqVal = s.continuousVal(i))) {
                    ++i;
                }
                return (int)Math.signum(thisVal - seqVal);
            }
            return l - seqL;
        }
        return c;
    }

    protected int toDiscrete(int pos, double content) {
        return this.alphabetCon.toDiscrete(pos, content);
    }

    public String toString(String delim, int start, int end) {
        int i = start;
        int l = end - start;
        StringBuffer buf = new StringBuffer(l * (delim.length() == 0 ? 1 : 6));
        if (l > 0) {
            buf.append(this.alphabetCon.getSymbol(i, this.continuousVal(i++)));
            while (i < end) {
                buf.append(delim + this.alphabetCon.getSymbol(i, this.continuousVal(i++)));
            }
        }
        return buf.toString();
    }

    public static Sequence create(AlphabetContainer con, String sequence) throws WrongAlphabetException, IllegalArgumentException {
        return Sequence.create(con, sequence, con.getDelim());
    }

    public static Sequence create(AlphabetContainer con, String sequence, String delim) throws WrongAlphabetException, IllegalArgumentException {
        return Sequence.create(con, null, sequence, delim);
    }

    public static Sequence create(AlphabetContainer con, SequenceAnnotation[] annotation, String sequence, String delim) throws WrongAlphabetException, IllegalArgumentException {
        try {
            if (con.isDiscrete()) {
                int l = (int)con.getMaximalAlphabetLength();
                if (l <= 127) {
                    return new ByteSequence(con, annotation, sequence, delim);
                }
                if (l <= Short.MAX_VALUE) {
                    return new ShortSequence(con, annotation, sequence, delim);
                }
                if (l <= Integer.MAX_VALUE) {
                    return new IntSequence(con, annotation, sequence, delim);
                }
                throw new WrongAlphabetException("Could not encode. Too many symbols.");
            }
            return new ArbitrarySequence(con, annotation, sequence, delim);
        }
        catch (WrongSequenceTypeException e) {
            RuntimeException doesNotHappen = new RuntimeException(e.getMessage());
            doesNotHappen.setStackTrace(e.getStackTrace());
            throw doesNotHappen;
        }
    }

    public final Sequence reverse() throws OperationNotSupportedException {
        return this.reverse(0, this.getLength());
    }

    public Sequence reverse(int start, int end) throws OperationNotSupportedException {
        if (this.alphabetCon.isSimple()) {
            int i = 0;
            int j = end;
            try {
                if (this instanceof DiscreteSequence) {
                    int[] erg = new int[j - start];
                    --j;
                    while (j >= start) {
                        erg[i] = this.discreteVal(j);
                        --j;
                        ++i;
                    }
                    return new IntSequence(this.alphabetCon, erg);
                }
                double[] erg = new double[j - start];
                --j;
                while (j >= start) {
                    erg[i] = this.continuousVal(j);
                    --j;
                    ++i;
                }
                return new ArbitrarySequence(this.alphabetCon, erg);
            }
            catch (Exception e) {
                RuntimeException doesNotHappen = new RuntimeException(e.getMessage());
                doesNotHappen.setStackTrace(e.getStackTrace());
                throw doesNotHappen;
            }
        }
        throw new OperationNotSupportedException("The sequence has to be simple.");
    }

    public Sequence complement() throws OperationNotSupportedException {
        return this.complement(0, this.getLength());
    }

    public Sequence complement(int start, int end) throws OperationNotSupportedException {
        if (this.alphabetCon.isReverseComplementable()) {
            ComplementableDiscreteAlphabet cda = (ComplementableDiscreteAlphabet)this.alphabetCon.getAlphabetAt(0);
            try {
                if (cda.length() > 127.0) {
                    int[] erg = new int[end - start];
                    int i = 0;
                    for (int j = start; j < end; ++j) {
                        erg[i] = cda.getComplementaryCode(this.discreteVal(j));
                        ++i;
                    }
                    return new IntSequence(this.alphabetCon, erg);
                }
                byte[] erg = new byte[end - start];
                int i = 0;
                for (int j = start; j < end; ++j) {
                    erg[i] = (byte)cda.getComplementaryCode(this.discreteVal(j));
                    ++i;
                }
                return new ByteSequence(this.alphabetCon, erg);
            }
            catch (Exception e) {
                RuntimeException doesNotHappen = new RuntimeException(e.getMessage());
                doesNotHappen.setStackTrace(e.getStackTrace());
                throw doesNotHappen;
            }
        }
        throw new OperationNotSupportedException("The alphabet of sequence has to be complementable.");
    }

    public Sequence reverseComplement() throws OperationNotSupportedException {
        return this.reverseComplement(0, this.getLength());
    }

    public Sequence reverseComplement(int start, int end) throws OperationNotSupportedException {
        if (this.rc != null && start == 0 && end == this.getLength()) {
            return this.rc;
        }
        if (this.alphabetCon.isReverseComplementable()) {
            ComplementableDiscreteAlphabet cda = (ComplementableDiscreteAlphabet)this.alphabetCon.getAlphabetAt(0);
            int i = 0;
            int j = end;
            try {
                DiscreteSequence revComp;
                if (cda.length() > 127.0) {
                    int[] erg = new int[end - start];
                    --j;
                    while (j >= start) {
                        erg[i] = cda.getComplementaryCode(this.discreteVal(j));
                        --j;
                        ++i;
                    }
                    revComp = new IntSequence(this.alphabetCon, erg);
                } else {
                    byte[] erg = new byte[end - start];
                    --j;
                    while (j >= start) {
                        erg[i] = (byte)cda.getComplementaryCode(this.discreteVal(j));
                        --j;
                        ++i;
                    }
                    revComp = new ByteSequence(this.alphabetCon, erg);
                }
                if (start == 0 && end == this.getLength()) {
                    this.rc = revComp;
                    this.rc.rc = this;
                }
                return revComp;
            }
            catch (Exception e) {
                RuntimeException doesNotHappen = new RuntimeException(e.getMessage());
                doesNotHappen.setStackTrace(e.getStackTrace());
                throw doesNotHappen;
            }
        }
        throw new OperationNotSupportedException("The alphabet of sequence has to be reverse-complementable.");
    }

    public int hashCode() {
        int len = this.getLength();
        if (this.alphabetCon.isDiscrete()) {
            int h = 0;
            for (int i = 0; i < len; ++i) {
                h = 31 * h + this.discreteVal(i);
            }
            return h;
        }
        double h = 0.0;
        for (int i = 0; i < len; ++i) {
            h = 31.0 * h + this.continuousVal(i);
        }
        long bits = Double.doubleToLongBits(h);
        return (int)(bits ^ bits >>> 32);
    }

    protected static class SubSequence
    extends RecursiveSequence {
        private static final long serialVersionUID = 1L;
        private int start;
        private int length;

        private SubSequence(AlphabetContainer abc, SequenceAnnotation[] annotation, Sequence seq, int start, int length, boolean check) {
            super(abc, annotation, seq instanceof SubSequence ? ((SubSequence)seq).content : seq);
            if (check && !abc.checkConsistency(seq.getAlphabetContainer().getSubContainer(start, length))) {
                throw new IllegalArgumentException("Wrong AlphabetContainer.");
            }
            int sl = seq.getLength();
            if (start < 0 || start > sl) {
                throw new IllegalArgumentException("Illegal start position: start=" + start + " not in [0," + sl + "]");
            }
            if (length < 0 || start + length > sl) {
                throw new IllegalArgumentException("Illegal length: length=" + length + " not in [0," + (sl - start) + "]");
            }
            this.start = seq instanceof SubSequence ? ((SubSequence)seq).start + start : start;
            this.length = length;
        }

        public SubSequence(AlphabetContainer abc, Sequence seq, int start, int length) {
            this(abc, null, seq, start, length, true);
        }

        public SubSequence(Sequence seq, int start, int length) {
            this(seq.getAlphabetContainer().getSubContainer(start, length), null, seq, start, length, false);
        }

        public Sequence reverseComplement(int start, int end) throws OperationNotSupportedException {
            if (this.rc != null && start == 0 && end == this.getLength()) {
                return this.rc;
            }
            if (this.content.rc != null) {
                SubSequence revComp = new SubSequence(this.content.rc, this.content.rc.getLength() - this.start - end, end - start);
                if (start == 0 && end == this.getLength()) {
                    this.rc = revComp;
                    this.rc.rc = this;
                }
                return revComp;
            }
            return super.reverseComplement(start, end);
        }

        protected final int getIndex(int pos) {
            if (pos < 0 || pos >= this.length) {
                throw new ArrayIndexOutOfBoundsException(pos);
            }
            return this.start + pos;
        }

        public final int discreteVal(int pos) {
            if (pos < 0 || pos >= this.length) {
                throw new ArrayIndexOutOfBoundsException(pos);
            }
            return this.content.discreteVal(this.start + pos);
        }

        public int getLength() {
            return this.length;
        }

        protected Sequence flatCloneWithoutAnnotation() {
            return new SubSequence(this.alphabetCon, null, this.content, this.start, this.length, false);
        }
    }

    protected static class CompositeSequence
    extends RecursiveSequence {
        private static final long serialVersionUID = 1L;
        private int[] starts;
        private int[] lengths;

        private CompositeSequence(AlphabetContainer abc, SequenceAnnotation[] annotation, Sequence seq, int[] starts, int[] lengths, boolean check) {
            super(abc, annotation, seq);
            if (check && !abc.checkConsistency(seq.getAlphabetContainer().getCompositeContainer(starts, lengths))) {
                throw new IllegalArgumentException("Wrong AlphabetContainer.");
            }
            if (starts.length != lengths.length) {
                throw new IllegalArgumentException("starts and lengths have to be from the same dimension");
            }
            this.starts = (int[])starts.clone();
            this.lengths = (int[])lengths.clone();
            for (int i = 0; i < lengths.length; ++i) {
                if (starts[i] < 0 || seq.getLength() <= starts[i]) {
                    throw new IllegalArgumentException(i + "-th start has to be from range [0," + (seq.getLength() - 1) + "]");
                }
                if (lengths[i] < 0 || seq.getLength() < starts[i] + lengths[i]) {
                    throw new IllegalArgumentException(i + "-th length has to be from range [0," + (seq.getLength() - starts[i]) + "]");
                }
                this.starts[i] = starts[i];
                this.lengths[i] = lengths[i];
            }
        }

        public CompositeSequence(Sequence seq, int[] starts, int[] lengths) {
            this(seq.getAlphabetContainer().getCompositeContainer(starts, lengths), null, seq, starts, lengths, false);
        }

        public CompositeSequence(AlphabetContainer abc, Sequence seq, int[] starts, int[] lengths) {
            this(abc, null, seq, starts, lengths, true);
        }

        protected int getIndex(int pos) {
            int sum = 0;
            int i = 0;
            while (i < this.lengths.length && sum + this.lengths[i] <= pos) {
                sum += this.lengths[i++];
            }
            return this.starts[i] + (pos - sum);
        }

        public int getLength() {
            int sum = 0;
            for (int i = 0; i < this.lengths.length; ++i) {
                sum += this.lengths[i];
            }
            return sum;
        }

        protected Sequence flatCloneWithoutAnnotation() {
            return new CompositeSequence(this.alphabetCon, null, this.content, this.starts, this.lengths, false);
        }
    }
}

