/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.Comparator;
import java.util.List;
import org.biojava.bio.Annotatable;
import org.biojava.bio.seq.StrandedFeature;

public interface SeqSimilaritySearchHit
extends Annotatable {
    public static final ByScoreComparator byScore = new ByScoreComparator();
    public static final BySubHitCountComparator bySubHitCount = new BySubHitCountComparator();

    public double getScore();

    public double getPValue();

    public double getEValue();

    public int getQueryStart();

    public int getQueryEnd();

    public StrandedFeature.Strand getQueryStrand();

    public int getSubjectStart();

    public int getSubjectEnd();

    public StrandedFeature.Strand getSubjectStrand();

    public String getSubjectID();

    public List getSubHits();

    public static final class BySubHitCountComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            SeqSimilaritySearchHit h1 = (SeqSimilaritySearchHit)o1;
            SeqSimilaritySearchHit h2 = (SeqSimilaritySearchHit)o2;
            if (h1.getSubHits().size() > h2.getSubHits().size()) {
                return 1;
            }
            if (h1.getSubHits().size() < h2.getSubHits().size()) {
                return -1;
            }
            return 0;
        }
    }

    public static final class ByScoreComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            SeqSimilaritySearchHit h1 = (SeqSimilaritySearchHit)o1;
            SeqSimilaritySearchHit h2 = (SeqSimilaritySearchHit)o2;
            if (h1.getScore() > h2.getScore()) {
                return 1;
            }
            if (h1.getScore() < h2.getScore()) {
                return -1;
            }
            return 0;
        }
    }
}

