/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.loopGroup;

import de.jtem.numericalMethods.algebra.linear.MatrixOperations;
import de.jtem.numericalMethods.algebra.linear.VectorOperations;
import de.jtem.numericalMethods.algebra.linear.decompose.Householder;

public class IwasawaFactorization {
    public static void factor(double[][][] dArray, double[][][] dArray2, double[][][] dArray3, double[][][] dArray4, int n) {
        int n2 = dArray.length;
        int n3 = dArray[0][0].length / 2;
        int n4 = n;
        int n5 = 2 * n3 + 1 + n4;
        int n6 = n5 * n2;
        int n7 = n4 * n2;
        double[][] dArray5 = new double[n6][n7];
        double[][] dArray6 = new double[n6][n7];
        double[] dArray7 = new double[n7];
        double[] dArray8 = new double[n7];
        double[] dArray9 = new double[n6];
        double[] dArray10 = new double[n6];
        double[][] dArray11 = new double[n2][n6];
        double[][] dArray12 = new double[n2][n6];
        double[][] dArray13 = new double[n6][n2];
        double[][] dArray14 = new double[n6][n2];
        IwasawaFactorization.factor(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8, dArray9, dArray10, dArray11, dArray12, dArray13, dArray14, n);
    }

    public static void factor(double[][][] dArray, double[][][] dArray2, double[][][] dArray3, double[][][] dArray4, double[][] dArray5, double[][] dArray6, double[] dArray7, double[] dArray8, double[] dArray9, double[] dArray10, double[][] dArray11, double[][] dArray12, double[][] dArray13, double[][] dArray14, int n) {
        int n2;
        int n3;
        if (n <= 0) {
            throw new IllegalArgumentException("blockSize must be positive");
        }
        int n4 = dArray.length;
        int n5 = (dArray[0][0].length - 1) / 2;
        int n6 = n;
        for (int i = 0; i < n4; ++i) {
            for (n3 = 0; n3 < n4; ++n3) {
                IwasawaFactorization.setBlock(dArray[i][n3], dArray5, i, n3, n5, n6);
                IwasawaFactorization.setBlock(dArray2[i][n3], dArray6, i, n3, n5, n6);
            }
        }
        double[] dArray15 = Householder.decompose(dArray5, dArray6, dArray7, dArray8, dArray9, dArray10);
        if (dArray15[0] == 0.0 && dArray15[1] == 0.0) {
            throw new RuntimeException("not solvable");
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                IwasawaFactorization.setBlock(dArray[n2][n3], dArray11[n3], n2, n5, n6);
                IwasawaFactorization.setBlock(dArray2[n2][n3], dArray12[n3], n2, n5, n6);
            }
            VectorOperations.assign(dArray11[n3], dArray9);
            VectorOperations.assign(dArray12[n3], dArray10);
            Householder.qTimes(dArray5, dArray6, dArray9, dArray10, true);
            for (n2 = n6 * n4; n2 < dArray9.length; ++n2) {
                dArray10[n2] = 0.0;
                dArray9[n2] = 0.0;
            }
            Householder.qTimes(dArray5, dArray6, dArray9, dArray10, false);
            VectorOperations.minus(dArray11[n3], dArray9, dArray11[n3]);
            VectorOperations.minus(dArray12[n3], dArray10, dArray12[n3]);
        }
        MatrixOperations.transpose(dArray11, dArray13);
        MatrixOperations.transpose(dArray12, dArray14);
        double[] dArray16 = Householder.decompose(dArray13, dArray14, dArray7, dArray8, dArray9, dArray10);
        if (dArray16[0] == 0.0 && dArray16[1] == 0.0) {
            throw new RuntimeException("not solvable");
        }
        for (n2 = 0; n2 < n4; ++n2) {
            IwasawaFactorization.assignZero(dArray11[n2]);
            IwasawaFactorization.assignZero(dArray12[n2]);
            dArray11[n2][n2] = 1.0;
            Householder.qTimes(dArray13, dArray14, dArray11[n2], dArray12[n2], false);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            double d = Math.sqrt(dArray7[n2] * dArray7[n2] + dArray8[n2] * dArray8[n2]);
            double d2 = dArray7[n2] / d;
            double d3 = dArray8[n2] / d;
            VectorOperations.times(dArray11[n2], dArray12[n2], d2, d3, dArray11[n2], dArray12[n2]);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i = 0; i < n4; ++i) {
                IwasawaFactorization.getBlock(dArray3[i][n2], dArray11[n2], i, n5, n6);
                IwasawaFactorization.getBlock(dArray4[i][n2], dArray12[n2], i, n5, n6);
            }
        }
    }

    public static void positivePart(double[][][] dArray, double[][][] dArray2, double[][][] dArray3, double[][][] dArray4, double[][][] dArray5, double[][][] dArray6) {
        int n = dArray[0][0].length;
        double[] dArray7 = new double[n + 1];
        double[] dArray8 = new double[n + 1];
        IwasawaFactorization.positivePart(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8);
    }

    public static void positivePart(double[][][] dArray, double[][][] dArray2, double[][][] dArray3, double[][][] dArray4, double[][][] dArray5, double[][][] dArray6, double[] dArray7, double[] dArray8) {
        IwasawaFactorization.times(dArray3, dArray4, dArray, dArray2, dArray5, dArray6, dArray7, dArray8);
    }

    private static void times(double[][][] dArray, double[][][] dArray2, double[][][] dArray3, double[][][] dArray4, double[][][] dArray5, double[][][] dArray6, double[] dArray7, double[] dArray8) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                IwasawaFactorization.polynomialTimes(dArray[0][i], dArray2[0][i], dArray3[0][j], dArray4[0][j], dArray5[i][j], dArray6[i][j]);
                for (int k = 1; k < n; ++k) {
                    IwasawaFactorization.polynomialTimes(dArray[k][i], dArray2[k][i], dArray3[k][j], dArray4[k][j], dArray7, dArray8);
                    VectorOperations.plus(dArray5[i][j], dArray7, dArray5[i][j]);
                    VectorOperations.plus(dArray6[i][j], dArray8, dArray6[i][j]);
                }
            }
        }
    }

    private static void polynomialTimes(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) {
        if (dArray == dArray5 || dArray3 == dArray5) {
            throw new IllegalArgumentException();
        }
        int n = (dArray.length - 1) / 2;
        for (int i = 0; i <= n; ++i) {
            double d = 0.0;
            double d2 = 0.0;
            for (int j = 0; j <= 2 * n - i; ++j) {
                d += dArray[j] * dArray3[i + j] + dArray2[j] * dArray4[i + j];
                d2 += dArray[j] * dArray4[i + j] - dArray2[j] * dArray3[i + j];
            }
            dArray5[i] = d;
            dArray6[i] = d2;
        }
    }

    private static void setBlock(double[] dArray, double[][] dArray2, int n, int n2, int n3, int n4) {
        int n5 = 2 * n3 + 1 + n4;
        int n6 = n * (2 * n3 + 1 + n4);
        int n7 = n2 * n4;
        for (int i = 0; i < n4; ++i) {
            int n8;
            int n9 = i + 1;
            int n10 = Math.min(n5, 2 * n3 + 2 + i);
            for (n8 = 0; n8 < n9; ++n8) {
                dArray2[n8 + n6][i + n7] = 0.0;
            }
            for (n8 = n9; n8 < n10; ++n8) {
                dArray2[n8 + n6][i + n7] = dArray[n8 - i - 1];
            }
            for (n8 = n10; n8 < n5; ++n8) {
                dArray2[n8 + n6][i + n7] = 0.0;
            }
        }
    }

    private static void setBlock(double[] dArray, double[] dArray2, int n, int n2, int n3) {
        int n4;
        System.arraycopy(dArray, 0, dArray2, n * (2 * n2 + 1 + n3), 2 * n2 + 1);
        int n5 = n4 + n3;
        for (n4 = n * (2 * n2 + 1 + n3) + 2 * n2 + 1; n4 < n5; ++n4) {
            dArray2[n4] = 0.0;
        }
    }

    private static void getBlock(double[] dArray, double[] dArray2, int n, int n2, int n3) {
        System.arraycopy(dArray2, n * (2 * n2 + 1 + n3), dArray, 0, 2 * n2 + 1);
    }

    private static void assignZero(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 0.0;
        }
    }
}

