/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.Result;
import java.awt.image.BufferedImage;

public class ImageResult
extends Result {
    private BufferedImage image;

    public ImageResult(String name, String comment, BufferedImage image) {
        super(name, comment, DataType.PNG);
        this.image = image;
    }

    public BufferedImage getResult() {
        return this.image;
    }

    public StringBuffer toXML() {
        try {
            CategoricalResult res = new CategoricalResult(DataType.STRING, this.name, this.comment, (Comparable)((Object)"An image cannot be saved to an XML representation."));
            return res.toXML();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void fromXML(StringBuffer representation) throws NonParsableException {
        CategoricalResult res = new CategoricalResult(representation);
        this.name = res.name;
        this.comment = res.comment + " (" + res.getResult().toString() + ")";
        this.datatype = DataType.PNG;
    }

    public String toString() {
        return this.name + ": [image]";
    }
}

