/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.InstantiableFromParameterSet;
import de.jstacs.NonParsableException;
import de.jstacs.io.ParameterSetParser;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.ParameterSet;

public abstract class InstanceParameterSet
extends ParameterSet {
    private Class instanceClass;

    public InstanceParameterSet(Class instanceClass) throws IllegalArgumentException {
        if (instanceClass == null) {
            throw new IllegalArgumentException("The instanceClass can not be null.");
        }
        this.instanceClass = instanceClass;
    }

    public InstanceParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public Class getInstanceClass() {
        return this.instanceClass;
    }

    public InstantiableFromParameterSet getInstance() throws ParameterSetParser.NotInstantiableException {
        return ParameterSetParser.getInstanceFromParameterSet(this);
    }

    public abstract String getInstanceComment();

    public abstract String getInstanceName();

    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superParameterSet");
        XMLParser.appendStringWithTags(buf, this.instanceClass.getName(), "instanceClass");
        XMLParser.addTags(buf, "instanceParameterSet");
        return buf;
    }

    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "instanceParameterSet");
        super.fromXML(XMLParser.extractForTag(representation, "superParameterSet"));
        try {
            this.instanceClass = Class.forName(XMLParser.extractStringForTag(representation, "instanceClass"));
        }
        catch (ClassNotFoundException e) {
            throw new NonParsableException(e.getMessage());
        }
    }
}

