/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayHandler {
    public static <T> Class getSuperClassOf(T ... o) {
        LinkedList classHierarchy = new LinkedList();
        HashSet hash = new HashSet();
        for (int i = 0; i < o.length; ++i) {
            Class<?> current;
            if (o[i] == null) continue;
            if (classHierarchy.size() == 0) {
                for (current = o[i].getClass(); current != Object.class; current = current.getSuperclass()) {
                    classHierarchy.add(current);
                    hash.add(current);
                }
                classHierarchy.add(current);
                hash.add(current);
                continue;
            }
            while (!hash.contains(current)) {
                current = current.getSuperclass();
            }
            while (classHierarchy.get(0) != current) {
                hash.remove(classHierarchy.remove(0));
            }
            if (classHierarchy.size() == 1) break;
        }
        if (classHierarchy.size() > 0) {
            return (Class)classHierarchy.get(0);
        }
        return o.getClass().getComponentType();
    }

    public static Object[] cast(Object[] o) {
        return ArrayHandler.cast(ArrayHandler.getSuperClassOf(o), o);
    }

    public static <S> S[] cast(Class<? extends S> c, Object[] o) {
        Object[] res = (Object[])Array.newInstance(c, o.length);
        for (int i = 0; i < o.length; ++i) {
            res[i] = o[i];
        }
        return res;
    }

    public static <T extends Cloneable> T[] clone(T ... t) throws CloneNotSupportedException {
        if (t != null && t.length > 0) {
            Class<?> c = t.getClass().getComponentType();
            Cloneable[] res = (Cloneable[])Array.newInstance(c, t.length);
            try {
                Method cloneMethod = c.getMethod("clone", new Class[0]);
                for (int i = 0; i < t.length; ++i) {
                    res[i] = (Cloneable)cloneMethod.invoke(t[i], new Object[0]);
                }
            }
            catch (Exception e) {
                CloneNotSupportedException cnse = new CloneNotSupportedException(e.getMessage());
                cnse.setStackTrace(e.getStackTrace());
                throw cnse;
            }
            return res;
        }
        return null;
    }
}

