/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.WrongAlphabetException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.DiscreteSequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.SymbolExtractor;

public class ByteSequence
extends DiscreteSequence {
    private byte[] content;

    public ByteSequence(AlphabetContainer alphabetContainer, byte[] content) throws WrongAlphabetException, WrongSequenceTypeException {
        super(alphabetContainer, null);
        if (alphabetContainer.getMaximalAlphabetLength() > 127.0) {
            throw new WrongSequenceTypeException();
        }
        this.content = new byte[content.length];
        for (int i = 0; i < content.length; ++i) {
            if (!alphabetContainer.isEncodedSymbol(i, content[i])) {
                throw new WrongAlphabetException();
            }
            this.content[i] = content[i];
        }
    }

    private ByteSequence(AlphabetContainer cont, SequenceAnnotation[] annotation, byte[] content) throws WrongAlphabetException {
        super(cont, annotation);
        this.content = content;
    }

    public ByteSequence(AlphabetContainer alphabetContainer, String sequence) throws WrongAlphabetException, WrongSequenceTypeException {
        this(alphabetContainer, null, sequence, alphabetContainer.getDelim());
    }

    public ByteSequence(AlphabetContainer alphabetContainer, SequenceAnnotation[] annotation, String sequence, String delim) throws WrongAlphabetException, WrongSequenceTypeException {
        this(alphabetContainer, annotation, new SymbolExtractor(sequence, delim));
    }

    public ByteSequence(AlphabetContainer alphabetContainer, SequenceAnnotation[] annotation, SymbolExtractor extractor) throws WrongAlphabetException, WrongSequenceTypeException {
        super(alphabetContainer, annotation);
        if (alphabetContainer.getMaximalAlphabetLength() > 127.0) {
            throw new WrongSequenceTypeException();
        }
        this.content = new byte[extractor.countElements()];
        for (int k = 0; k < this.content.length; ++k) {
            this.content[k] = (byte)alphabetContainer.getCode(k, extractor.nextElement());
        }
    }

    public int discreteVal(int pos) {
        return this.content[pos];
    }

    public int getLength() {
        return this.content.length;
    }

    protected Sequence flatCloneWithoutAnnotation() {
        try {
            return new ByteSequence(this.getAlphabetContainer(), null, this.content);
        }
        catch (Exception doesnothappen) {
            throw new RuntimeException(doesnothappen);
        }
    }
}

