/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.parameters.MultiSelectionCollectionParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.RangeParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.Result;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MeasureParameters
extends MultiSelectionCollectionParameter {
    private static final String[] getStringArray(String[] template, boolean all) {
        if (all) {
            return template;
        }
        String[] copy = new String[template.length - 2];
        System.arraycopy(template, 0, copy, 0, copy.length);
        return copy;
    }

    private static final Object[] getValuesArray(boolean all, Double sp, Double snForFPR, Double snForPPV, Double minSpec, Double maxSpec, Integer steps, RangeParameter.Scale scale) throws ParameterException {
        Object[] values = new Object[8 + (all ? 2 : 0)];
        NumberValidator<Double> validator = new NumberValidator<Double>(new Double(0.0), new Double(1.0));
        values[5] = values[6] = new SimpleParameterSet(new Parameter[0]);
        values[4] = values[6];
        values[0] = values[6];
        values[1] = sp == null ? new SimpleParameterSet(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Specificity", "The fixed specificity", true, validator)}) : new SimpleParameterSet(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Specificity", "The fixed specificity", true, validator, sp)});
        values[2] = snForFPR == null ? new SimpleParameterSet(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Sensitivity", "The fixed sensitivity", true, validator)}) : new SimpleParameterSet(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Sensitivity", "The fixed sensitivity", true, validator, snForFPR)});
        values[3] = snForPPV == null ? new SimpleParameterSet(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Sensitivity", "The fixed sensitivity", true, validator)}) : new SimpleParameterSet(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Sensitivity", "The fixed sensitivity", true, validator, snForPPV)});
        try {
            RangeParameter rp = new RangeParameter(new SimpleParameter(DataType.DOUBLE, "Specificity", "The specificity", true, validator));
            values[7] = new SimpleParameterSet(new Parameter[]{rp});
            if (minSpec != null && maxSpec != null && steps != null && scale != null) {
                rp.setValues(minSpec, steps, maxSpec, scale);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ParameterException(e.getMessage());
        }
        if (all) {
            Object object = values[0];
            values[values.length - 1] = object;
            values[values.length - 2] = object;
        }
        return values;
    }

    public MeasureParameters(boolean evaluateAll) throws ParameterException {
        super(DataType.PARAMETERSET, MeasureParameters.getStringArray(Measure.getMeasureNames(), evaluateAll), MeasureParameters.getValuesArray(evaluateAll, null, null, null, null, null, null, null), MeasureParameters.getStringArray(Measure.getMeasureComments(), evaluateAll), "Performance measures", "Choose the desired performance measures", true);
    }

    public MeasureParameters(boolean evaluateAll, double sp, double snForFPR, double snForPPV) throws ParameterException {
        super(DataType.PARAMETERSET, MeasureParameters.getStringArray(Measure.getMeasureNames(), evaluateAll), MeasureParameters.getValuesArray(evaluateAll, sp, snForFPR, snForPPV, null, null, null, null), MeasureParameters.getStringArray(Measure.getMeasureComments(), evaluateAll), "Performance measures", "Choose the desired performance measures", true);
        this.setValue(MeasureParameters.getStringArray(Measure.getMeasureNames(), evaluateAll));
        this.setSelected(Measure.PartialROCCurve, false);
    }

    public MeasureParameters(boolean evaluateAll, double sp, double snForFPR, double snForPPV, double minSpec, double maxSpec, int steps, RangeParameter.Scale scale) throws ParameterException {
        super(DataType.PARAMETERSET, MeasureParameters.getStringArray(Measure.getMeasureNames(), evaluateAll), MeasureParameters.getValuesArray(evaluateAll, sp, snForFPR, snForPPV, minSpec, maxSpec, steps, scale), MeasureParameters.getStringArray(Measure.getMeasureNames(), evaluateAll), "Performance measures", "Choose the desired performance measures", true);
        this.setValue(MeasureParameters.getStringArray(Measure.getMeasureNames(), evaluateAll));
    }

    public void setSelected(Measure sel, boolean b) {
        this.setSelected(sel.getNameString(), b);
    }

    public boolean isSelected(Measure sel) {
        return this.isSelected(sel.getNameString());
    }

    public void deselectAll() {
        Measure[] vals = Measure.values();
        for (int i = 0; i < vals.length; ++i) {
            this.setSelected(vals[i], false);
        }
    }

    public MeasureParameters(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public LinkedList<Result> getAnnotation() {
        LinkedList<Result> list = new LinkedList<Result>();
        int l = this.parameters.getNumberOfParameters();
        for (int i = 0; i < l; ++i) {
            if (!this.isSelected(i)) continue;
            Parameter p = this.parameters.getParameterAt(i);
            SimpleParameterSet sps = (SimpleParameterSet)p.getValue();
            list.add(new CategoricalResult(p.getName(), p.getComment(), true));
            for (int j = 0; j < sps.getNumberOfParameters(); ++j) {
                p = sps.getParameterAt(j);
                if (p instanceof RangeParameter) {
                    list.add(new CategoricalResult(p.getName(), p.getComment(), ((RangeParameter)p).valuesToString()));
                    continue;
                }
                list.add(new NumericalResult(p.getName(), p.getComment(), ((Number)p.getValue()).doubleValue()));
            }
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Measure {
        ClassificationRate("Classification rate", "The ratio of correctly classified sequences and all sequences"),
        Sensitivity("Sensitivity for fixed specificity", "The sensitivity TP / (TP + FN) for a fixed, previously chosen specificity TN / (FP + TN)"),
        FalsePositiveRate("False positive rate for fixed sensitivity", "The false positive rate FP / (FP + TN) for a fixed, previously chosen sensitivity TP / (TP + FN)"),
        PositivePredictiveValue("Positive predictive value for fixed sensitivity", "The positive predictive value TP / (TP+FP) for a fixed, previously chosen sensitivity TP / (TP + FN)"),
        AreaUnderROCCurve("Area under ROC curve", "The area under the receiver operating characteristic (ROC) curve"),
        AreaUnderPrecisionRecallCurve("Area under PR curve", "The area under the precision recall (PR) curve"),
        MaximumCorrelationCoefficient("Maximum correlation coefficient", "The maximum of all possible correlation coefficients"),
        PartialROCCurve("Partial ROC curve", "A part of the ROC curve between minimum and maximum specificity"),
        ReceiverOperatingCharacteristicCurve("Receiver operating characteristic curve", "The points of the receiver operating characteristic (ROC) curve"),
        PrecisionRecallCurve("Precsion recall curve", "The points of the precision recall (PR) curve");

        private String name;
        private String comment;

        private Measure(String name, String comment) {
            this.name = name;
            this.comment = comment;
        }

        public String getNameString() {
            return this.name;
        }

        public String getCommentString() {
            return this.comment;
        }

        private static String[] getMeasureNames() {
            Measure[] vals = Measure.values();
            String[] names = new String[vals.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = vals[i].getNameString();
            }
            return names;
        }

        private static String[] getMeasureComments() {
            Measure[] vals = Measure.values();
            String[] comments = new String[vals.length];
            for (int i = 0; i < comments.length; ++i) {
                comments[i] = vals[i].getCommentString();
            }
            return comments;
        }
    }
}

