/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions;

import de.jstacs.NonParsableException;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.Mutable;
import de.jstacs.scoringFunctions.AbstractNormalizableScoringFunction;
import de.jstacs.scoringFunctions.NormalizableScoringFunction;
import de.jstacs.scoringFunctions.mix.AbstractMixtureScoringFunction;
import de.jstacs.scoringFunctions.mix.StrandScoringFunction;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;

public final class NormalizedScoringFunction
extends AbstractNormalizableScoringFunction
implements Mutable {
    private NormalizableScoringFunction nsf;
    private int starts;
    private double logNorm;
    private double[] proportion;

    public static final NormalizableScoringFunction getNormalizedVersion(NormalizableScoringFunction nsf, int starts) throws Exception {
        if (nsf.isNormalized()) {
            return (NormalizableScoringFunction)nsf.clone();
        }
        return new NormalizedScoringFunction(nsf, starts);
    }

    public NormalizedScoringFunction(NormalizableScoringFunction nsf, int starts) throws Exception {
        super(nsf.getAlphabetContainer(), nsf.getLength());
        if (starts <= 0) {
            throw new IllegalArgumentException("The number of starts has to be positive.");
        }
        this.starts = starts;
        this.nsf = (NormalizableScoringFunction)nsf.clone();
        this.precomputeIfPossible();
    }

    public NormalizedScoringFunction(StringBuffer xml) throws NonParsableException {
        super(xml);
        try {
            this.precomputeIfPossible();
        }
        catch (Exception e) {
            NonParsableException n = new NonParsableException(e.getMessage());
            n.setStackTrace(e.getStackTrace());
            throw n;
        }
    }

    public NormalizedScoringFunction clone() throws CloneNotSupportedException {
        NormalizedScoringFunction clone = (NormalizedScoringFunction)super.clone();
        clone.nsf = (NormalizableScoringFunction)this.nsf.clone();
        return clone;
    }

    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return this.nsf.getSizeOfEventSpaceForRandomVariablesOfParameter(index);
    }

    public double getNormalizationConstant() {
        return 1.0;
    }

    public double getPartialNormalizationConstant(int parameterIndex) throws Exception {
        return 0.0;
    }

    public double getEss() {
        return this.nsf.getEss();
    }

    public double getLogPriorTerm() {
        return this.nsf.getLogPriorTerm() - this.nsf.getEss() * this.logNorm;
    }

    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        this.nsf.addGradientOfLogPriorTerm(grad, start);
        double e = this.nsf.getEss();
        for (int i = 0; i < this.proportion.length; ++i) {
            int n = start + i;
            grad[n] = grad[n] - e * this.proportion[i];
        }
    }

    public void initializeFunction(int index, boolean freeParams, Sample[] data, double[][] weights) throws Exception {
        this.nsf.initializeFunction(index, freeParams, data, weights);
        this.precompute();
    }

    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        this.nsf.initializeFunctionRandomly(freeParams);
        this.precompute();
    }

    protected void fromXML(StringBuffer xml) throws NonParsableException {
        StringBuffer b = XMLParser.extractForTag(xml, this.getClass().getSimpleName());
        this.nsf = (NormalizableScoringFunction)XMLParser.extractStorableForTag(b, "function");
        this.alphabets = this.nsf.getAlphabetContainer();
        this.length = this.nsf.getLength();
        this.starts = XMLParser.extractIntForTag(b, "starts");
    }

    public String getInstanceName() {
        return "normalized " + this.nsf.getInstanceName();
    }

    public double getLogScore(Sequence seq, int start) {
        return this.nsf.getLogScore(seq, start) - this.logNorm;
    }

    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double score = this.nsf.getLogScoreAndPartialDerivation(seq, start, indices, partialDer) - this.logNorm;
        try {
            for (int i = 0; i < this.proportion.length; ++i) {
                indices.add(i);
                partialDer.add(-this.proportion[i]);
            }
        }
        catch (Exception e) {
            RuntimeException r = new RuntimeException(e.getMessage());
            r.setStackTrace(e.getStackTrace());
            throw r;
        }
        return score;
    }

    public int getNumberOfParameters() {
        return this.nsf.getNumberOfParameters();
    }

    public double[] getCurrentParameterValues() throws Exception {
        return this.nsf.getCurrentParameterValues();
    }

    public void setParameters(double[] params, int start) {
        this.nsf.setParameters(params, start);
        try {
            this.precompute();
        }
        catch (Exception e) {
            RuntimeException r = new RuntimeException(e.getMessage());
            r.setStackTrace(e.getStackTrace());
            throw r;
        }
    }

    private void precomputeIfPossible() throws Exception {
        if (this.nsf.isInitialized()) {
            this.precompute();
        } else {
            this.logNorm = Double.NEGATIVE_INFINITY;
            this.proportion = null;
        }
    }

    private void precompute() throws Exception {
        if (this.proportion == null) {
            this.proportion = new double[this.nsf.getNumberOfParameters()];
        }
        this.logNorm = this.nsf.getNormalizationConstant();
        for (int i = 0; i < this.proportion.length; ++i) {
            this.proportion[i] = this.nsf.getPartialNormalizationConstant(i) / this.logNorm;
        }
        this.logNorm = Math.log(this.logNorm);
    }

    public boolean isInitialized() {
        return this.nsf.isInitialized();
    }

    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(100000);
        XMLParser.appendStorableWithTags(xml, this.nsf, "function");
        XMLParser.appendIntWithTags(xml, this.starts, "starts");
        XMLParser.addTags(xml, this.getClass().getSimpleName());
        return xml;
    }

    public int getNumberOfRecommendedStarts() {
        return this.starts;
    }

    public boolean isNormalized() {
        return true;
    }

    public String toString() {
        return "normalized variante of\n" + this.nsf.toString();
    }

    public NormalizableScoringFunction getFunction() throws CloneNotSupportedException {
        return (NormalizableScoringFunction)this.nsf.clone();
    }

    public int[] determineNotSignificantPositions(double samples, double[] weightsLeft, double[] weightsRight, double[][][][] contrastLeft, double[][][][] contrastRight, double sign) {
        if (this.nsf instanceof Mutable) {
            return ((Mutable)((Object)this.nsf)).determineNotSignificantPositions(samples, weightsLeft, weightsRight, contrastLeft, contrastRight, sign);
        }
        return new int[]{0, 0};
    }

    public boolean modify(double[] weightsLeft, double[] weightsRight, double[][][][] replacementLeft, double[][][][] replacementRight, int offsetLeft, int offsetRight) {
        if (this.nsf instanceof Mutable) {
            boolean modified = ((Mutable)((Object)this.nsf)).modify(weightsLeft, weightsRight, replacementLeft, replacementRight, offsetLeft, offsetRight);
            if (modified) {
                if (this.proportion.length != this.nsf.getNumberOfParameters()) {
                    this.proportion = new double[this.nsf.getNumberOfParameters()];
                }
                try {
                    this.precompute();
                }
                catch (Exception e) {
                    RuntimeException r = new RuntimeException(e.getMessage());
                    r.setStackTrace(e.getStackTrace());
                    throw r;
                }
                this.length = this.nsf.getLength();
            }
            return modified;
        }
        return false;
    }

    public boolean isStrandScoringFunction() {
        if (this.nsf instanceof NormalizedScoringFunction) {
            return ((NormalizedScoringFunction)this.nsf).isStrandScoringFunction();
        }
        return this.nsf instanceof StrandScoringFunction;
    }

    public StrandedLocatedSequenceAnnotationWithLength.Strand getStrand(Sequence seq, int startPos) {
        if (this.nsf instanceof NormalizedScoringFunction) {
            return ((NormalizedScoringFunction)this.nsf).getStrand(seq, startPos);
        }
        if (this.nsf instanceof StrandScoringFunction) {
            return ((StrandScoringFunction)this.nsf).getStrand(seq, startPos);
        }
        return StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD;
    }

    public void initializeHiddenUniformly() {
        if (this.nsf instanceof NormalizedScoringFunction) {
            ((NormalizedScoringFunction)this.nsf).initializeHiddenUniformly();
        } else if (this.nsf instanceof AbstractMixtureScoringFunction) {
            ((AbstractMixtureScoringFunction)this.nsf).initializeHiddenUniformly();
        }
    }
}

