/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.mesh;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class Edge {
    static final int MAX_VERTEX_INDEX = (int)Math.sqrt(2.147483645E9);
    public final int v1;
    public final int v2;

    public Edge(int n, int n2) {
        this.v1 = n;
        this.v2 = n2;
    }

    static int hashCode(int n, int n2) {
        return n > n2 ? n * MAX_VERTEX_INDEX + n2 : n2 * MAX_VERTEX_INDEX + n;
    }

    public final int hashCode() {
        return Edge.hashCode(this.v1, this.v2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Edge)) {
            return false;
        }
        Edge edge = (Edge)object;
        return this.v1 == edge.v1 && this.v2 == edge.v2 || this.v1 == edge.v2 && this.v2 == edge.v1;
    }

    public final boolean containsVertex(int n) {
        return this.v1 == n || this.v2 == n;
    }

    public final int getCommonVertex(Edge edge) {
        if (edge.containsVertex(this.v1)) {
            return this.v1;
        }
        if (edge.containsVertex(this.v2)) {
            return this.v2;
        }
        throw new IllegalArgumentException("edges do not share common vertex");
    }

    int getOtherVertex(int n) {
        if (this.v1 == n) {
            return this.v2;
        }
        if (this.v2 == n) {
            return this.v1;
        }
        throw new IllegalArgumentException("given index is not a vertex of the edge");
    }

    public static void computeEdgesOfIndexedFaceSet(int[][] nArray, Set hashSet, Set hashSet2) {
        HashMap hashMap = new HashMap();
        if (hashSet != null) {
            hashSet.clear();
        } else {
            hashSet = new HashSet();
        }
        if (hashSet2 != null) {
            hashSet2.clear();
        } else {
            hashSet2 = new HashSet();
        }
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = nArray[i];
            for (int j = 1; j < nArray2.length; ++j) {
                Edge.addEdge(hashSet, hashMap, i, nArray2[j - 1], nArray2[j]);
            }
            Edge.addEdge(hashSet, hashMap, i, nArray2[nArray2.length - 1], nArray2[0]);
        }
        hashSet2.addAll(hashMap.values());
    }

    private static void addEdge(Set set, HashMap hashMap, int n, int n2, int n3) {
        Edge edge = new Edge(n2, n3);
        Winged winged = (Winged)hashMap.get(edge);
        if (winged != null) {
            hashMap.remove(edge);
            set.add(new Winged(winged.v1, winged.v2, winged.f1, n));
        } else {
            hashMap.put(edge, new Winged(n2, n3, n));
        }
    }

    public static HashSet getWingedEdgesOfIndexedFaceSet(int[][] nArray) {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        Edge.computeEdgesOfIndexedFaceSet(nArray, hashSet, hashSet2);
        hashSet.addAll(hashSet2);
        return hashSet;
    }

    public static HashSet getInnerEdgesOfIndexedFaceSet(int[][] nArray) {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        Edge.computeEdgesOfIndexedFaceSet(nArray, hashSet, hashSet2);
        return hashSet;
    }

    public static HashSet getBoundaryEdgesOfIndexedFaceSet(int[][] nArray) {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        Edge.computeEdgesOfIndexedFaceSet(nArray, hashSet, hashSet2);
        return hashSet2;
    }

    public static int[][] getBoundaryOfIndexedFaceSet(int[][] nArray) {
        return Edge.stripEdges(Edge.getBoundaryEdgesOfIndexedFaceSet(nArray));
    }

    public static int[][] stripEdges(Set set) {
        Vector vector = new Vector();
        Edge.stripEdges(set, vector);
        int[][] nArrayArray = new int[vector.size()][];
        for (int i = 0; i < nArrayArray.length; ++i) {
            List list = (List)vector.get(i);
            nArrayArray[i] = new int[list.size() + 1];
            Edge edge = (Edge)list.get(0);
            if (nArrayArray[i].length == 2) {
                nArrayArray[i][0] = edge.v1;
                nArrayArray[i][1] = edge.v2;
            }
            nArrayArray[i][1] = edge.getCommonVertex((Edge)list.get(1));
            nArrayArray[i][0] = edge.getOtherVertex(nArrayArray[i][1]);
            for (int j = 2; j < nArrayArray[i].length; ++j) {
                nArrayArray[i][j] = ((Edge)list.get(j - 1)).getOtherVertex(nArrayArray[i][j - 1]);
            }
        }
        return nArrayArray;
    }

    public static int[][] getBoundaryLinesOfIndexedFaceSet(int[][] nArray) {
        return Edge.stripEdges(Edge.getBoundaryEdgesOfIndexedFaceSet(nArray));
    }

    public static void stripEdges(Set set, Collection collection) {
        collection.clear();
        Vector<Edge> vector = new Vector<Edge>();
        while (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            Edge edge = (Edge)iterator.next();
            int n = edge.v1;
            int n2 = edge.v2;
            LinkedList<Edge> linkedList = new LinkedList<Edge>();
            vector.clear();
            vector.add(edge);
            linkedList.add(edge);
            while (true) {
                if (iterator.hasNext()) {
                    Edge edge2 = (Edge)iterator.next();
                    if (edge2.containsVertex(n)) {
                        n = edge2.getOtherVertex(n);
                        linkedList.addFirst(edge2);
                        vector.add(edge2);
                        continue;
                    }
                    if (!edge2.containsVertex(n2)) continue;
                    n2 = edge2.getOtherVertex(n2);
                    linkedList.addLast(edge2);
                    vector.add(edge2);
                    continue;
                }
                set.removeAll(vector);
                if (vector.isEmpty()) break;
                vector.clear();
                iterator = set.iterator();
            }
            collection.add(linkedList);
        }
    }

    public String toString() {
        return "(v1=" + this.v1 + ",v2=" + this.v2 + ")";
    }

    public static void main(String[] stringArray) {
        int[][] nArrayArray = new int[][]{{0, 5, 4, 1}, {1, 4, 3}, {1, 3, 2}};
        System.out.println(Edge.getBoundaryEdgesOfIndexedFaceSet(nArrayArray));
        int[][] nArray = Edge.stripEdges(Edge.getBoundaryEdgesOfIndexedFaceSet(nArrayArray));
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                System.out.print("->" + nArray[i][j]);
            }
            System.out.println();
        }
    }

    public static class Winged
    extends Edge {
        public static final int NO_FACE = -1;
        public final int f1;
        public final int f2;

        public Winged(int n, int n2, int n3) {
            this(n, n2, n3, -1);
        }

        public Winged(int n, int n2, int n3, int n4) {
            super(n, n2);
            this.f1 = n3;
            this.f2 = n4;
        }

        public String toString() {
            return "(v1=" + this.v1 + ",v2=" + this.v2 + ",f1=" + this.f1 + ",f2=" + this.f2 + ")";
        }
    }
}

