/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.MergeFeatureHolder;
import org.biojava.bio.seq.RealizingFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.db.biosql.BioSQLAllFeatures;
import org.biojava.bio.seq.db.biosql.BioSQLComponentFeature;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceAnnotation;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceI;
import org.biojava.bio.seq.impl.AssembledSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

class BioSQLAssembly
implements Sequence,
RealizingFeatureHolder,
BioSQLSequenceI {
    private BioSQLSequenceDB seqDB;
    private String name;
    private int assembly_id;
    private int bioentry_id;
    private Annotation annotation;
    private Alphabet alphabet;
    private int length;
    private RealizingFeatureHolder features;
    private SimpleFeatureHolder componentFeatures;
    private MergeFeatureHolder allFeatures;
    private AssembledSymbolList symbols;

    public BioSQLSequenceDB getSequenceDB() {
        return this.seqDB;
    }

    public int getBioEntryID() {
        return this.bioentry_id;
    }

    BioSQLAssembly(BioSQLSequenceDB seqDB, String name, int bioentry_id, int assembly_id, String alphaName, int length) throws BioException {
        this.seqDB = seqDB;
        this.name = name;
        this.bioentry_id = bioentry_id;
        this.assembly_id = assembly_id;
        this.length = length;
        try {
            this.alphabet = AlphabetManager.alphabetForName(alphaName.toUpperCase());
        }
        catch (NoSuchElementException ex) {
            throw new BioException("Can't load sequence with unknown alphabet " + alphaName, ex);
        }
        this.features = new BioSQLAllFeatures(this, seqDB, bioentry_id);
    }

    public String getName() {
        return this.name;
    }

    public String getURN() {
        return this.name;
    }

    public Annotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new BioSQLSequenceAnnotation(this.seqDB, this.bioentry_id);
        }
        return this.annotation;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public int length() {
        return this.getSymbols().length();
    }

    public Symbol symbolAt(int i) {
        return this.getSymbols().symbolAt(i);
    }

    public SymbolList subList(int start, int end) {
        return this.getSymbols().subList(start, end);
    }

    public List toList() {
        return this.getSymbols().toList();
    }

    public Iterator iterator() {
        return this.getSymbols().iterator();
    }

    public String seqString() {
        return this.getSymbols().seqString();
    }

    public String subStr(int start, int end) {
        return this.getSymbols().subStr(start, end);
    }

    public void edit(Edit e) throws ChangeVetoException {
        throw new ChangeVetoException("Can't edit sequence in BioSQL -- or at least not yet...");
    }

    protected synchronized SimpleFeatureHolder getComponentFeatures() {
        if (this.componentFeatures == null) {
            this.componentFeatures = new SimpleFeatureHolder();
            Connection conn = null;
            try {
                conn = this.seqDB.getDataSource().getConnection();
                PreparedStatement get_assembly = conn.prepareStatement("select assembly_fragment_id, fragment_name, assembly_start, assembly_end, fragment_start, fragment_end, strand   from assembly_fragment  where assembly_id = ?");
                get_assembly.setInt(1, this.assembly_id);
                ResultSet rs = get_assembly.executeQuery();
                while (rs.next()) {
                    int assembly_fragment_id = rs.getInt(1);
                    String fragment_name = rs.getString(2);
                    int assembly_start = rs.getInt(3);
                    int assembly_end = rs.getInt(4);
                    int fragment_start = rs.getInt(5);
                    int fragment_end = rs.getInt(6);
                    ComponentFeature.Template temp = new ComponentFeature.Template();
                    temp.type = "component";
                    temp.source = "biosql";
                    temp.location = new RangeLocation(assembly_start, assembly_end);
                    temp.componentSequenceName = fragment_name;
                    temp.componentLocation = new RangeLocation(fragment_start, fragment_end);
                    this.componentFeatures.addFeature(new BioSQLComponentFeature(this.seqDB, this, temp, assembly_fragment_id));
                }
                rs.close();
                get_assembly.close();
                conn.close();
            }
            catch (SQLException ex) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex3) {
                        // empty catch block
                    }
                }
                throw new BioRuntimeException("Error fetching assembly data", ex);
            }
            catch (ChangeVetoException ex) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw new AssertionFailure("Assertion failure: Couldn't modify private featureholder", ex);
            }
        }
        return this.componentFeatures;
    }

    protected synchronized SymbolList getSymbols() {
        if (this.symbols == null) {
            SimpleFeatureHolder components = this.getComponentFeatures();
            this.symbols = new AssembledSymbolList();
            this.symbols.setLength(this.length);
            Iterator i = components.features();
            while (i.hasNext()) {
                ComponentFeature cf = (ComponentFeature)i.next();
                this.symbols.putComponent(cf);
            }
        }
        return this.symbols;
    }

    private RealizingFeatureHolder getFeatures() {
        return this.features;
    }

    private FeatureHolder getAllFeatures() {
        if (this.allFeatures == null) {
            try {
                this.allFeatures = new MergeFeatureHolder();
                this.allFeatures.addFeatureHolder(this.getComponentFeatures());
                this.allFeatures.addFeatureHolder(this.getFeatures());
            }
            catch (ChangeVetoException ex) {
                throw new BioError("Assertion failure: Couldn't modify private featureholder");
            }
        }
        return this.allFeatures;
    }

    public Iterator features() {
        return this.getAllFeatures().features();
    }

    public int countFeatures() {
        return this.getAllFeatures().countFeatures();
    }

    public boolean containsFeature(Feature f) {
        return this.getAllFeatures().containsFeature(f);
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.getAllFeatures().filter(ff, recurse);
    }

    public FeatureHolder filter(FeatureFilter ff) {
        return this.getAllFeatures().filter(ff);
    }

    public FeatureFilter getSchema() {
        return this.getFeatures().getSchema();
    }

    public Feature createFeature(Feature.Template ft) throws ChangeVetoException, BioException {
        return this.getFeatures().createFeature(ft);
    }

    public void removeFeature(Feature f) throws ChangeVetoException, BioException {
        this.getFeatures().removeFeature(f);
    }

    public Feature realizeFeature(FeatureHolder parent, Feature.Template templ) throws BioException {
        return this.getFeatures().realizeFeature(parent, templ);
    }

    public void persistFeature(Feature f, int parent_id) throws BioException {
        this.seqDB.getFeaturesSQL().persistFeature(f, parent_id, this.bioentry_id);
    }

    public void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        this.getSequenceDB().getEntryChangeHub().addListener(this.bioentry_id, cl, ct);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        this.getSequenceDB().getEntryChangeHub().removeListener(this.bioentry_id, cl, ct);
    }

    public boolean isUnchanging(ChangeType ct) {
        return false;
    }
}

