/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import org.biojava.bio.program.das.DASSequence;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

class DASCapabilities {
    private static Map capabilityCache;
    public static final String CAPABILITY_FEATURETABLE = "featureTable";
    public static final String CAPABILITY_FEATURETABLE_DASGFF = "dasgff";
    public static final String CAPABILITY_FEATURETABLE_XFF = "xff";
    public static final String CAPABILITY_EXTENDED = "dasExtendedRequest";
    public static final String CAPABILITY_EXTENDED_FEATURES = "features";
    public static final String CAPABILITY_INDEX = "index";
    public static final String CAPABILITY_SEQUENCE = "sequence";
    private static final Map DEFAULT_CAPABILITIES;

    DASCapabilities() {
    }

    public static boolean checkCapable(URL dasURL, String type) {
        return DASCapabilities.getCapabilities(dasURL).containsKey(type);
    }

    public static boolean checkCapable(URL dasURL, String type, String value) {
        List l = (List)DASCapabilities.getCapabilities(dasURL).get(type);
        if (l == null) {
            return false;
        }
        return l.contains(value);
    }

    public static Map getCapabilities(URL dasURL) {
        Map caps = (Map)capabilityCache.get(dasURL);
        if (caps == null) {
            caps = DASCapabilities.fetchCapabilities(dasURL);
            capabilityCache.put(dasURL, caps);
        }
        return caps;
    }

    private static Map fetchCapabilities(URL dasURL) {
        try {
            HashMap<String, Object> caps = new HashMap<String, Object>();
            URL capURL = new URL(dasURL, "capabilities");
            HttpURLConnection huc = (HttpURLConnection)capURL.openConnection();
            huc.connect();
            int status = huc.getHeaderFieldInt("X-DAS-Status", 0);
            String capHeader = huc.getHeaderField("X-DAS-Capabilities");
            if (capHeader != null) {
                StringTokenizer capToke = new StringTokenizer(capHeader, "; ");
                while (capToke.hasMoreTokens()) {
                    String capString = capToke.nextToken();
                    int slash = capString.indexOf(47);
                    if (slash < 0) continue;
                    caps.put(capString.substring(0, slash).toLowerCase(), capString.substring(slash + 1));
                }
            }
            if (status == 200) {
                InputSource is = new InputSource(huc.getInputStream());
                DocumentBuilder parser = DASSequence.nonvalidatingParser();
                Element el = parser.parse(is).getDocumentElement();
                for (Node n = el.getFirstChild(); n != null; n = n.getNextSibling()) {
                    Element capEl;
                    if (!(n instanceof Element) || !(capEl = (Element)n).getTagName().equals("capability")) continue;
                    String type = capEl.getAttribute("type");
                    String value = capEl.getAttribute("value");
                    if (caps.containsKey(type)) {
                        ((List)caps.get(type)).add(value);
                        continue;
                    }
                    ArrayList<String> l = new ArrayList<String>();
                    l.add(value);
                    caps.put(type, l);
                }
            }
            return Collections.unmodifiableMap(caps);
        }
        catch (Exception ex) {
            return DEFAULT_CAPABILITIES;
        }
    }

    static {
        HashMap<String, List<String>> m = new HashMap<String, List<String>>();
        m.put(CAPABILITY_FEATURETABLE, Collections.nCopies(1, CAPABILITY_FEATURETABLE_DASGFF));
        DEFAULT_CAPABILITIES = Collections.unmodifiableMap(m);
        capabilityCache = new HashMap();
    }
}

