/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.random;

import de.jstacs.utils.random.DiMRGParams;
import de.jstacs.utils.random.MRGParams;
import de.jstacs.utils.random.MultivariateRandomGenerator;
import de.jstacs.utils.random.RandomNumberGenerator;

public class DirichletMRG
extends MultivariateRandomGenerator {
    public static final DirichletMRG DEFAULT_INSTANCE = new DirichletMRG();
    private RandomNumberGenerator r = new RandomNumberGenerator();

    private DirichletMRG() {
    }

    public void generate(double[] d, int start, int n, MRGParams p) {
        DiMRGParams param = (DiMRGParams)p;
        int i = param.getDimension();
        if (i > 0 && i != n) {
            throw new IllegalArgumentException("Hyperparameter doesnot have a correct dimension.");
        }
        double sum = 0.0;
        for (i = 0; i < n; ++i) {
            d[start + i] = this.r.nextGamma(param.getHyperparameter(i), 1.0);
            sum += d[start + i];
        }
        i += start;
        while (start < i) {
            int n2 = start++;
            d[n2] = d[n2] / sum;
        }
    }
}

